/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.SocketException;
import kaffe.net.DefaultDatagramSocketImplFactory;

public class DatagramSocket {
    private static DatagramSocketImplFactory factory = new DefaultDatagramSocketImplFactory();
    protected DatagramSocketImpl impl;

    protected void init(int n, InetAddress inetAddress) throws SocketException {
        this.impl.bind(n, inetAddress);
    }

    public synchronized void close() {
        this.impl.close();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.impl.getOption(4102);
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (Exception exception) {
            return InetAddress.getLoopback();
        }
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            this.impl.receive(datagramPacket);
        }
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        System.getSecurityManager().checkConnect(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            this.impl.send(datagramPacket);
        }
    }

    public DatagramSocket() throws SocketException {
        this(0, null);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        System.getSecurityManager().checkListen(n);
        if (inetAddress == null) {
            inetAddress = InetAddress.getAnyAddress();
        }
        this.impl = factory.createDatagramSocketImpl();
        this.impl.create();
        this.init(n, inetAddress);
    }
}

