/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.util.Random;
import kaffe.util.NotImplemented;
import kaffe.util.Ptr;

public class BigInteger
extends Number {
    private static final long serialVersionUID = -8287574255936472291L;
    private Ptr number;

    public static BigInteger valueOf(long l) {
        return new BigInteger(Long.toString(l));
    }

    public BigInteger add(BigInteger bigInteger) throws ArithmeticException {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.add0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.sub0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mul0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger divide(BigInteger bigInteger) throws ArithmeticException {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.div0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger remainder(BigInteger bigInteger) throws ArithmeticException {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.rem0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) throws ArithmeticException {
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divrem0(bigInteger2, bigInteger3, this, bigInteger);
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    public BigInteger pow(int n) throws ArithmeticException {
        BigInteger bigInteger = new BigInteger();
        bigInteger.pow0(this, n);
        return bigInteger;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.gcd0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger abs() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.abs0(this);
        return bigInteger;
    }

    public BigInteger negate() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.neg0(this);
        return bigInteger;
    }

    public int signum() {
        BigInteger bigInteger = new BigInteger();
        return this.compareTo(bigInteger);
    }

    public BigInteger mod(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mod0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = new BigInteger();
        bigInteger3.modpow0(this, bigInteger, bigInteger2);
        return bigInteger3;
    }

    public BigInteger modInverse(BigInteger bigInteger) throws ArithmeticException {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.modinv0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger shiftLeft(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.mul0(this, bigInteger);
        return bigInteger;
    }

    public BigInteger shiftRight(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.div0(this, bigInteger);
        return bigInteger;
    }

    public BigInteger and(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger or(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.or0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger xor(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.xor0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger not() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.not0(this);
        return bigInteger;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        bigInteger2.not0(bigInteger2);
        return bigInteger2;
    }

    public boolean testBit(int n) throws ArithmeticException {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return BigInteger.cmp0(bigInteger, this) == 0;
    }

    public BigInteger setBit(int n) throws ArithmeticException {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return bigInteger;
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        BigInteger bigInteger = new BigInteger();
        bigInteger.clrbit0(this, n);
        return bigInteger;
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.xor0(bigInteger, this);
        return bigInteger;
    }

    public int getLowestSetBit() {
        return this.scansetbit0();
    }

    public int bitLength() {
        throw new NotImplemented();
    }

    public int bitCount() {
        throw new NotImplemented();
    }

    public boolean isProbablePrime(int n) {
        return this.probablyPrime0(n) != 0;
    }

    public int compareTo(BigInteger bigInteger) {
        int n = BigInteger.cmp0(this, bigInteger);
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        return this.compareTo((BigInteger)object) == 0;
    }

    public BigInteger min(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n > 0) {
            return bigInteger;
        }
        return this;
    }

    public BigInteger max(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n < 0) {
            return bigInteger;
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString(int n) {
        return this.toString0(n);
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        throw new NotImplemented();
    }

    public int intValue() {
        return this.toInt0();
    }

    public long longValue() {
        return Long.valueOf(this.toString());
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        return this.toDouble0();
    }

    protected void finalize() throws Throwable {
        this.finalize0();
        super.finalize();
    }

    private native void init0();

    private native void finalize0();

    private native void assignBytes0(int var1, byte[] var2);

    private native void assignString0(String var1, int var2);

    private native void assignLong0(long var1);

    private native void add0(BigInteger var1, BigInteger var2);

    private native void sub0(BigInteger var1, BigInteger var2);

    private native void mul0(BigInteger var1, BigInteger var2);

    private native void div0(BigInteger var1, BigInteger var2);

    private native void rem0(BigInteger var1, BigInteger var2);

    private native void abs0(BigInteger var1);

    private native void neg0(BigInteger var1);

    private native void pow0(BigInteger var1, int var2);

    private native void gcd0(BigInteger var1, BigInteger var2);

    private native void mod0(BigInteger var1, BigInteger var2);

    private native void modpow0(BigInteger var1, BigInteger var2, BigInteger var3);

    private native void modinv0(BigInteger var1, BigInteger var2);

    private native void and0(BigInteger var1, BigInteger var2);

    private native void or0(BigInteger var1, BigInteger var2);

    private native void xor0(BigInteger var1, BigInteger var2);

    private native void not0(BigInteger var1);

    private native void clrbit0(BigInteger var1, int var2);

    private native void setbit0(BigInteger var1, int var2);

    private native int scansetbit0();

    private native int probablyPrime0(int var1);

    private static native int cmp0(BigInteger var0, BigInteger var1);

    private static native void initialize0();

    private static native void divrem0(BigInteger var0, BigInteger var1, BigInteger var2, BigInteger var3);

    private native String toString0(int var1);

    private native double toDouble0();

    private native int toInt0();

    /* synthetic */ void access$0() {
        this.init0();
    }

    /* synthetic */ void access$1(int n, byte[] byArray) {
        this.assignBytes0(n, byArray);
    }

    public BigInteger(byte[] byArray) throws NumberFormatException {
        this(1, byArray);
    }

    public BigInteger(int n, byte[] byArray) throws NumberFormatException {
        this();
        if (byArray.length != 0) {
            if (n == 0) {
                throw new NumberFormatException();
            }
            this.assignBytes0(n, byArray);
        }
    }

    public BigInteger(String string, int n) throws NumberFormatException {
        this();
        this.assignString0(string, n);
    }

    public BigInteger(String string) throws NumberFormatException {
        this(string, 10);
    }

    public BigInteger(int n, Random random) throws IllegalArgumentException {
        throw new NotImplemented();
    }

    public BigInteger(int n, int n2, Random random) {
        throw new NotImplemented();
    }

    private BigInteger() {
        this.init0();
    }

    static {
        System.loadLibrary("math");
        BigInteger.initialize0();
    }

    class DefaultSerialization {
        private int bitCount;
        private int bitLength;
        private int firstNonzeroByteNum;
        private int lowestSetBit;
        private int signum;
        private byte[] magnitude;

        private void readDefaultObject() {
            BigInteger.this.access$0();
            BigInteger.this.access$1(this.signum, this.magnitude);
        }

        private void writeDefaultObject() {
            this.bitCount = -1;
            this.bitLength = -1;
            this.firstNonzeroByteNum = -2;
            this.lowestSetBit = BigInteger.this.getLowestSetBit();
            this.signum = BigInteger.this.signum();
            this.magnitude = BigInteger.this.toByteArray();
        }

        DefaultSerialization() {
        }
    }
}

