/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        Method method;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            method = (Method)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.clazz != method.clazz) {
            return false;
        }
        if (this.parameterTypes.length != method.parameterTypes.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameterTypes.length) {
            if (this.parameterTypes[n] != method.parameterTypes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public native int getModifiers();

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode() ^ this.name.hashCode();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (Modifier.isPublic(n)) {
            stringBuffer.append("public ");
        } else if (Modifier.isPrivate(n)) {
            stringBuffer.append("private ");
        } else if (Modifier.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (Modifier.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isStatic(n)) {
            stringBuffer.append("static ");
        }
        if (Modifier.isFinal(n)) {
            stringBuffer.append("final ");
        }
        if (Modifier.isSynchronized(n)) {
            stringBuffer.append("synchronized ");
        }
        if (Modifier.isNative(n)) {
            stringBuffer.append("native ");
        }
        stringBuffer.append(Method.getPrettyName(this.returnType));
        stringBuffer.append(" ");
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append(".");
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < this.parameterTypes.length) {
            stringBuffer.append(Method.getPrettyName(this.parameterTypes[n2]));
            if (n2 + 1 < this.parameterTypes.length) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append(")");
        if (this.exceptionTypes.length > 0) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.exceptionTypes.length) {
                stringBuffer.append(this.exceptionTypes[n2].getName());
                if (n2 + 1 < this.exceptionTypes.length) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
        }
        return new String(stringBuffer);
    }

    static String getPrettyName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (!clazz.isArray()) {
                stringBuffer.append(clazz.getName());
                while (n > 0) {
                    stringBuffer.append("[]");
                    --n;
                }
                return stringBuffer.toString();
            }
            clazz = clazz.getComponentType();
            ++n;
        }
    }

    private Method() {
    }
}

