/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.SimpleTimeZone;

public final class System {
    static final SecurityManager defaultSecurityManager;
    public static InputStream in;
    public static PrintStream out;
    public static PrintStream err;
    private static Properties props;
    private static SecurityManager security;

    private static void checkPropertyAccess() {
        System.getSecurityManager().checkPropertiesAccess();
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static Properties getProperties() {
        System.checkPropertyAccess();
        return props;
    }

    public static String getProperty(String string) {
        System.checkPropertyAccess();
        return System.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        System.checkPropertyAccess();
        return props.getProperty(string, string2);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static String getenv(String string) {
        throw new Error("System.getenv no longer supported");
    }

    public static void load(String string) {
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string);
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void setErr(PrintStream printStream) {
        err = printStream;
    }

    public static void setIn(InputStream inputStream) {
        in = inputStream;
    }

    public static void setOut(PrintStream printStream) {
        out = printStream;
    }

    public static void setProperties(Properties properties) {
        System.checkPropertyAccess();
        props = properties;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != defaultSecurityManager) {
            throw new SecurityException();
        }
        if (securityManager != null) {
            security = securityManager;
        }
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    private System() {
    }

    static {
        security = defaultSecurityManager = new NullSecurityManager();
        props = System.initProperties(new Properties());
        new SimpleTimeZone(0, "GMT");
        new GregorianCalendar();
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in), 128);
        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
        err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
    }
}

