/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import kaffe.io.ByteToCharConverter;
import kaffe.io.CharToByteConverter;

public final class String
implements Serializable {
    static final long serialVersionUID = -6849794470754667710L;
    char[] value;
    int offset;
    int count;
    int hash;
    boolean interned;

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.value[this.offset + n];
    }

    public int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = 0;
        while (n2 < n) {
            char c = this.value[this.offset + n2];
            char c2 = string.value[string.offset + n2];
            if (c != c2) {
                return c - c2;
            }
            ++n2;
        }
        return this.count - string.count;
    }

    public String concat(String string) {
        if (string.count == 0) {
            return this;
        }
        char[] cArray = new char[this.count + string.count];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, string.count, cArray, this.count);
        return new String(0, cArray.length, cArray);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray2 = new char[n2];
        if (n2 > 0) {
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        return new String(0, n2, cArray2);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public boolean equals(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + this.count;
        while (n < n3) {
            if (this.value[n] != string.value[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + this.count;
        while (n < n3) {
            if (this.value[n] != string.value[n2] && Character.toUpperCase(this.value[n]) != Character.toUpperCase(string.value[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    private byte[] getBytes(CharToByteConverter charToByteConverter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.value.length);
        byte[] byArray = new byte[512];
        int n = charToByteConverter.convert(this.value, this.offset, this.count, byArray, 0, byArray.length);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = charToByteConverter.flush(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter(string));
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n2 > this.offset + this.count) {
            throw new IndexOutOfBoundsException("");
        }
        int n4 = n2 - n;
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + n5] = (byte)this.value[this.offset + n + n5];
            ++n5;
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public int hashCode() {
        if (this.hash == 0 && this.count > 0) {
            int n = this.offset + this.count;
            int n2 = this.offset;
            while (n2 < n) {
                this.hash = 31 * this.hash + this.value[n2];
                ++n2;
            }
        }
        return this.hash;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(String var1_1, int var2_2) {
        var3_3 = this.offset + var2_2;
        var4_4 = var1_1.offset;
        var5_5 = 0;
        if (var1_1.count <= this.count - var2_2) ** GOTO lbl16
        return -1;
lbl-1000:
        // 1 sources

        {
            if (this.value[var3_3] == var1_1.value[var4_4]) {
                if (++var5_5 == var1_1.count) {
                    return var3_3 - var5_5 - this.offset + 1;
                }
                ++var4_4;
            } else if (var5_5 > 0) {
                --var3_3;
                var5_5 = 0;
                var4_4 = var1_1.offset;
            }
            ++var3_3;
lbl16:
            // 2 sources

            ** while (var3_3 < this.value.length)
        }
lbl17:
        // 1 sources

        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        char c = (char)n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < this.count) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void initString(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[512];
        int n3 = byteToCharConverter.convert(byArray, n, n2, cArray, 0, cArray.length);
        while (n3 > 0) {
            stringBuffer.append(cArray, 0, n3);
            n3 = byteToCharConverter.flush(cArray, 0, cArray.length);
        }
        String string = stringBuffer.toString();
        this.value = string.value;
        n = string.offset;
        this.count = string.count;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = string.offset + string.count - 1;
        int n3 = this.offset + n + n2;
        int n4 = 0;
        if (n3 >= this.offset + this.count) {
            n3 = this.offset + this.count - 1;
        }
        while (n3 >= this.offset) {
            if (this.value[n3] == string.value[n2]) {
                --n2;
                if (++n4 == string.count) {
                    return n3 - this.offset;
                }
            } else if (n4 > 0) {
                ++n3;
                n4 = 0;
                n2 = string.offset + string.count - 1;
            }
            --n3;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        char c = (char)n;
        if (c != n) {
            return -1;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public int length() {
        return this.count;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        if (n + n3 > this.count || n2 + n3 > string.count) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            char c = this.value[this.offset + n + n4];
            char c2 = string.value[string.offset + n2 + n4];
            if (c != c2 && bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(false, n, string, n2, n3);
    }

    public String replace(char c, char c2) {
        char[] cArray = new char[this.count];
        boolean bl = false;
        int n = 0;
        while (n < this.count) {
            char c3 = this.value[this.offset + n];
            if (c3 == c) {
                bl = true;
                cArray[n] = c2;
            } else {
                cArray[n] = c3;
            }
            ++n;
        }
        if (!bl) {
            return this;
        }
        return new String(0, this.count, cArray);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.offset + n, this.offset + n2, this.value);
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        if (this.count > 0) {
            this.getChars(0, this.count, cArray, 0);
        }
        return cArray;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toLowerCase(Locale locale2) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toLowerCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale2) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toUpperCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    /*
     * Unable to fully structure code
     */
    public String trim() {
        var1_1 = this.offset;
        var2_2 = this.offset + this.count - 1;
        while (var1_1 <= var2_2 && this.value[var1_1] <= ' ') {
            ++var1_1;
        }
        if (var1_1 <= var2_2) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --var2_2;
lbl9:
            // 2 sources

            ** while (var2_2 > var1_1 && this.value[var2_2] <= ' ')
        }
lbl10:
        // 1 sources

        return this.substring(var1_1 - this.offset, var2_2 + 1 - this.offset);
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(boolean bl) {
        return new Boolean(bl).toString();
    }

    public static String valueOf(char c) {
        return new String(new char[]{c});
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public String intern() {
        return this.interned ? this : String.intern0(this);
    }

    private static synchronized native String intern0(String var0);

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this(string.value, string.offset, string.count);
    }

    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.count = stringBuffer.length();
            this.value = new char[this.count];
            if (this.count > 0) {
                stringBuffer.getChars(0, this.count, this.value, 0);
            }
        }
    }

    public String(byte[] byArray) {
        this.initString(byArray, 0, byArray.length, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this.initString(byArray, 0, byArray.length, ByteToCharConverter.getConverter(string));
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        this.initString(byArray, n, n2, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this.initString(byArray, n, n2, ByteToCharConverter.getConverter(string));
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.value = new char[n3];
        this.count = n3;
        n = (n & 0xFF) << 8;
        int n4 = 0;
        while (n4 < n3) {
            this.value[n4] = (char)(n | byArray[n4 + n2] & 0xFF);
            ++n4;
        }
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        this.value = new char[n2];
        this.count = n2;
        if (n2 > 0) {
            System.arraycopy(cArray, n, this.value, 0, n2);
        }
    }

    private String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2 - n;
    }
}

