/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = Class.getPrimitiveClass("short");
    private static final long serialVersionUID = 7515723908773894738L;
    private final short value;

    public static Short decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return new Short((short)n);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Short && ((Short)object).value == this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    public static String toString(short s) {
        return Integer.toString(s);
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return new Short(Short.parseShort(string));
    }

    public static Short valueOf(String string, int n) throws NumberFormatException {
        return new Short(Short.parseShort(string, n));
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string);
    }

    public Short(short s) {
        this.value = s;
    }
}

