/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number {
    public static final Class TYPE = Class.getPrimitiveClass("int");
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    private static final long serialVersionUID = 1360826667806852920L;
    private int value;

    public static Integer decode(String string) throws NumberFormatException {
        int n = 1;
        if (string.startsWith("-")) {
            n = -1;
            string = string.substring(1);
        }
        if (string.equals("0")) {
            return new Integer(0);
        }
        int n2 = 10;
        if (string.equals("0")) {
            return new Integer(0);
        }
        if (string.startsWith("0x")) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.startsWith("#")) {
            n2 = 16;
            string = string.substring(1);
        } else if (string.startsWith("0")) {
            n2 = 8;
            string = string.substring(1);
        }
        if (string.startsWith("-")) {
            throw new NumberFormatException();
        }
        return new Integer(Integer.parseUnsignedInt(string, n2, n));
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Integer && ((Integer)object).value == this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer getInteger(String string, Integer n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n;
    }

    public static Integer getInteger(String string, int n) {
        return Integer.getInteger(string, new Integer(n));
    }

    public int hashCode() {
        return this;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null || string.length() <= 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            return Integer.parseUnsignedInt(string.substring(1), n, -1);
        }
        return Integer.parseUnsignedInt(string, n, 1);
    }

    private static int parseUnsignedInt(String string, int n, int n2) throws NumberFormatException {
        if (string == null || string.length() <= 0) {
            throw new NumberFormatException();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = Character.digit(string.charAt(n4), n);
            if (n5 == -1) {
                throw new NumberFormatException();
            }
            int n6 = n3 * n + n2 * n5;
            if (n6 < 0 && n2 == 1) {
                throw new NumberFormatException();
            }
            if (n6 > 0 && n2 == -1) {
                throw new NumberFormatException();
            }
            n3 = n6;
            ++n4;
        }
        return n3;
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int n) {
        return Integer.toString(n, 10);
    }

    public static String toString(int n, int n2) {
        if (n == 0) {
            return "0";
        }
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n < 0 ? -1 : 1;
        while (n != 0) {
            char c = Character.forDigit(Math.abs(n % n2), n2);
            n /= n2;
            stringBuffer.append(c);
        }
        if (n3 == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    private static String toUnsignedString(int n, int n2) {
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1 << n2;
        int n4 = n3 - 1;
        while (n != 0) {
            char c = Character.forDigit(n & n4, n3);
            n >>>= n2;
            stringBuffer.append(c);
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return Integer.valueOf(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string);
    }

    public Integer(int n) {
        this.value = n;
    }
}

