/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    protected static final int PIPE_SIZE = 512;
    PipedOutputStream src = null;
    protected byte[] pipe = new byte[512];
    protected int out = 0;
    protected int in = 0;
    private boolean closed = true;

    public void close() throws IOException {
        this.out = 0;
        this.in = 0;
        this.closed = true;
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        if (this.src != null) {
            throw new IOException("already connected");
        }
        this.src = pipedOutputStream;
        if (pipedOutputStream.sink == null) {
            pipedOutputStream.connect(this);
        }
        this.closed = false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int read() throws IOException {
        if (!this.closed) ** GOTO lbl10
        throw new IOException("stream closed");
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
            }
            catch (InterruptedException var1_1) {
            }
            if (!this.closed) continue;
            return -1;
lbl10:
            // 2 sources

            ** while (this.out == this.in)
        }
lbl11:
        // 1 sources

        var1_2 = this.pipe[this.out];
        this.out = (this.out + 1) % 512;
        this.notifyAll();
        return var1_2 & 255;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void receive(int n) throws IOException {
        while (this.out == this.in + 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.pipe[this.in] = (byte)n;
        this.in = (this.in + 1) % 512;
        this.notifyAll();
    }

    void receivedLast() {
        this.closed = true;
    }

    public PipedInputStream() {
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.connect(pipedOutputStream);
    }
}

