/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n = this.read() << 8;
        if ((n |= this.read()) == -1) {
            throw new EOFException();
        }
        return (char)n;
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public final int readInt() throws IOException {
        int n = this.read() << 24;
        n |= this.read() << 16;
        n |= this.read() << 8;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n | n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2 = super.read();
            char c = (char)(n2 & 0xFF);
            if (n2 == -1) break;
            ++n;
            if (c == '\n') break;
            if (c == '\r') {
                super.mark(1);
                int n3 = super.read();
                if (n3 == -1 || (char)(n3 & 0xFF) == '\n') break;
                try {
                    super.reset();
                }
                catch (IOException iOException) {
                }
                break;
            }
            stringBuffer.append(c);
        }
        if (n == 0) {
            return null;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public final long readLong() throws IOException {
        long l = (long)this.read() << 56;
        l |= (long)this.read() << 48;
        l |= (long)this.read() << 40;
        l |= (long)this.read() << 32;
        l |= (long)this.read() << 24;
        l |= (long)this.read() << 16;
        l |= (long)this.read() << 8;
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return l | (long)n;
    }

    public final short readShort() throws IOException {
        int n = this.read() << 8;
        if ((n |= this.read()) == -1) {
            throw new EOFException();
        }
        return (short)n;
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readUnsignedByte();
            if ((n3 & 0x80) == 128) {
                char c;
                byte by;
                if ((n3 & 0xE0) == 192) {
                    by = dataInput.readByte();
                    if ((by & 0xC0) == 128) {
                        c = (char)(((n3 & 0x1F) << 6) + (by & 0x3F));
                        stringBuffer.append(c);
                        n2 += 2;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((n3 & 0xF0) == 224) {
                    by = dataInput.readByte();
                    if ((by & 0xC0) == 128) {
                        c = dataInput.readByte();
                        if ((c & 0xC0) == 128) {
                            char c2 = (char)(((n3 & 0xF) << 12) + ((by & 0x3F) << 6) + (c & 0x3F));
                            stringBuffer.append(c2);
                            n2 += 3;
                            continue;
                        }
                        throw new UTFDataFormatException();
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        if (n2 > n) {
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.read() << 8;
        if ((n |= this.read()) == -1) {
            throw new EOFException();
        }
        return n;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = (int)this.in.skip(n);
        if (n2 != n) {
            throw new EOFException();
        }
        return n2;
    }

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

