/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static final int DEFAULTBUFFER = 256;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    public synchronized void mark(int n) {
        if (n > this.buf.length) {
            this.buf = new byte[n];
            this.markpos = 0;
            this.count = 0;
            this.pos = 0;
            this.marklimit = n;
        } else if (n > this.buf.length - this.pos) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
            this.count -= this.pos;
            this.markpos = 0;
            this.pos = 0;
        } else {
            this.markpos = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.markpos == -1) {
            return super.read();
        }
        if (this.pos == this.buf.length) {
            this.count = 0;
            this.pos = 0;
            this.markpos = -1;
            return super.read();
        }
        if (this.pos == this.count && !this.fillBuffer()) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.pos == this.buf.length) {
                this.count = 0;
                this.pos = 0;
                this.markpos = -1;
            }
            if (this.markpos == -1) {
                n4 = super.read(byArray, n, n2);
                if (n4 == -1) {
                    return n3 > 0 ? n3 : -1;
                }
                return n3 + n4;
            }
            if (this.pos == this.count && !this.fillBuffer()) {
                return n3 > 0 ? n3 : -1;
            }
            n4 = this.count - this.pos;
            if (n4 > n2) {
                n4 = n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n4);
            n3 += n4;
            this.pos += n4;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos == -1) {
            throw new IOException("Attempt to reset when no mark is valid" + " (marklimit=" + this.marklimit + ")");
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0;
        }
        if (this.markpos == -1) {
            return super.skip(l);
        }
        if (this.pos < this.count) {
            if ((long)(this.count - this.pos) > l) {
                this.pos += (int)l;
            } else {
                l = this.count - this.pos;
                this.pos = this.count;
            }
            return l;
        }
        if (this.pos == this.buf.length) {
            this.count = 0;
            this.pos = 0;
            this.markpos = -1;
            return super.skip(l);
        }
        return this.fillBuffer() ? this.skip(l) : 0L;
    }

    private boolean fillBuffer() throws IOException {
        int n = super.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n <= 0) {
            return false;
        }
        this.count += n;
        return true;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 256);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
        this.count = 0;
        this.pos = 0;
        this.marklimit = n;
        this.markpos = -1;
    }
}

