/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.TooManyListenersException;

public class Introspector {
    private static String[] beansearch = new String[]{"kaffe.beans.infos"};

    public static String decapitalize(String string) {
        if (string.length() > 2 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        if (string.length() > 0) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null);
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.loadBeanInfo(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        if (clazz2 != null) {
            clazz2 = clazz2.getSuperclass();
        }
        if (clazz2 != null && !clazz.isInstance(clazz2)) {
            throw new IntrospectionException("Illegal stop class");
        }
        GenericBeanInfo genericBeanInfo = new GenericBeanInfo(new BeanDescriptor(clazz), Introspector.getProperties(clazz, clazz2), Introspector.getMethods(clazz, clazz2), Introspector.getListeners(clazz, clazz2));
        return genericBeanInfo;
    }

    public static String[] getBeanInfoSearchPath() {
        return beansearch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static EventSetDescriptor[] getListeners(Class eventSetDescriptorArray, Class clazz) throws IntrospectionException {
        String string;
        int n;
        Object object;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        EventSetDescriptor[] eventSetDescriptorArray2 = eventSetDescriptorArray;
        while (eventSetDescriptorArray2 != clazz) {
            object = eventSetDescriptorArray2.getDeclaredMethods();
            n = 0;
            while (n < ((Method[])object).length) {
                if (Modifier.isPublic(object[n].getModifiers()) && !Modifier.isStatic(((Method)object[n]).getModifiers())) {
                    string = ((Method)object[n]).getName();
                    if (string.startsWith("add") && string.endsWith("Listener")) {
                        string = string.substring(3, string.length() - 8);
                        hashtable3.put(string, string);
                        hashtable4.put(string, ((Method)object[n]).getParameterTypes()[0]);
                        if (hashtable.get(string) == null) {
                            hashtable.put(string, object[n]);
                        }
                    } else if (string.startsWith("remove") && string.endsWith("Listener")) {
                        string = string.substring(6, string.length() - 8);
                        hashtable3.put(string, string);
                        if (hashtable2.get(string) == null) {
                            hashtable2.put(string, object[n]);
                        }
                    }
                }
                ++n;
            }
            eventSetDescriptorArray2 = eventSetDescriptorArray2.getSuperclass();
        }
        eventSetDescriptorArray2 = new EventSetDescriptor[hashtable3.size()];
        object = hashtable3.elements();
        n = 0;
        while (n < eventSetDescriptorArray2.length) {
            string = (String)object.nextElement();
            Method method = (Method)hashtable.get(string);
            Method method2 = (Method)hashtable2.get(string);
            Class clazz2 = (Class)hashtable4.get(string);
            if (method != null && method2 != null) {
                eventSetDescriptorArray2[n] = new EventSetDescriptor(Introspector.decapitalize(string), clazz2, new Method[0], method, method2);
                Class[] classArray = method.getExceptionTypes();
                if (classArray != null) {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        try {
                            if (classArray[n2].newInstance() instanceof TooManyListenersException) {
                                eventSetDescriptorArray2[n].setUnicast(true);
                                break;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return eventSetDescriptorArray2;
    }

    private static MethodDescriptor[] getMethods(Class methodDescriptorArray, Class clazz) throws IntrospectionException {
        int n;
        Object object;
        Hashtable hashtable = new Hashtable();
        MethodDescriptor[] methodDescriptorArray2 = methodDescriptorArray;
        while (methodDescriptorArray2 != clazz) {
            object = methodDescriptorArray2.getDeclaredMethods();
            n = 0;
            while (n < ((Method[])object).length) {
                String string;
                if (Modifier.isPublic(object[n].getModifiers()) && hashtable.get(string = object[n].toString()) == null) {
                    hashtable.put(string, object[n]);
                }
                ++n;
            }
            methodDescriptorArray2 = methodDescriptorArray2.getSuperclass();
        }
        methodDescriptorArray2 = new MethodDescriptor[hashtable.size()];
        object = hashtable.elements();
        n = 0;
        while (n < methodDescriptorArray2.length) {
            methodDescriptorArray2[n] = new MethodDescriptor((Method)object.nextElement());
            ++n;
        }
        return methodDescriptorArray2;
    }

    private static PropertyDescriptor[] getProperties(Class propertyDescriptorArray, Class clazz) throws IntrospectionException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray;
        while (propertyDescriptorArray2 != clazz) {
            object4 = propertyDescriptorArray2.getDeclaredMethods();
            n = 0;
            while (n < ((Method[])object4).length) {
                object3 = object4[n];
                int n2 = ((Method)object3).getModifiers();
                if (Modifier.isPublic(n2) && !Modifier.isStatic(n2)) {
                    object2 = ((Method)object3).getName();
                    object = ((Method)object3).getParameterTypes();
                    switch (((Class[])object).length) {
                        case 0: {
                            if (((String)object2).startsWith("get")) {
                                object2 = ((String)object2).substring(3);
                                hashtable5.put(object2, object2);
                                if (hashtable2.get(object2) != null) break;
                                hashtable2.put(object2, object3);
                                break;
                            }
                            if (!((String)object2).startsWith("is")) break;
                            object2 = ((String)object2).substring(2);
                            hashtable5.put(object2, object2);
                            if (hashtable2.get(object2) != null) break;
                            hashtable2.put(object2, object3);
                            break;
                        }
                        case 1: {
                            if (((String)object2).startsWith("set")) {
                                object2 = ((String)object2).substring(3);
                                hashtable5.put(object2, object2);
                                if (hashtable.get(object2) != null) break;
                                hashtable.put(object2, object3);
                                break;
                            }
                            if (!((String)object2).startsWith("get") || object[0] != Integer.TYPE) break;
                            object2 = ((String)object2).substring(3);
                            hashtable5.put(object2, object2);
                            if (hashtable4.get(object2) != null) break;
                            hashtable4.put(object2, object3);
                            break;
                        }
                        case 2: {
                            if (!((String)object2).startsWith("set") || object[0] != Integer.TYPE) break;
                            object2 = ((String)object2).substring(3);
                            hashtable5.put(object2, object2);
                            if (hashtable3.get(object2) != null) break;
                            hashtable3.put(object2, object3);
                        }
                    }
                }
                ++n;
            }
            propertyDescriptorArray2 = propertyDescriptorArray2.getSuperclass();
        }
        propertyDescriptorArray2 = new PropertyDescriptor[hashtable5.size()];
        object4 = hashtable5.elements();
        n = 0;
        while (n < propertyDescriptorArray2.length) {
            object3 = (String)object4.nextElement();
            Method method = (Method)hashtable.get(object3);
            object2 = (Method)hashtable2.get(object3);
            object = (Method)hashtable3.get(object3);
            Method method2 = (Method)hashtable4.get(object3);
            propertyDescriptorArray2[n] = object == null && method2 == null ? new PropertyDescriptor(Introspector.decapitalize((String)object3), (Method)object2, method) : new IndexedPropertyDescriptor(Introspector.decapitalize((String)object3), (Method)object2, method, method2, (Method)object);
            ++n;
        }
        return propertyDescriptorArray2;
    }

    private static BeanInfo loadBeanInfo(Class clazz) {
        String string = clazz.getName();
        BeanInfo beanInfo = Introspector.loadNamedBean(string + "BeanInfo");
        if (beanInfo != null) {
            return beanInfo;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        if (n2 > n) {
            n = n2;
        }
        string = string.substring(n + 1);
        int n3 = 0;
        while (n3 < beansearch.length) {
            beanInfo = Introspector.loadNamedBean(beansearch[n3] + "." + string + "BeanInfo");
            if (beanInfo != null) {
                return beanInfo;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BeanInfo loadNamedBean(String string) {
        try {
            return (BeanInfo)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
        }
        return null;
    }

    public static void setBeanInfoSearchPath(String[] stringArray) {
        beansearch = stringArray;
    }

    private Introspector() {
    }
}

