/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getTransparentPixel();
        int n2 = indexColorModel.getMapSize();
        int n3 = n;
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            byte by;
            int n5 = this.filterRGB(-1, -1, indexColorModel.rgbs[n4]);
            if (n3 == n && n4 != n && (by = (byte)(n5 >> 24)) != 255) {
                n3 = -1;
            }
            nArray[n4] = n5;
            ++n4;
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), nArray, n3);
    }

    public abstract int filterRGB(int var1, int var2, int var3);

    public void filterRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n + n3;
        int n8 = n2 + n4;
        int n9 = n2;
        while (n9 < n8) {
            int n10 = n;
            while (n10 < n7) {
                int n11 = n10 + n9 * n6 + n5;
                nArray[n11] = this.filterRGB(n10, n9, nArray[n11]);
                ++n10;
            }
            ++n9;
        }
        this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
    }

    public void setColorModel(ColorModel colorModel) {
        ColorModel colorModel2 = ColorModel.getRGBdefault();
        if (colorModel instanceof IndexColorModel && this.canFilterIndexColorModel) {
            colorModel2 = this.filterIndexColorModel((IndexColorModel)colorModel);
            this.substituteColorModel(colorModel, colorModel2);
        }
        this.consumer.setColorModel(colorModel2);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, byArray, n5, n6);
        } else {
            int n7 = n + n3;
            int n8 = n2 + n4;
            int[] nArray = new int[byArray.length];
            int n9 = n2;
            while (n9 < n8) {
                int n10 = n;
                while (n10 < n7) {
                    int n11 = n10 + n9 * n6 + n5;
                    nArray[n11] = colorModel.getRGB(byArray[n11]);
                    ++n10;
                }
                ++n9;
            }
            this.filterRGBPixels(n, n2, n3, n4, nArray, 0, n3);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n, n2, n3, n4, this.newmodel, nArray, n5, n6);
        } else {
            int n7 = n + n3;
            int n8 = n2 + n4;
            int[] nArray2 = new int[nArray.length];
            int n9 = n2;
            while (n9 < n8) {
                int n10 = n;
                while (n10 < n7) {
                    int n11 = n10 + n9 * n6 + n5;
                    nArray2[n11] = colorModel.getRGB(nArray[n11]);
                    ++n10;
                }
                ++n9;
            }
            this.filterRGBPixels(n, n2, n3, n4, nArray2, 0, n3);
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }
}

