/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import kaffe.awt.FlavorConverter;
import kaffe.awt.ObjectSelection;
import kaffe.awt.SerializerConverter;

class NativeSelection
implements Transferable {
    static DataFlavor[] textFlavors = new DataFlavor[2];
    static FlavorConverter[] textConverters;
    static DataFlavor[] objectFlavors;
    static FlavorConverter[] objectConverters;
    byte[] data;
    String mimeType;
    DataFlavor[] flavors;
    FlavorConverter[] converters;

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].equals(dataFlavor)) {
                return this.converters[n].importBytes(this.data);
            }
            ++n;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setFlavors() {
        if (this.mimeType.startsWith("text/plain")) {
            this.flavors = textFlavors;
            this.converters = textConverters;
        } else if (this.mimeType.startsWith("application/x-java-serialized-object")) {
            this.flavors = objectFlavors;
            this.converters = objectConverters;
        } else {
            this.flavors = new DataFlavor[0];
            this.converters = new FlavorConverter[0];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("NativeSelection [length: ");
        stringBuffer.append(this.data.length);
        stringBuffer.append(", ");
        int n = 0;
        while (n < 8 && n < this.data.length) {
            stringBuffer.append(Integer.toHexString(this.data[n] & 0xFF));
            stringBuffer.append(' ');
            ++n;
        }
        if (n < this.data.length) {
            stringBuffer.append("...");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    NativeSelection(String string, byte[] byArray) {
        this.mimeType = string;
        this.data = byArray;
        this.setFlavors();
    }

    static {
        NativeSelection.textFlavors[0] = DataFlavor.stringFlavor;
        NativeSelection.textFlavors[1] = DataFlavor.plainTextFlavor;
        textConverters = new FlavorConverter[2];
        NativeSelection.textConverters[0] = new FlavorConverter(){

            public Object importBytes(byte[] byArray) {
                return new String(byArray);
            }

            public byte[] exportObject(Object object) {
                return null;
            }
            {
                this.constructor$0();
            }

            public void constructor$0() {
            }
        };
        NativeSelection.textConverters[1] = new FlavorConverter(){

            public Object importBytes(byte[] byArray) {
                return new ByteArrayInputStream(byArray);
            }

            public byte[] exportObject(Object object) {
                return null;
            }
            {
                this.constructor$0();
            }

            public void constructor$0() {
            }
        };
        objectFlavors = new DataFlavor[1];
        NativeSelection.objectFlavors[0] = ObjectSelection.objectFlavor;
        objectConverters = new FlavorConverter[1];
        NativeSelection.objectConverters[0] = new SerializerConverter();
    }
}

