/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Defaults;
import java.awt.Image;
import java.awt.ImageLoader;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import kaffe.io.AccessibleBAOStream;
import kaffe.util.Ptr;

class ImageNativeProducer
implements ImageProducer {
    Object consumer;
    Object src;
    int off;
    int len;

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == null) {
            this.consumer = imageConsumer;
        } else if (this.consumer instanceof Vector) {
            ((Vector)this.consumer).addElement(imageConsumer);
        } else {
            Vector vector = new Vector(3);
            vector.addElement(this.consumer);
            vector.addElement(imageConsumer);
            this.consumer = vector;
        }
    }

    void imageComplete(int n) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).imageComplete(n);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                ((ImageConsumer)vector.elementAt(n3)).imageComplete(n);
                ++n3;
            }
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.consumer instanceof ImageConsumer) {
            return this.consumer == imageConsumer;
        }
        if (this.consumer instanceof Vector) {
            return ((Vector)this.consumer).contains(imageConsumer);
        }
        return false;
    }

    void produceFrom(File file) {
        Ptr ptr;
        if (file.exists() && (ptr = Toolkit.imgCreateFromFile(file.getAbsolutePath())) != null) {
            this.produceFrom(ptr);
        } else {
            this.imageComplete(5);
        }
    }

    void produceFrom(Ptr ptr) {
        if (this.consumer instanceof ImageLoader) {
            ImageLoader imageLoader = (ImageLoader)this.consumer;
            Image image = imageLoader.img;
            image.nativeData = ptr;
            image.width = Toolkit.imgGetWidth(ptr);
            image.height = Toolkit.imgGetHeight(ptr);
            imageLoader.setDimensions(image.width, image.height);
            imageLoader.imageComplete(Toolkit.imgIsMultiFrame(ptr) ? 2 : 3);
        } else {
            Toolkit.imgProduceImage(this, ptr);
            Toolkit.imgFreeImage(ptr);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void produceFrom(URL uRL) {
        block5: {
            byte[] byArray = new byte[1024];
            try {
                InputStream inputStream = uRL.openStream();
                if (inputStream == null) break block5;
                AccessibleBAOStream accessibleBAOStream = new AccessibleBAOStream(8192);
                while (true) {
                    int n;
                    if ((n = inputStream.read(byArray)) < 0) {
                        inputStream.close();
                        Ptr ptr = Toolkit.imgCreateFromData(accessibleBAOStream.getBuffer(), 0, accessibleBAOStream.size());
                        if (ptr != null) {
                            this.produceFrom(ptr);
                            return;
                        }
                        break;
                    }
                    accessibleBAOStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
            }
        }
        this.imageComplete(5);
    }

    void produceFrom(byte[] byArray, int n, int n2) {
        Ptr ptr = Toolkit.imgCreateFromData(byArray, n, n2);
        if (ptr != null) {
            this.produceFrom(ptr);
        } else {
            this.imageComplete(5);
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == imageConsumer) {
            this.consumer = null;
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            vector.removeElement(imageConsumer);
            if (vector.size() == 1) {
                this.consumer = vector.elementAt(0);
            }
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    void setColorModel(ColorModel colorModel) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setColorModel(colorModel);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ImageConsumer)vector.elementAt(n2)).setColorModel(colorModel);
                ++n2;
            }
        }
    }

    void setDimensions(int n, int n2) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setDimensions(n, n2);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                ((ImageConsumer)vector.elementAt(n4)).setDimensions(n, n2);
                ++n4;
            }
        }
    }

    void setHints(int n) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setHints(n);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                ((ImageConsumer)vector.elementAt(n3)).setHints(n);
                ++n3;
            }
        }
    }

    void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.consumer instanceof ImageConsumer) {
            ((ImageConsumer)this.consumer).setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else if (this.consumer instanceof Vector) {
            Vector vector = (Vector)this.consumer;
            int n7 = vector.size();
            int n8 = 0;
            while (n8 < n7) {
                ((ImageConsumer)vector.elementAt(n8)).setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
                ++n8;
            }
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        if (this.src instanceof File) {
            this.produceFrom((File)this.src);
        } else if (this.src instanceof URL) {
            this.produceFrom((URL)this.src);
        } else if (this.src instanceof byte[]) {
            this.produceFrom((byte[])this.src, this.off, this.len);
        } else {
            System.err.println("unsupported production source: " + this.src.getClass());
        }
        this.removeConsumer(imageConsumer);
    }

    ImageNativeProducer(Image image, File file) {
        this.src = file;
        if (file.exists()) {
            if (file.length() < (long)Defaults.FileImageThreshold) {
                image.flags |= 0x100;
                ImageLoader imageLoader = ImageLoader.syncLoader;
                synchronized (imageLoader) {
                    ImageLoader.syncLoader.img = image;
                    image.producer = this;
                    this.startProduction(ImageLoader.syncLoader);
                }
            }
        } else {
            image.flags = 192;
        }
    }

    ImageNativeProducer(Image image, byte[] byArray, int n, int n2) {
        this.src = byArray;
        this.off = n;
        this.len = n2;
        if (n2 < Defaults.DataImageThreshold) {
            image.flags |= 0x100;
            ImageLoader imageLoader = ImageLoader.syncLoader;
            synchronized (imageLoader) {
                ImageLoader.syncLoader.img = image;
                image.producer = this;
                this.startProduction(ImageLoader.syncLoader);
            }
        }
    }

    ImageNativeProducer(URL uRL) {
        this.src = uRL;
    }
}

