/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.ImageLoader;
import java.awt.ImageNativeProducer;
import java.awt.NativeGraphics;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import kaffe.util.Ptr;
import kaffe.util.VectorSnapshot;

public class Image {
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;
    static final int MASK = 255;
    static final int PRODUCING = 256;
    static final int READY = 291;
    static final int SCREEN = 1024;
    static final int BLOCK_FRAMELOADER = 2048;
    public static final Object UndefinedProperty = class$Ljava$awt$ImageLoader != null ? class$Ljava$awt$ImageLoader : (class$Ljava$awt$ImageLoader = Image.class$("java.awt.ImageLoader"));
    private static /* synthetic */ Class class$Ljava$awt$ImageLoader;
    Ptr nativeData;
    int width = -1;
    int height = -1;
    ImageProducer producer;
    Object observers;
    int flags;
    Hashtable props;
    Image next;

    synchronized void activateFrameLoader() {
        if ((this.flags & 0x800) != 0) {
            this.flags &= 0xFFFFF7FF;
            this.notify();
        }
    }

    void addObserver(ImageObserver imageObserver) {
        if (imageObserver == null) {
            return;
        }
        if (this.observers == null) {
            this.observers = imageObserver;
        } else if (this.observers instanceof Vector) {
            Vector vector = (Vector)this.observers;
            if (!vector.contains(imageObserver)) {
                vector.addElement(imageObserver);
            }
        } else if (imageObserver != this.observers) {
            Vector vector = new Vector(3);
            vector.addElement(this.observers);
            vector.addElement(imageObserver);
            this.observers = vector;
        }
    }

    synchronized int checkImage(int n, int n2, ImageObserver imageObserver, boolean bl) {
        if ((this.flags & 0x30) != 0) {
            if (n > 0 || n2 > 0 && n != this.width && n2 != this.height) {
                this.scale(n, n2);
            }
            if (bl && (this.flags & 0x10) != 0) {
                this.addObserver(imageObserver);
            }
        } else if (bl && (this.flags & 0x100) == 0) {
            this.loadImage(n, n2, imageObserver);
        }
        return this.flags & 0xFF;
    }

    protected void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    public void flush() {
        if (this.nativeData != null && (this.flags & 0x20) != 0) {
            Toolkit.imgFreeImage(this.nativeData);
            this.nativeData = null;
            this.flags = 0;
            this.width = -1;
            this.height = -1;
        }
    }

    public Graphics getGraphics() {
        if ((this.flags & 0x400) == 0 || this.nativeData == null) {
            return null;
        }
        return NativeGraphics.getGraphics(this, this.nativeData, 1, 0, 0, 0, 0, this.width, this.height, Color.black, Color.white, Defaults.WndFont, false);
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if ((this.flags & 2) != 0) {
            return this.height;
        }
        this.loadImage(-1, -1, imageObserver);
        return -1;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (this.props == null) {
            if ((this.flags & 0x30) != 0) {
                return UndefinedProperty;
            }
            if ((this.flags & 0x100) == 0) {
                this.loadImage(-1, -1, imageObserver);
            }
            return null;
        }
        Object object = this.props.get(string);
        if (object == null) {
            return UndefinedProperty;
        }
        return object;
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (this.nativeData == null || n <= 0 || n2 <= 0 || (this.flags & 0x400) != 0 || (this.flags & 0x20) == 0) {
            return null;
        }
        return new Image(this, n, n2);
    }

    public ImageProducer getSource() {
        return this.producer;
    }

    public synchronized int getWidth(ImageObserver imageObserver) {
        if ((this.flags & 1) != 0) {
            return this.width;
        }
        this.loadImage(-1, -1, imageObserver);
        return -1;
    }

    synchronized boolean loadImage(int n, int n2, ImageObserver imageObserver) {
        if ((this.flags & 0x30) != 0) {
            if (n > 0 || n2 > 0 && n != this.width && n2 != this.height) {
                this.scale(n, n2);
            }
            if ((this.flags & 0x10) != 0) {
                this.addObserver(imageObserver);
            }
            return true;
        }
        if ((this.flags & 0x80) != 0) {
            return false;
        }
        if ((this.flags & 0x100) == 0) {
            this.flags |= 0x100;
            if (imageObserver != null) {
                this.addObserver(imageObserver);
            }
            ImageLoader.loadSync(this);
            return true;
        }
        return false;
    }

    void removeObserver(ImageObserver imageObserver) {
        if (this.observers == null || imageObserver == null) {
            return;
        }
        if (this.observers == imageObserver) {
            this.observers = null;
        } else if (this.observers instanceof Vector) {
            Vector vector = (Vector)this.observers;
            vector.removeElement(imageObserver);
            if (vector.size() == 1) {
                this.observers = vector.firstElement();
            }
        }
    }

    private boolean scale(int n, int n2) {
        if ((this.flags & 0x400) != 0 || (this.flags & 0x20) == 0 || this.nativeData == null) {
            return false;
        }
        if (n != this.width || n2 != this.height) {
            Ptr ptr = this.nativeData;
            this.nativeData = Toolkit.imgCreateScaledImage(this.nativeData, n, n2);
            Toolkit.imgFreeImage(ptr);
            this.width = n;
            this.height = n2;
        }
        return true;
    }

    synchronized void stateChange(int n, int n2, int n3, int n4, int n5) {
        this.flags |= n;
        if (this.observers == null) {
            return;
        }
        if (this.observers instanceof ImageObserver) {
            ImageObserver imageObserver = (ImageObserver)this.observers;
            if (!imageObserver.imageUpdate(this, n, n2, n3, n4, n5)) {
                this.observers = null;
            }
        } else if (this.observers instanceof Vector) {
            VectorSnapshot vectorSnapshot = VectorSnapshot.getCached((Vector)this.observers);
            while (vectorSnapshot.hasMoreElements()) {
                ImageObserver imageObserver = (ImageObserver)vectorSnapshot.nextElement();
                if (imageObserver.imageUpdate(this, n, n2, n3, n4, n5)) continue;
                this.removeObserver(imageObserver);
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName() + " [" + this.width + ',' + this.height + (this.nativeData != null ? ", native" : ", non-native") + ", flags: " + Integer.toHexString(this.flags);
        if ((this.flags & 0x100) != 0) {
            string = string + " producing";
        }
        if ((this.flags & 0x20) != 0) {
            string = string + " allbits";
        } else if ((this.flags & 0x10) != 0) {
            string = string + " framebits";
        } else if ((this.flags & 0x40) != 0) {
            string = string + " error";
        }
        string = string + "]";
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Image(File file) {
        this.producer = new ImageNativeProducer(this, file);
    }

    Image(Image image, int n, int n2) {
        this.nativeData = Toolkit.imgCreateScaledImage(image.nativeData, n, n2);
        this.width = n;
        this.height = n2;
        this.flags = 291;
    }

    Image(ImageProducer imageProducer) {
        this.producer = imageProducer;
        if (Defaults.MemImageSrcThreshold == 0 && this.producer instanceof MemoryImageSource) {
            this.flags |= 0x100;
            ImageLoader imageLoader = ImageLoader.syncLoader;
            synchronized (imageLoader) {
                ImageLoader.syncLoader.img = this;
                imageProducer.startProduction(ImageLoader.syncLoader);
            }
        }
    }

    Image(URL uRL) {
        this.producer = new ImageNativeProducer(uRL);
    }

    Image(byte[] byArray, int n, int n2) {
        this.producer = new ImageNativeProducer(this, byArray, n, n2);
    }

    Image(int n, int n2) {
        this.nativeData = Toolkit.imgCreateScreenImage(n, n2);
        this.width = n;
        this.height = n2;
        this.flags = 1315;
    }
}

