/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Hashtable;
import kaffe.util.Ptr;

public class FontMetrics
implements Serializable {
    static transient Hashtable cache = new Hashtable();
    private static final long serialVersionUID = 1681126225205050147L;
    transient Ptr nativeData;
    protected Font font;
    transient int height;
    transient int descent;
    transient int ascent;
    transient int leading;
    transient int maxAdvance;
    transient int maxDescent;
    transient int maxAscent;
    transient int fixedWidth;
    transient int[] widths;
    transient boolean isWideFont;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int bytesWidth(byte[] byArray, int n, int n2) {
        if (this.fixedWidth != 0) {
            return n2 * this.fixedWidth;
        }
        if (this.isWideFont) return Toolkit.fntBytesWidth(this.nativeData, byArray, n, n2);
        int n3 = n + n2;
        try {
            int n4 = n;
            int n5 = 0;
            while (true) {
                if (n4 >= n3) {
                    return n5;
                }
                n5 += this.widths[byArray[n4]];
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public int charWidth(char c) {
        if (this.fixedWidth != 0) {
            return this.fixedWidth;
        }
        if (c < '\u0100') {
            return this.widths[c];
        }
        return Toolkit.fntCharWidth(this.nativeData, c);
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int charsWidth(char[] cArray, int n, int n2) {
        if (this.fixedWidth != 0) {
            return n2 * this.fixedWidth;
        }
        if (this.isWideFont) return Toolkit.fntCharsWidth(this.nativeData, cArray, n, n2);
        int n3 = n + n2;
        try {
            int n4 = n;
            int n5 = 0;
            while (true) {
                if (n4 >= n3) {
                    return n5;
                }
                n5 += this.widths[cArray[n4]];
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    protected void finalize() throws Throwable {
        if (this.nativeData != null) {
            Toolkit.fntFreeFontMetrics(this.nativeData);
            this.nativeData = null;
        }
        super.finalize();
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public Font getFont() {
        return this.font;
    }

    static FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)cache.get(font);
        if (fontMetrics == null) {
            fontMetrics = new FontMetrics(font);
            cache.put(font, fontMetrics);
        }
        return fontMetrics;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public int stringWidth(String string) {
        return Toolkit.fntStringWidth(this.nativeData, string);
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.font + ',' + this.ascent + ',' + this.descent + ',' + this.height + ']';
    }

    FontMetrics(Font font) {
        this.font = font;
        this.nativeData = Toolkit.fntInitFontMetrics(this.font.nativeData);
        this.height = Toolkit.fntGetHeight(this.nativeData);
        this.descent = Toolkit.fntGetDescent(this.nativeData);
        this.maxDescent = Toolkit.fntGetMaxDescent(this.nativeData);
        this.ascent = Toolkit.fntGetAscent(this.nativeData);
        this.leading = Toolkit.fntGetLeading(this.nativeData);
        this.maxAscent = Toolkit.fntGetMaxAscent(this.nativeData);
        this.maxAdvance = Toolkit.fntGetMaxAdvance(this.nativeData);
        this.fixedWidth = Toolkit.fntGetFixedWidth(this.nativeData);
        this.widths = Toolkit.fntGetWidths(this.nativeData);
        this.isWideFont = Toolkit.fntIsWideFont(this.nativeData);
    }
}

