/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.ItemEvt;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    private static final long serialVersionUID = 6190621106981774043L;
    boolean isChecked;
    ItemListener iListener;

    public void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.isChecked) {
            Object[] objectArray = new Object[]{this.getLabel()};
            return objectArray;
        }
        return null;
    }

    public boolean getState() {
        return this.isChecked;
    }

    int getWidth() {
        int n = super.getWidth();
        return n += 3 * this.getHeight() / 4;
    }

    public void handleShortcut(MenuShortcut menuShortcut) {
        this.setState(!this.isChecked);
        if (this.hasToNotify(this.iListener)) {
            ItemEvt itemEvt = ItemEvt.getEvent(this, 701, this.getLabel(), this.isChecked ? 1 : 2);
            Toolkit.eventQueue.postEvent(itemEvt);
        }
    }

    int paint(Graphics graphics, int n, int n2, int n3, Color color, Color color2, boolean bl) {
        int n4 = this.getHeight();
        graphics.setColor(Defaults.BtnClr);
        graphics.fill3DRect(n, n2 + n4 / 5, n4 / 2, n4 / 2, !this.isChecked);
        return super.paint(graphics, n += 3 * n4 / 4, n2, n3, color, color2, bl);
    }

    public String paramString() {
        return super.paramString() + ", " + (this.isChecked ? "checked" : "unchecked");
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.hasToNotify(this.iListener)) {
            this.iListener.itemStateChanged(itemEvent);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public synchronized void setState(boolean bl) {
        this.isChecked = bl;
    }

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.isChecked = bl;
    }
}

