/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemEvt;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Checkbox
extends Component
implements ItemSelectable,
MouseListener,
FocusListener,
KeyListener {
    private static final long serialVersionUID = 7270714317450821763L;
    static int CHECKED = 1;
    static int HILIGHTED = 2;
    CheckboxGroup group;
    int state;
    String label;
    ItemListener iListener;

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
        this.eventMask |= 0x200;
    }

    void drawButton(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor((this.state & HILIGHTED) > 0 ? Defaults.BtnPointClr : Defaults.BtnClr);
        graphics.fill3DRect(n2, n3, n, n, true);
        if (this.label.endsWith(" ")) {
            this.paintBorder(graphics);
        } else {
            int n4 = 2;
            this.paintBorder(graphics, n2 - n4, n3 - n4, this.width - (n2 + n + n4), this.height - (n3 + n + n4));
        }
    }

    void drawCheckMark(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.black);
        graphics.drawLine(n2 + 3, n3 + 4, n2 + n - 5, n3 + n - 4);
        graphics.drawLine(n2 + 2, n3 + n - 4, n2 + n - 5, n3 + 3);
        graphics.setColor(Color.white);
        graphics.drawLine(n2 + 3, n3 + 3, n2 + n - 4, n3 + n - 4);
        graphics.drawLine(n2 + 3, n3 + n - 4, n2 + n - 4, n3 + 3);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.state |= HILIGHTED;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.state &= ~HILIGHTED;
        this.repaint();
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = (this.state & CHECKED) > 0 ? new Object[]{this} : new Object[]{};
        return objectArray;
    }

    public boolean getState() {
        return (this.state & CHECKED) > 0;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\n': 
            case ' ': {
                if ((this.state & CHECKED) > 0 && this.group != null) {
                    return;
                }
                this.setState((this.state & CHECKED) == 0);
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.state |= HILIGHTED;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.state &= ~HILIGHTED;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if ((this.state & CHECKED) > 0 && this.group != null) {
            return;
        }
        this.setState((this.state & CHECKED) == 0);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyItem() {
        if (Component.hasToNotify(this, 512, this.iListener)) {
            int n = (this.state & CHECKED) > 0 ? 1 : 2;
            ItemEvt itemEvt = ItemEvt.getEvent(this, 701, this.label, n);
            Toolkit.eventQueue.postEvent(itemEvt);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n3 = n2 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        int n5 = n = fontMetrics.charWidth('x');
        int n6 = (this.height - n3) / 2;
        graphics.setColor(this.bgClr);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawButton(graphics, n3, n5, n6);
        if ((this.state & CHECKED) > 0) {
            this.drawCheckMark(graphics, n3, n5, n6);
        }
        Color color = (this.state & HILIGHTED) > 0 ? Defaults.FocusClr : this.getForeground();
        Color color2 = Color.white;
        graphics.setColor(color2);
        graphics.drawString(this.label, (n5 += n3 + n) + 1, (n6 += n3 / 2 + n2 / 2 - n4) + 1);
        graphics.setColor(color);
        graphics.drawString(this.label, n5, n6);
    }

    protected String paramString() {
        return super.paramString();
    }

    public Dimension preferredSize() {
        int n = 50;
        int n2 = 20;
        if (this.font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = Math.max(n, fontMetrics.stringWidth(this.label) + 2 * fontMetrics.getHeight());
            n2 = Math.max(n2, 3 * fontMetrics.getHeight() / 2);
        }
        return new Dimension(n, n2);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        this.iListener.itemStateChanged(itemEvent);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        if (this.group == checkboxGroup) {
            return;
        }
        if (this.group != null) {
            this.group.boxes.removeElement(this);
        }
        this.group = checkboxGroup;
        if (this.group != null) {
            this.group.boxes.addElement(this);
        }
    }

    public synchronized void setLabel(String string) {
        String string2 = this.label = string == null ? "" : string;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setState(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.state & CHECKED) > 0;
        if (bl2 == bl) {
            return;
        }
        if (bl && this.group != null) {
            this.group.setSelectedCheckbox(this);
        } else {
            this.state = bl ? (this.state |= CHECKED) : (this.state &= ~CHECKED);
            if (this.isShowing()) {
                this.repaint();
            }
            this.notifyItem();
        }
    }

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String string) {
        this(string, false, null);
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl) {
        this(string, bl, checkboxGroup);
    }

    public Checkbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public Checkbox(String string, boolean bl, CheckboxGroup checkboxGroup) {
        this.label = string == null ? "" : string;
        this.setCheckboxGroup(checkboxGroup);
        this.setState(bl);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setFont(Defaults.TextFont);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }
}

