/*	$OpenBSD$	*/

/*
 * Copyright (c) 1996 SigmaSoft, Th. Lockert <tholo@sigmasoft.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by SigmaSoft, Th.  Lockert.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TERM_H_
#define _TERM_H_

#include <termios.h>
#include <sys/ioctl.h>

#define	auto_left_margin              	(cur_term->bools[0])
#define	auto_right_margin             	(cur_term->bools[1])
#define	no_esc_ctlc                   	(cur_term->bools[2])
#define	ceol_standout_glitch          	(cur_term->bools[3])
#define	eat_newline_glitch            	(cur_term->bools[4])
#define	erase_overstrike              	(cur_term->bools[5])
#define	generic_type                  	(cur_term->bools[6])
#define	hard_copy                     	(cur_term->bools[7])
#define	has_meta_key                  	(cur_term->bools[8])
#define	has_status_line               	(cur_term->bools[9])
#define	insert_null_glitch            	(cur_term->bools[10])
#define	memory_above                  	(cur_term->bools[11])
#define	memory_below                  	(cur_term->bools[12])
#define	move_insert_mode              	(cur_term->bools[13])
#define	move_standout_mode            	(cur_term->bools[14])
#define	over_strike                   	(cur_term->bools[15])
#define	status_line_esc_ok            	(cur_term->bools[16])
#define	dest_tabs_magic_smso          	(cur_term->bools[17])
#define	tilde_glitch                  	(cur_term->bools[18])
#define	transparent_underline         	(cur_term->bools[19])
#define	xon_xoff                      	(cur_term->bools[20])
#define	needs_xon_xoff                	(cur_term->bools[21])
#define	prtr_silent                   	(cur_term->bools[22])
#define	hard_cursor                   	(cur_term->bools[23])
#define	non_rev_rmcup                 	(cur_term->bools[24])
#define	no_pad_char                   	(cur_term->bools[25])
#define	non_dest_scroll_region        	(cur_term->bools[26])
#define	can_change                    	(cur_term->bools[27])
#define	back_color_erase              	(cur_term->bools[28])
#define	hue_lightness_saturation      	(cur_term->bools[29])
#define	cool_addr_glitch              	(cur_term->bools[30])
#define	cr_cancels_micro_mode         	(cur_term->bools[31])
#define	has_print_wheel               	(cur_term->bools[32])
#define	row_addr_glitch               	(cur_term->bools[33])
#define	semi_auto_right_margin        	(cur_term->bools[34])
#define	cpi_changes_res               	(cur_term->bools[35])
#define	lpi_changes_res               	(cur_term->bools[36])
#define	columns                       	(cur_term->nums[0])
#define	init_tabs                     	(cur_term->nums[1])
#define	lines                         	(cur_term->nums[2])
#define	lines_of_memory               	(cur_term->nums[3])
#define	magic_cookie_glitch           	(cur_term->nums[4])
#define	padding_baud_rate             	(cur_term->nums[5])
#define	virtual_terminal              	(cur_term->nums[6])
#define	width_status_line             	(cur_term->nums[7])
#define	num_labels                    	(cur_term->nums[8])
#define	label_height                  	(cur_term->nums[9])
#define	label_width                   	(cur_term->nums[10])
#define	max_attributes                	(cur_term->nums[11])
#define	maximum_windows               	(cur_term->nums[12])
#define	max_colors                    	(cur_term->nums[13])
#define	max_pairs                     	(cur_term->nums[14])
#define	no_color_video                	(cur_term->nums[15])
#define	back_tab                      	(cur_term->strs[0])
#define	bell                          	(cur_term->strs[1])
#define	carriage_return               	(cur_term->strs[2])
#define	change_scroll_region          	(cur_term->strs[3])
#define	clear_all_tabs                	(cur_term->strs[4])
#define	clear_screen                  	(cur_term->strs[5])
#define	clr_eol                       	(cur_term->strs[6])
#define	clr_eos                       	(cur_term->strs[7])
#define	column_address                	(cur_term->strs[8])
#define	command_character             	(cur_term->strs[9])
#define	cursor_address                	(cur_term->strs[10])
#define	cursor_down                   	(cur_term->strs[11])
#define	cursor_home                   	(cur_term->strs[12])
#define	cursor_invisible              	(cur_term->strs[13])
#define	cursor_left                   	(cur_term->strs[14])
#define	cursor_mem_address            	(cur_term->strs[15])
#define	cursor_normal                 	(cur_term->strs[16])
#define	cursor_right                  	(cur_term->strs[17])
#define	cursor_to_ll                  	(cur_term->strs[18])
#define	cursor_up                     	(cur_term->strs[19])
#define	cursor_visible                	(cur_term->strs[20])
#define	delete_character              	(cur_term->strs[21])
#define	delete_line                   	(cur_term->strs[22])
#define	dis_status_line               	(cur_term->strs[23])
#define	down_half_line                	(cur_term->strs[24])
#define	enter_alt_charset_mode        	(cur_term->strs[25])
#define	enter_blink_mode              	(cur_term->strs[26])
#define	enter_bold_mode               	(cur_term->strs[27])
#define	enter_ca_mode                 	(cur_term->strs[28])
#define	enter_delete_mode             	(cur_term->strs[29])
#define	enter_dim_mode                	(cur_term->strs[30])
#define	enter_insert_mode             	(cur_term->strs[31])
#define	enter_secure_mode             	(cur_term->strs[32])
#define	enter_protected_mode          	(cur_term->strs[33])
#define	enter_reverse_mode            	(cur_term->strs[34])
#define	enter_standout_mode           	(cur_term->strs[35])
#define	enter_underline_mode          	(cur_term->strs[36])
#define	erase_chars                   	(cur_term->strs[37])
#define	exit_alt_charset_mode         	(cur_term->strs[38])
#define	exit_attribute_mode           	(cur_term->strs[39])
#define	exit_ca_mode                  	(cur_term->strs[40])
#define	exit_delete_mode              	(cur_term->strs[41])
#define	exit_insert_mode              	(cur_term->strs[42])
#define	exit_standout_mode            	(cur_term->strs[43])
#define	exit_underline_mode           	(cur_term->strs[44])
#define	flash_screen                  	(cur_term->strs[45])
#define	form_feed                     	(cur_term->strs[46])
#define	from_status_line              	(cur_term->strs[47])
#define	init_1string                  	(cur_term->strs[48])
#define	init_2string                  	(cur_term->strs[49])
#define	init_3string                  	(cur_term->strs[50])
#define	init_file                     	(cur_term->strs[51])
#define	insert_character              	(cur_term->strs[52])
#define	insert_line                   	(cur_term->strs[53])
#define	insert_padding                	(cur_term->strs[54])
#define	key_backspace                 	(cur_term->strs[55])
#define	key_catab                     	(cur_term->strs[56])
#define	key_clear                     	(cur_term->strs[57])
#define	key_ctab                      	(cur_term->strs[58])
#define	key_dc                        	(cur_term->strs[59])
#define	key_dl                        	(cur_term->strs[60])
#define	key_down                      	(cur_term->strs[61])
#define	key_eic                       	(cur_term->strs[62])
#define	key_eol                       	(cur_term->strs[63])
#define	key_eos                       	(cur_term->strs[64])
#define	key_f0                        	(cur_term->strs[65])
#define	key_f1                        	(cur_term->strs[66])
#define	key_f10                       	(cur_term->strs[67])
#define	key_f2                        	(cur_term->strs[68])
#define	key_f3                        	(cur_term->strs[69])
#define	key_f4                        	(cur_term->strs[70])
#define	key_f5                        	(cur_term->strs[71])
#define	key_f6                        	(cur_term->strs[72])
#define	key_f7                        	(cur_term->strs[73])
#define	key_f8                        	(cur_term->strs[74])
#define	key_f9                        	(cur_term->strs[75])
#define	key_home                      	(cur_term->strs[76])
#define	key_ic                        	(cur_term->strs[77])
#define	key_il                        	(cur_term->strs[78])
#define	key_left                      	(cur_term->strs[79])
#define	key_ll                        	(cur_term->strs[80])
#define	key_npage                     	(cur_term->strs[81])
#define	key_ppage                     	(cur_term->strs[82])
#define	key_right                     	(cur_term->strs[83])
#define	key_sf                        	(cur_term->strs[84])
#define	key_sr                        	(cur_term->strs[85])
#define	key_stab                      	(cur_term->strs[86])
#define	key_up                        	(cur_term->strs[87])
#define	keypad_local                  	(cur_term->strs[88])
#define	keypad_xmit                   	(cur_term->strs[89])
#define	lab_f0                        	(cur_term->strs[90])
#define	lab_f1                        	(cur_term->strs[91])
#define	lab_f10                       	(cur_term->strs[92])
#define	lab_f2                        	(cur_term->strs[93])
#define	lab_f3                        	(cur_term->strs[94])
#define	lab_f4                        	(cur_term->strs[95])
#define	lab_f5                        	(cur_term->strs[96])
#define	lab_f6                        	(cur_term->strs[97])
#define	lab_f7                        	(cur_term->strs[98])
#define	lab_f8                        	(cur_term->strs[99])
#define	lab_f9                        	(cur_term->strs[100])
#define	meta_off                      	(cur_term->strs[101])
#define	meta_on                       	(cur_term->strs[102])
#define	newline                       	(cur_term->strs[103])
#define	pad_char                      	(cur_term->strs[104])
#define	parm_dch                      	(cur_term->strs[105])
#define	parm_delete_line              	(cur_term->strs[106])
#define	parm_down_cursor              	(cur_term->strs[107])
#define	parm_ich                      	(cur_term->strs[108])
#define	parm_index                    	(cur_term->strs[109])
#define	parm_insert_line              	(cur_term->strs[110])
#define	parm_left_cursor              	(cur_term->strs[111])
#define	parm_right_cursor             	(cur_term->strs[112])
#define	parm_rindex                   	(cur_term->strs[113])
#define	parm_up_cursor                	(cur_term->strs[114])
#define	pkey_key                      	(cur_term->strs[115])
#define	pkey_local                    	(cur_term->strs[116])
#define	pkey_xmit                     	(cur_term->strs[117])
#define	print_screen                  	(cur_term->strs[118])
#define	prtr_off                      	(cur_term->strs[119])
#define	prtr_on                       	(cur_term->strs[120])
#define	repeat_char                   	(cur_term->strs[121])
#define	reset_1string                 	(cur_term->strs[122])
#define	reset_2string                 	(cur_term->strs[123])
#define	reset_3string                 	(cur_term->strs[124])
#define	reset_file                    	(cur_term->strs[125])
#define	restore_cursor                	(cur_term->strs[126])
#define	row_address                   	(cur_term->strs[127])
#define	save_cursor                   	(cur_term->strs[128])
#define	scroll_forward                	(cur_term->strs[129])
#define	scroll_reverse                	(cur_term->strs[130])
#define	set_attributes                	(cur_term->strs[131])
#define	set_tab                       	(cur_term->strs[132])
#define	set_window                    	(cur_term->strs[133])
#define	tab                           	(cur_term->strs[134])
#define	to_status_line                	(cur_term->strs[135])
#define	underline_char                	(cur_term->strs[136])
#define	up_half_line                  	(cur_term->strs[137])
#define	init_prog                     	(cur_term->strs[138])
#define	key_a1                        	(cur_term->strs[139])
#define	key_a3                        	(cur_term->strs[140])
#define	key_b2                        	(cur_term->strs[141])
#define	key_c1                        	(cur_term->strs[142])
#define	key_c3                        	(cur_term->strs[143])
#define	prtr_non                      	(cur_term->strs[144])
#define	buffer_capacity               	(cur_term->nums[16])
#define	dot_vert_spacing              	(cur_term->nums[17])
#define	dot_horz_spacing              	(cur_term->nums[18])
#define	max_micro_address             	(cur_term->nums[19])
#define	max_micro_jump                	(cur_term->nums[20])
#define	micro_char_size               	(cur_term->nums[21])
#define	micro_line_size               	(cur_term->nums[22])
#define	number_of_pins                	(cur_term->nums[23])
#define	output_res_char               	(cur_term->nums[24])
#define	output_res_line               	(cur_term->nums[25])
#define	output_res_horz_inch          	(cur_term->nums[26])
#define	output_res_vert_inch          	(cur_term->nums[27])
#define	print_rate                    	(cur_term->nums[28])
#define	wide_char_size                	(cur_term->nums[29])
#define	buttons                       	(cur_term->nums[30])
#define	bit_image_entwining           	(cur_term->nums[31])
#define	bit_image_type                	(cur_term->nums[32])
#define	char_padding                  	(cur_term->strs[145])
#define	acs_chars                     	(cur_term->strs[146])
#define	plab_norm                     	(cur_term->strs[147])
#define	key_btab                      	(cur_term->strs[148])
#define	enter_xon_mode                	(cur_term->strs[149])
#define	exit_xon_mode                 	(cur_term->strs[150])
#define	enter_am_mode                 	(cur_term->strs[151])
#define	exit_am_mode                  	(cur_term->strs[152])
#define	xon_character                 	(cur_term->strs[153])
#define	xoff_character                	(cur_term->strs[154])
#define	ena_acs                       	(cur_term->strs[155])
#define	label_on                      	(cur_term->strs[156])
#define	label_off                     	(cur_term->strs[157])
#define	key_beg                       	(cur_term->strs[158])
#define	key_cancel                    	(cur_term->strs[159])
#define	key_close                     	(cur_term->strs[160])
#define	key_command                   	(cur_term->strs[161])
#define	key_copy                      	(cur_term->strs[162])
#define	key_create                    	(cur_term->strs[163])
#define	key_end                       	(cur_term->strs[164])
#define	key_enter                     	(cur_term->strs[165])
#define	key_exit                      	(cur_term->strs[166])
#define	key_find                      	(cur_term->strs[167])
#define	key_help                      	(cur_term->strs[168])
#define	key_mark                      	(cur_term->strs[169])
#define	key_message                   	(cur_term->strs[170])
#define	key_move                      	(cur_term->strs[171])
#define	key_next                      	(cur_term->strs[172])
#define	key_open                      	(cur_term->strs[173])
#define	key_options                   	(cur_term->strs[174])
#define	key_previous                  	(cur_term->strs[175])
#define	key_print                     	(cur_term->strs[176])
#define	key_redo                      	(cur_term->strs[177])
#define	key_reference                 	(cur_term->strs[178])
#define	key_refresh                   	(cur_term->strs[179])
#define	key_replace                   	(cur_term->strs[180])
#define	key_restart                   	(cur_term->strs[181])
#define	key_resume                    	(cur_term->strs[182])
#define	key_save                      	(cur_term->strs[183])
#define	key_suspend                   	(cur_term->strs[184])
#define	key_undo                      	(cur_term->strs[185])
#define	key_sbeg                      	(cur_term->strs[186])
#define	key_scancel                   	(cur_term->strs[187])
#define	key_scommand                  	(cur_term->strs[188])
#define	key_scopy                     	(cur_term->strs[189])
#define	key_screate                   	(cur_term->strs[190])
#define	key_sdc                       	(cur_term->strs[191])
#define	key_sdl                       	(cur_term->strs[192])
#define	key_select                    	(cur_term->strs[193])
#define	key_send                      	(cur_term->strs[194])
#define	key_seol                      	(cur_term->strs[195])
#define	key_sexit                     	(cur_term->strs[196])
#define	key_sfind                     	(cur_term->strs[197])
#define	key_shelp                     	(cur_term->strs[198])
#define	key_shome                     	(cur_term->strs[199])
#define	key_sic                       	(cur_term->strs[200])
#define	key_sleft                     	(cur_term->strs[201])
#define	key_smessage                  	(cur_term->strs[202])
#define	key_smove                     	(cur_term->strs[203])
#define	key_snext                     	(cur_term->strs[204])
#define	key_soptions                  	(cur_term->strs[205])
#define	key_sprevious                 	(cur_term->strs[206])
#define	key_sprint                    	(cur_term->strs[207])
#define	key_sredo                     	(cur_term->strs[208])
#define	key_sreplace                  	(cur_term->strs[209])
#define	key_sright                    	(cur_term->strs[210])
#define	key_srsume                    	(cur_term->strs[211])
#define	key_ssave                     	(cur_term->strs[212])
#define	key_ssuspend                  	(cur_term->strs[213])
#define	key_sundo                     	(cur_term->strs[214])
#define	req_for_input                 	(cur_term->strs[215])
#define	key_f11                       	(cur_term->strs[216])
#define	key_f12                       	(cur_term->strs[217])
#define	key_f13                       	(cur_term->strs[218])
#define	key_f14                       	(cur_term->strs[219])
#define	key_f15                       	(cur_term->strs[220])
#define	key_f16                       	(cur_term->strs[221])
#define	key_f17                       	(cur_term->strs[222])
#define	key_f18                       	(cur_term->strs[223])
#define	key_f19                       	(cur_term->strs[224])
#define	key_f20                       	(cur_term->strs[225])
#define	key_f21                       	(cur_term->strs[226])
#define	key_f22                       	(cur_term->strs[227])
#define	key_f23                       	(cur_term->strs[228])
#define	key_f24                       	(cur_term->strs[229])
#define	key_f25                       	(cur_term->strs[230])
#define	key_f26                       	(cur_term->strs[231])
#define	key_f27                       	(cur_term->strs[232])
#define	key_f28                       	(cur_term->strs[233])
#define	key_f29                       	(cur_term->strs[234])
#define	key_f30                       	(cur_term->strs[235])
#define	key_f31                       	(cur_term->strs[236])
#define	key_f32                       	(cur_term->strs[237])
#define	key_f33                       	(cur_term->strs[238])
#define	key_f34                       	(cur_term->strs[239])
#define	key_f35                       	(cur_term->strs[240])
#define	key_f36                       	(cur_term->strs[241])
#define	key_f37                       	(cur_term->strs[242])
#define	key_f38                       	(cur_term->strs[243])
#define	key_f39                       	(cur_term->strs[244])
#define	key_f40                       	(cur_term->strs[245])
#define	key_f41                       	(cur_term->strs[246])
#define	key_f42                       	(cur_term->strs[247])
#define	key_f43                       	(cur_term->strs[248])
#define	key_f44                       	(cur_term->strs[249])
#define	key_f45                       	(cur_term->strs[250])
#define	key_f46                       	(cur_term->strs[251])
#define	key_f47                       	(cur_term->strs[252])
#define	key_f48                       	(cur_term->strs[253])
#define	key_f49                       	(cur_term->strs[254])
#define	key_f50                       	(cur_term->strs[255])
#define	key_f51                       	(cur_term->strs[256])
#define	key_f52                       	(cur_term->strs[257])
#define	key_f53                       	(cur_term->strs[258])
#define	key_f54                       	(cur_term->strs[259])
#define	key_f55                       	(cur_term->strs[260])
#define	key_f56                       	(cur_term->strs[261])
#define	key_f57                       	(cur_term->strs[262])
#define	key_f58                       	(cur_term->strs[263])
#define	key_f59                       	(cur_term->strs[264])
#define	key_f60                       	(cur_term->strs[265])
#define	key_f61                       	(cur_term->strs[266])
#define	key_f62                       	(cur_term->strs[267])
#define	key_f63                       	(cur_term->strs[268])
#define	clr_bol                       	(cur_term->strs[269])
#define	clear_margins                 	(cur_term->strs[270])
#define	set_left_margin               	(cur_term->strs[271])
#define	set_right_margin              	(cur_term->strs[272])
#define	label_format                  	(cur_term->strs[273])
#define	set_clock                     	(cur_term->strs[274])
#define	display_clock                 	(cur_term->strs[275])
#define	remove_clock                  	(cur_term->strs[276])
#define	create_window                 	(cur_term->strs[277])
#define	goto_window                   	(cur_term->strs[278])
#define	hangup                        	(cur_term->strs[279])
#define	dial_phone                    	(cur_term->strs[280])
#define	quick_dial                    	(cur_term->strs[281])
#define	tone                          	(cur_term->strs[282])
#define	pulse                         	(cur_term->strs[283])
#define	flash_hook                    	(cur_term->strs[284])
#define	fixed_pause                   	(cur_term->strs[285])
#define	wait_tone                     	(cur_term->strs[286])
#define	user0                         	(cur_term->strs[287])
#define	user1                         	(cur_term->strs[288])
#define	user2                         	(cur_term->strs[289])
#define	user3                         	(cur_term->strs[290])
#define	user4                         	(cur_term->strs[291])
#define	user5                         	(cur_term->strs[292])
#define	user6                         	(cur_term->strs[293])
#define	user7                         	(cur_term->strs[294])
#define	user8                         	(cur_term->strs[295])
#define	user9                         	(cur_term->strs[296])
#define	orig_colors                   	(cur_term->strs[297])
#define	orig_pair                     	(cur_term->strs[298])
#define	initialize_color              	(cur_term->strs[299])
#define	initialize_pair               	(cur_term->strs[300])
#define	set_color_pair                	(cur_term->strs[301])
#define	set_foreground                	(cur_term->strs[302])
#define	set_background                	(cur_term->strs[303])
#define	change_char_pitch             	(cur_term->strs[304])
#define	change_line_pitch             	(cur_term->strs[305])
#define	change_res_horz               	(cur_term->strs[306])
#define	change_res_vert               	(cur_term->strs[307])
#define	define_char                   	(cur_term->strs[308])
#define	enter_doublewide_mode         	(cur_term->strs[309])
#define	enter_draft_quality           	(cur_term->strs[310])
#define	enter_italics_mode            	(cur_term->strs[311])
#define	enter_leftward_mode           	(cur_term->strs[312])
#define	enter_micro_mode              	(cur_term->strs[313])
#define	enter_near_letter_quality     	(cur_term->strs[314])
#define	enter_normal_quality          	(cur_term->strs[315])
#define	enter_shadow_mode             	(cur_term->strs[316])
#define	enter_subscript_mode          	(cur_term->strs[317])
#define	enter_superscript_mode        	(cur_term->strs[318])
#define	enter_upward_mode             	(cur_term->strs[319])
#define	exit_doublewide_mode          	(cur_term->strs[320])
#define	exit_italics_mode             	(cur_term->strs[321])
#define	exit_leftward_mode            	(cur_term->strs[322])
#define	exit_micro_mode               	(cur_term->strs[323])
#define	exit_shadow_mode              	(cur_term->strs[324])
#define	exit_subscript_mode           	(cur_term->strs[325])
#define	exit_superscript_mode         	(cur_term->strs[326])
#define	exit_upward_mode              	(cur_term->strs[327])
#define	micro_column_address          	(cur_term->strs[328])
#define	micro_down                    	(cur_term->strs[329])
#define	micro_left                    	(cur_term->strs[330])
#define	micro_right                   	(cur_term->strs[331])
#define	micro_row_address             	(cur_term->strs[332])
#define	micro_up                      	(cur_term->strs[333])
#define	order_of_pins                 	(cur_term->strs[334])
#define	parm_down_micro               	(cur_term->strs[335])
#define	parm_left_micro               	(cur_term->strs[336])
#define	parm_right_micro              	(cur_term->strs[337])
#define	parm_up_micro                 	(cur_term->strs[338])
#define	select_char_set               	(cur_term->strs[339])
#define	set_bottom_margin             	(cur_term->strs[340])
#define	set_bottom_margin_parm        	(cur_term->strs[341])
#define	set_left_margin_parm          	(cur_term->strs[342])
#define	set_right_margin_parm         	(cur_term->strs[343])
#define	set_top_margin                	(cur_term->strs[344])
#define	set_top_margin_parm           	(cur_term->strs[345])
#define	start_bit_image               	(cur_term->strs[346])
#define	start_char_set_def            	(cur_term->strs[347])
#define	stop_bit_image                	(cur_term->strs[348])
#define	stop_char_set_def             	(cur_term->strs[349])
#define	subscript_characters          	(cur_term->strs[350])
#define	superscript_characters        	(cur_term->strs[351])
#define	these_cause_cr                	(cur_term->strs[352])
#define	zero_motion                   	(cur_term->strs[353])
#define	char_set_names                	(cur_term->strs[354])
#define	key_mouse                     	(cur_term->strs[355])
#define	mouse_info                    	(cur_term->strs[356])
#define	req_mouse_pos                 	(cur_term->strs[357])
#define	get_mouse                     	(cur_term->strs[358])
#define	set_a_foreground              	(cur_term->strs[359])
#define	set_a_background              	(cur_term->strs[360])
#define	pkey_plab                     	(cur_term->strs[361])
#define	device_type                   	(cur_term->strs[362])
#define	code_set_init                 	(cur_term->strs[363])
#define	set0_des_seq                  	(cur_term->strs[364])
#define	set1_des_seq                  	(cur_term->strs[365])
#define	set2_des_seq                  	(cur_term->strs[366])
#define	set3_des_seq                  	(cur_term->strs[367])
#define	set_lr_margin                 	(cur_term->strs[368])
#define	set_tb_margin                 	(cur_term->strs[369])
#define	bit_image_repeat              	(cur_term->strs[370])
#define	bit_image_newline             	(cur_term->strs[371])
#define	bit_image_carriage_return     	(cur_term->strs[372])
#define	color_names                   	(cur_term->strs[373])
#define	define_bit_image_region       	(cur_term->strs[374])
#define	end_bit_image_region          	(cur_term->strs[375])
#define	set_color_band                	(cur_term->strs[376])
#define	set_page_length               	(cur_term->strs[377])
#define	display_pc_char               	(cur_term->strs[378])
#define	enter_pc_charset_mode         	(cur_term->strs[379])
#define	exit_pc_charset_mode          	(cur_term->strs[380])
#define	enter_scancode_mode           	(cur_term->strs[381])
#define	exit_scancode_mode            	(cur_term->strs[382])
#define	pc_term_options               	(cur_term->strs[383])
#define	scancode_escape               	(cur_term->strs[384])
#define	alt_scancode_esc              	(cur_term->strs[385])
#define	enter_horizontal_hl_mode      	(cur_term->strs[386])
#define	enter_left_hl_mode            	(cur_term->strs[387])
#define	enter_low_hl_mode             	(cur_term->strs[388])
#define	enter_right_hl_mode           	(cur_term->strs[389])
#define	enter_top_hl_mode             	(cur_term->strs[390])
#define	enter_vertical_hl_mode        	(cur_term->strs[391])
#define	backspaces_with_bs            	(cur_term->bools[37])
#define	crt_no_scrolling              	(cur_term->bools[38])
#define	no_correctly_working_cr       	(cur_term->bools[39])
#define	carriage_return_delay         	(cur_term->nums[33])
#define	magic_cookie_glitch_ul        	(cur_term->nums[34])
#define	new_line_delay                	(cur_term->nums[35])
#define	backspace_if_not_bs           	(cur_term->strs[392])
#define	linefeed_if_not_lf            	(cur_term->strs[393])
#define	termcap_init2                 	(cur_term->strs[394])
#define	termcap_reset                 	(cur_term->strs[395])
#define	gnu_has_meta_key              	(cur_term->bools[40])
#define	has_hardware_tabs             	(cur_term->bools[41])
#define	linefeed_is_newline           	(cur_term->bools[42])
#define	return_does_clr_eol           	(cur_term->bools[43])
#define	backspace_delay               	(cur_term->nums[36])
#define	horizontal_tab_delay          	(cur_term->nums[37])
#define	number_of_function_keys       	(cur_term->nums[38])
#define	other_non_function_keys       	(cur_term->nums[39])
#define	arrow_key_map                 	(cur_term->strs[396])
#define	acs_btee                      	(cur_term->strs[397])
#define	acs_hline                     	(cur_term->strs[398])
#define	acs_llcorner                  	(cur_term->strs[399])
#define	acs_lrcorner                  	(cur_term->strs[400])
#define	acs_ltee                      	(cur_term->strs[401])
#define	acs_plus                      	(cur_term->strs[402])
#define	acs_rtee                      	(cur_term->strs[403])
#define	acs_ttee                      	(cur_term->strs[404])
#define	acs_ulcorner                  	(cur_term->strs[405])
#define	acs_urcorner                  	(cur_term->strs[406])
#define	acs_vline                     	(cur_term->strs[407])
#define	memory_lock                   	(cur_term->strs[408])
#define	memory_unlock                 	(cur_term->strs[409])

#define	_tBoolCnt	44
#define	_tNumCnt	40
#define	_tStrCnt	410

/*	$OpenBSD: term.h.tail,v 1.1.1.1 1996/05/31 05:40:02 tholo Exp $	*/

/*
 * Copyright (c) 1996 SigmaSoft, Th. Lockert <tholo@sigmasoft.com>
 * All rights reserved.
 */

typedef struct _terminal {
    int			 fd;
    speed_t		 baudrate;
    struct termios	 pmode;
    struct termios	 smode;
    char		*name;
    char		 bools[_tBoolCnt];
    short		 nums[_tNumCnt];
    char		*strs[_tStrCnt];
} TERMINAL;

#define Filedes fd
#define Ottyb smode
#define Nttyb pmode
#define TTY struct termios

#ifndef _CHTYPE_T_
#define	_CHTYPE_T_	unsigned long
typedef _CHTYPE_T_	chtype;
#endif

#undef fixterm
#undef putp
#undef resetterm
#undef setterm
#undef vidattr

__BEGIN_DECLS
extern const char * const boolnames[];
extern const char * const boolcodes[];
extern const char * const boolfnames[];
extern const char * const numnames[];
extern const char * const numcodes[];
extern const char * const numfnames[];
extern const char * const strnames[];
extern const char * const strcodes[];
extern const char * const strfnames[];

extern int	 LINES;
extern int	 COLS;
extern int	 TABSIZE;
extern TERMINAL	*cur_term;
extern char	 ttytype[];

int	 def_prog_mode __P((void));
int	 def_shell_mode __P((void));
int	 del_curterm __P((TERMINAL *));
int	 mvcur __P((int, int, int, int));
int	 putp __P((const char *));
int	 reset_prog_mode __P((void));
int	 reset_shell_mode __P((void));
int	 restartterm __P((const char *, int, int *));
int	 setupterm __P((const char *, int, int *));
int	 setterm __P((const char *));
TERMINAL *set_curterm __P((TERMINAL *));
int	 tigetflag __P((const char *));
int	 tigetnum __P((const char *));
char	*tigetstr __P((const char *));
char	*tparm __P((const char *, ...));
int	 tputs __P((const char *, int, int (*)(int)));
int	 tgetent __P((char *, const char *));
int	 tgetflag __P((const char *));
int	 tgetnum __P((const char *));
char	*tgetstr __P((const char *, char **));
char	*tgoto __P((const char *, int, int));
void	 use_env __P((int));
int	 vidattr __P((chtype));
int	 vidputs __P((chtype, int (*)(int)));

int	 _ti_outc __P((int));
__END_DECLS

#define fixterm()	reset_prog_mode()
#define putp(s)		tputs(s, 1, _ti_outc)
#define resetterm()	reset_shell_mode()
#define setterm(term)	setupterm(term, 1, (int *)0)
#define	vidattr(s)	vidputs(s, _ti_outc)

#ifndef OK
#define	OK	(0)
#endif /* OK */

#ifndef ERR
#define	ERR	(-1)
#endif /* ERR */

#ifndef TRUE
#define	TRUE	(1)
#endif

#ifndef FALSE
#define FALSE	(0)
#endif

#ifndef A_ATTRIBUTES
#define A_ATTRIBUTES	0xffffff00
#define A_NORMAL	0x00000000
#define A_STANDOUT	0x00010000
#define A_UNDERLINE	0x00020000
#define A_REVERSE	0x00040000
#define A_BLINK		0x00080000
#define A_DIM		0x00100000
#define A_BOLD		0x00200000
#define A_ALTCHARSET	0x00400000
#define A_INVIS		0x00800000
#define A_PROTECT	0x01000000
#define A_HORIZONTAL	0x02000000
#define A_LEFT		0x04000000
#define A_LOW		0x08000000
#define A_RIGHT		0x10000000
#define A_TOP		0x20000000
#define A_VERTICAL	0x40000000
#define A_CHARTEXT	0x000000ff
#define A_COLOR		0x0000ff00
#endif

#endif /* _TERM_H_ */
