sub BSD {199306;}
sub BSD4_3 {1;}
sub BSD4_4 {1;}
sub OpenBSD {199610;}
sub OpenBSD2_0 {1;}
if (!defined &NULL) {
    eval 'sub NULL {0;}';
}
if (!defined &_LOCORE) {
    require 'sys/types.ph';
}
require 'sys/syslimits.ph';
sub MAXCOMLEN {16;}
sub MAXINTERP {64;}
sub MAXLOGNAME {12;}
sub MAXUPRC { &CHILD_MAX;}
sub NCARGS { &ARG_MAX;}
sub NGROUPS { &NGROUPS_MAX;}
sub NOFILE { &OPEN_MAX;}
sub NOGROUP {65535;}
sub MAXHOSTNAMELEN {256;}
if (defined &_KERNEL) {
    require 'sys/cdefs.ph';
    require 'sys/errno.ph';
    require 'sys/time.ph';
    require 'sys/resource.ph';
    require 'sys/ucred.ph';
    require 'sys/uio.ph';
}
require 'sys/signal.ph';
require 'machine/param.ph';
require 'machine/limits.ph';
sub PSWP {0;}
sub PVM {4;}
sub PINOD {8;}
sub PRIBIO {16;}
sub PVFS {20;}
sub PZERO {22;}
sub PSOCK {24;}
sub PWAIT {32;}
sub PLOCK {36;}
sub PPAUSE {40;}
sub PUSER {50;}
sub MAXPRI {127;}
sub PRIMASK {0x0ff;}
sub PCATCH {0x100;}
sub NZERO {0;}
sub NBPW {$sizeof{'int'};}
sub CMASK {022;}
sub NODEV {( &dev_t)(-1);}
sub CLBYTES {( &CLSIZE* &NBPG);}
sub CLOFSET {( &CLSIZE* &NBPG-1);}
sub claligned {
    local($x) = @_;
    eval "(((($x))& &CLOFSET)==0)";
}
sub CLOFF { &CLOFSET;}
sub CLSHIFT {( &PGSHIFT+ &CLSIZELOG2);}
if ((defined(&CLSIZE) ? &CLSIZE : 0)==1) {
    eval 'sub clbase {
        local($i) = @_;
        eval "($i)";
    }';
    eval 'sub clrnd {
        local($i) = @_;
        eval "($i)";
    }';
}
else {
    eval 'sub clbase {
        local($i) = @_;
        eval "(($i) &~ ( &CLSIZE-1))";
    }';
    eval 'sub clrnd {
        local($i) = @_;
        eval "((($i) + ( &CLSIZE-1)) &~ ( &CLSIZE-1))";
    }';
}
sub CBLOCK {64;}
sub CBQSIZE {( &CBLOCK/ &NBBY);}
sub CBSIZE {( &CBLOCK - $sizeof{'struct cblock' *} -  &CBQSIZE);}
sub CROUND {( &CBLOCK - 1);}
if (defined( &__i386__)) {
    eval 'sub MAXBSIZE {16384;}';
}
else {
    eval 'sub MAXBSIZE { &MAXPHYS;}';
}
sub MAXFRAG {8;}
sub MAXPATHLEN { &PATH_MAX;}
sub MAXSYMLINKS {32;}
sub setbit {
    local($a,$i) = @_;
    eval "(($a)[($i)/ &NBBY] |= 1<<(($i)% &NBBY))";
}
sub clrbit {
    local($a,$i) = @_;
    eval "(($a)[($i)/ &NBBY] &= ~(1<<(($i)% &NBBY)))";
}
sub isset {
    local($a,$i) = @_;
    eval "(($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY)))";
}
sub isclr {
    local($a,$i) = @_;
    eval "((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))) == 0)";
}
if (!defined &howmany) {
    eval 'sub howmany {
        local($x, $y) = @_;
        eval "((($x)+(($y)-1))/($y))";
    }';
}
sub roundup {
    local($x, $y) = @_;
    eval "(((($x)+(($y)-1))/($y))*($y))";
}
sub powerof2 {
    local($x) = @_;
    eval "(((($x)-1)&($x))==0)";
}
if (!defined &_KERNEL) {
    eval 'sub MIN {
        local($a,$b) = @_;
        eval "((($a)<($b))?($a):($b))";
    }';
    eval 'sub MAX {
        local($a,$b) = @_;
        eval "((($a)>($b))?($a):($b))";
    }';
}
sub MINBUCKET {4;}
sub MAXALLOCSAVE {(2 *  &CLBYTES);}
sub FSHIFT {11;}
sub FSCALE {(1<< &FSHIFT);}
sub RFNAMEG {(1<<0);}
sub RFENVG {(1<<1);}
sub RFFDG {(1<<2);}
sub RFNOTEG {(1<<3);}
sub RFPROC {(1<<4);}
sub RFMEM {(1<<5);}
sub RFNOWAIT {(1<<6);}
sub RFCNAMEG {(1<<10);}
sub RFCENVG {(1<<11);}
sub RFCFDG {(1<<12);}
1;
