# (c) Copyright 2010. CodeWeavers, Inc.

import optparse
import sys

class Parser(optparse.OptionParser):

    def __init__(self, *args, **kwargs):
        if 'epilog' in kwargs and not hasattr(self, 'format_epilog'):
            if kwargs.get('description', ''):
                kwargs['description'] += " " + kwargs['epilog']
            else:
                kwargs['description'] = kwargs['epilog']
            del kwargs['epilog']
        optparse.OptionParser.__init__(self, *args, **kwargs)

    def error(self, msg):
        prog = self.get_prog_name()
        sys.stderr.write("%s:error: %s\n" % (prog, msg))
        self.exit(2, "%s:error: try '%s --help' for more information\n" % (prog, prog))
