/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.SocketDescriptor;
import com.tigervnc.network.SocketException;
import com.tigervnc.network.SocketListener;
import com.tigervnc.network.TcpSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TcpListener
extends SocketListener {
    public static boolean socketsInitialised = false;
    private boolean closeFd;
    private ServerSocketChannel channel;
    private Selector selector;

    public TcpListener(String string, int n, boolean bl, SocketDescriptor socketDescriptor, boolean bl2) throws Exception {
        this.closeFd = bl2;
        if (socketDescriptor != null) {
            this.fd = socketDescriptor;
            return;
        }
        TcpSocket.initSockets();
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new Exception("unable to create listening socket: " + iOException.toString());
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = bl ? InetAddress.getByName(null) : (string != null ? InetAddress.getByName(string) : InetAddress.getByName("0.0.0.0"));
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception(unknownHostException.getMessage());
        }
        try {
            this.channel.socket().bind(new InetSocketAddress(inetAddress, n));
        }
        catch (IOException iOException) {
            throw new Exception("unable to bind listening socket: " + iOException.toString());
        }
        try {
            this.selector = Selector.open();
            this.channel.register(this.selector, 16);
        }
        catch (IOException iOException) {
            throw new Exception("unable to set socket to listening mode: " + iOException.toString());
        }
    }

    public TcpListener(String string, int n) throws Exception {
        this(string, n, false, null, true);
    }

    protected void finalize() throws Exception {
        if (this.closeFd) {
            try {
                ((SocketDescriptor)this.getFd()).close();
            }
            catch (IOException iOException) {
                throw new Exception(iOException.getMessage());
            }
        }
    }

    @Override
    public void shutdown() throws Exception {
        try {
            ((SocketDescriptor)this.getFd()).shutdown();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
    }

    @Override
    public TcpSocket accept() {
        Object object;
        Object object2;
        SocketChannel socketChannel = null;
        try {
            if (this.selector.select(0L) > 0) {
                object2 = this.selector.selectedKeys();
                object = object2.iterator();
                while (object.hasNext()) {
                    SelectionKey selectionKey = object.next();
                    object.remove();
                    if (!selectionKey.isAcceptable()) continue;
                    socketChannel = this.channel.accept();
                    break;
                }
                object2.clear();
                if (socketChannel == null) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            throw new SocketException("unable to accept new connection: " + iOException.toString());
        }
        try {
            socketChannel.socket().setTcpNoDelay(true);
        }
        catch (java.net.SocketException socketException) {
            throw new SocketException(socketException.getMessage());
        }
        object2 = null;
        try {
            object2 = new SocketDescriptor();
        }
        catch (Exception exception) {
            throw new SocketException(exception.getMessage());
        }
        ((SocketDescriptor)object2).setChannel(socketChannel);
        object = new TcpSocket((SocketDescriptor)object2);
        return object;
    }

    public int getMyPort() {
        return ((SocketDescriptor)this.getFd()).socket().getLocalPort();
    }
}

