/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jackson;

import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.io.ContentReference;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.deser.CreatorProperty;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueInstantiator;

public class TokenStreamLocationInstantiator
extends ValueInstantiator.Base {
    public TokenStreamLocationInstantiator() {
        super(TokenStreamLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        JavaType intType = config.constructType(Integer.TYPE);
        JavaType longType = config.constructType(Long.TYPE);
        return new SettableBeanProperty[]{TokenStreamLocationInstantiator.creatorProp("byteOffset", longType, 0, true), TokenStreamLocationInstantiator.creatorProp("charOffset", longType, 1, true), TokenStreamLocationInstantiator.creatorProp("lineNr", intType, 2, true), TokenStreamLocationInstantiator.creatorProp("columnNr", intType, 3, true), TokenStreamLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 4, false)};
    }

    private static CreatorProperty creatorProp(String name, JavaType type, int index, boolean req) {
        return CreatorProperty.construct(PropertyName.construct(name), type, null, null, null, null, index, null, req ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
        ContentReference srcRef = ContentReference.unknown();
        return new TokenStreamLocation(srcRef, TokenStreamLocationInstantiator._long(args[0]), TokenStreamLocationInstantiator._long(args[1]), TokenStreamLocationInstantiator._int(args[2]), TokenStreamLocationInstantiator._int(args[3]));
    }

    private static final long _long(Object o) {
        return o == null ? 0L : ((Number)o).longValue();
    }

    private static final int _int(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }
}

