/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.generator.CoroutineBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.generator.CoroutineBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCoroutine})
public final class CoroutineBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CoroutineBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CoroutineBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PGenerator self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<coroutine object %s at 0x%d>", self.getQualname(), PythonAbstractObject.objectHashCode(self));
        }
    }

    @Slot(value=Slot.SlotKind.am_await, isComplex=true)
    @GenerateNodeFactory
    static abstract class AwaitNode
    extends PythonUnaryBuiltinNode {
        AwaitNode() {
        }

        @Specialization
        static Object await(PGenerator self, @Bind PythonLanguage language) {
            return PFactory.createCoroutineWrapper(language, self);
        }
    }

    @Builtin(name="cr_suspended", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetSuspendedNode
    extends PythonUnaryBuiltinNode {
        GetSuspendedNode() {
        }

        @Specialization
        static boolean suspended(PGenerator self) {
            return self.isStarted() && !self.isRunning() && !self.isFinished();
        }
    }

    @Builtin(name="cr_running", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsRunning
    extends PythonUnaryBuiltinNode {
        @Specialization
        public boolean isRunning(PGenerator self) {
            return self.isRunning();
        }
    }

    @Builtin(name="cr_frame", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetFrame
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getFrame(VirtualFrame frame, PGenerator self, @Cached GeneratorBuiltins.GetFrameNode getFrame) {
            return getFrame.execute(frame, self);
        }
    }

    @Builtin(name="cr_await", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetAwait
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getAwait(PGenerator self) {
            Object yieldFrom = self.getYieldFrom();
            return yieldFrom != null ? yieldFrom : PNone.NONE;
        }
    }

    @Builtin(name="cr_code", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetCode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getCode(PGenerator self, @Bind Node inliningTarget, @Cached InlinedConditionProfile hasCodeProfile) {
            return self.getOrCreateCode(inliningTarget, hasCodeProfile);
        }
    }
}

