/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.ANextAwaitableBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.asyncio.ANextAwaitableBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNode;
import com.oracle.graal.python.builtins.objects.asyncio.PANextAwaitable;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAnextAwaitable})
public class ANextAwaitableBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ANextAwaitableBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ANextAwaitableBuiltinsFactory.getFactories();
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        static Object doClose(VirtualFrame frame, PANextAwaitable self, @Bind Node inliningTarget, @Cached ProxyNode proxyNode) {
            return proxyNode.execute(frame, inliningTarget, self, BuiltinNames.T_CLOSE);
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ThrowNode
    extends PythonUnaryBuiltinNode {
        ThrowNode() {
        }

        @Specialization
        static Object doThrow(VirtualFrame frame, PANextAwaitable self, @Bind Node inliningTarget, @Cached ProxyNode proxyNode) {
            return proxyNode.execute(frame, inliningTarget, self, BuiltinNames.T_THROW);
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SendNode
    extends PythonUnaryBuiltinNode {
        SendNode() {
        }

        @Specialization
        static Object doSend(VirtualFrame frame, PANextAwaitable self, @Bind Node inliningTarget, @Cached ProxyNode proxyNode) {
            return proxyNode.execute(frame, inliningTarget, self, BuiltinNames.T_SEND);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        IterNextNode() {
        }

        @Specialization
        static Object next(VirtualFrame frame, PANextAwaitable self, @Bind Node inliningTarget, @Cached GetIterNode getIterNode, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIternext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached PRaiseNode raiseNode) {
            Object awaitable = getIterNode.execute(frame, inliningTarget, self);
            TpSlots slots = getSlots.execute(inliningTarget, awaitable);
            try {
                return callIternext.execute(frame, inliningTarget, slots.tp_iternext(), awaitable);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopAsyncIteration, stopIterationProfile);
                throw raiseNode.raiseStopAsyncIteration(inliningTarget, self.getDefaultValue());
            }
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.tp_iter, isComplex=true), @Slot(value=Slot.SlotKind.am_aiter, isComplex=true)})
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(PANextAwaitable self) {
            return self;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ProxyNode
    extends Node {
        ProxyNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, PANextAwaitable var3, TruffleString var4);

        @Specialization
        static Object getIter(VirtualFrame frame, Node inliningTarget, PANextAwaitable self, TruffleString method, @Cached GetIterNode getIterNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached PRaiseNode raiseNode) {
            Object awaitable = getIterNode.execute(frame, inliningTarget, self);
            try {
                return callMethod.execute((Frame)frame, inliningTarget, awaitable, method, new Object[0]);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopAsyncIteration, stopIterationProfile);
                throw raiseNode.raiseStopAsyncIteration(inliningTarget, self.getDefaultValue());
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetIterNode
    extends Node {
        GetIterNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, PANextAwaitable var3);

        @Specialization
        static Object getIter(VirtualFrame frame, Node inliningTarget, PANextAwaitable self, @Cached GetAwaitableNode getAwaitableNode) {
            PGenerator coroutine;
            Object awaitable = getAwaitableNode.execute(frame, self.getWrapped());
            if (awaitable instanceof PGenerator && (coroutine = (PGenerator)awaitable).getInitialPythonClass() == PythonBuiltinClassType.PCoroutine) {
                return PFactory.createCoroutineWrapper(PythonLanguage.get(inliningTarget), coroutine);
            }
            return awaitable;
        }
    }
}

