/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.panama.AbstractPanamaNFIContext;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import java.lang.foreign.Arena;

final class PanamaNFIContext
extends AbstractPanamaNFIContext {
    final PanamaNFILanguage language;
    Arena arena;
    @CompilerDirectives.CompilationFinal
    TruffleLanguage.Env env;
    private static final TruffleLanguage.ContextReference<AbstractPanamaNFIContext> REFERENCE = TruffleLanguage.ContextReference.create(PanamaNFILanguage.class);

    PanamaNFIContext(PanamaNFILanguage language, TruffleLanguage.Env env) {
        this.language = language;
        this.env = env;
    }

    @Override
    void initialize() {
        this.arena = Arena.ofShared();
    }

    @Override
    void patchEnv(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
    }

    @Override
    void dispose() {
        if (this.arena != null) {
            this.arena.close();
        }
    }

    Arena getContextArena() {
        return this.arena;
    }

    @CompilerDirectives.TruffleBoundary
    PanamaType lookupEnvType() {
        return null;
    }

    static PanamaNFIContext get(Node node) {
        return (PanamaNFIContext)CompilerDirectives.castExact((Object)REFERENCE.get(node), PanamaNFIContext.class);
    }
}

