/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import com.google.common.base.Charsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.agreement.CloneableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.XMLExpressableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.MACAlgorithm;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.KeyDerivationSupport;
import org.opensaml.xmlsec.encryption.IterationCount;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.KeyLength;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Salt;
import org.opensaml.xmlsec.encryption.Specified;

public class PBKDF2
extends AbstractInitializableComponent
implements KeyDerivation,
XMLExpressableKeyAgreementParameter,
CloneableKeyAgreementParameter {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_PRF = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    @Nonnull
    public static final Integer DEFAULT_ITERATION_COUNT = 2000;
    @Nonnull
    public static final Integer DEFAULT_GENERATED_SALT_LENGTH = 8;
    @Nonnull
    private static final String PBKDF2_JCA_ALGORITHM_BASE = "PBKDF2With";
    @Nullable
    private String salt;
    @NonnullAfterInit
    private Integer generatedSaltLength;
    @NonnullAfterInit
    private SecureRandom secureRandom;
    @NonnullAfterInit
    private Integer iterationCount;
    @Nullable
    private Integer keyLength;
    @NonnullAfterInit
    private String prf;

    @Override
    @Nonnull
    public String getAlgorithm() {
        return "http://www.w3.org/2009/xmlenc11#pbkdf2";
    }

    @Nullable
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(@Nullable String value) {
        this.checkSetterPreconditions();
        this.salt = StringSupport.trimOrNull(value);
    }

    @NonnullAfterInit
    public Integer getGeneratedSaltLength() {
        return this.generatedSaltLength;
    }

    public void setGeneratedSaltLength(@Nullable Integer length) {
        this.checkSetterPreconditions();
        this.generatedSaltLength = length;
    }

    @NonnullAfterInit
    public SecureRandom getRandom() {
        return this.secureRandom;
    }

    public void setRandom(@Nullable SecureRandom sr) {
        this.checkSetterPreconditions();
        this.secureRandom = sr;
    }

    @NonnullAfterInit
    public Integer getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(@Nullable Integer count) {
        this.checkSetterPreconditions();
        this.iterationCount = count;
    }

    @Nullable
    public Integer getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(@Nullable Integer length) {
        this.checkSetterPreconditions();
        this.keyLength = length;
    }

    @NonnullAfterInit
    public String getPRF() {
        return this.prf;
    }

    public void setPRF(@Nullable String uri) {
        this.checkSetterPreconditions();
        this.prf = StringSupport.trimOrNull(uri);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.salt != null) {
            try {
                Base64Support.decode(this.salt);
            }
            catch (DecodingException e) {
                throw new ComponentInitializationException("Salt value was not valid Base64", e);
            }
        }
        if (this.generatedSaltLength == null) {
            this.generatedSaltLength = DEFAULT_GENERATED_SALT_LENGTH;
        }
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        if (this.iterationCount == null) {
            this.iterationCount = DEFAULT_ITERATION_COUNT;
        }
        if (this.keyLength != null && this.keyLength % 8 != 0) {
            throw new ComponentInitializationException("Specified key length in bits is not a multiple of 8");
        }
        if (this.prf == null) {
            this.prf = DEFAULT_PRF;
        } else {
            AlgorithmDescriptor descriptor = AlgorithmSupport.ensureGlobalAlgorithmRegistry().get(this.prf);
            if (descriptor == null) {
                throw new ComponentInitializationException("Specified PRF algorithm is unknown: " + this.prf);
            }
            if (!MACAlgorithm.class.isInstance(descriptor)) {
                throw new ComponentInitializationException("Specified PRF algorithm is not a MAC algorithm: " + this.prf);
            }
        }
    }

    @Override
    @Nonnull
    public SecretKey derive(@Nonnull byte[] secret, @Nonnull String keyAlgorithm, @Nullable Integer specifiedKeyLength) throws KeyDerivationException {
        Constraint.isNotNull(secret, "Secret byte[] was null");
        Constraint.isNotNull(keyAlgorithm, "Key algorithm was null");
        this.checkComponentActive();
        String jcaKeyAlgorithm = KeyDerivationSupport.getJCAKeyAlgorithm(keyAlgorithm);
        byte[] saltBytes = this.getEffectiveSalt();
        Integer length = this.getEffectiveKeyLength(keyAlgorithm, specifiedKeyLength);
        String jcaPRF = AlgorithmSupport.getAlgorithmID(this.prf);
        char[] secretChars = new String(secret, Charsets.UTF_8).toCharArray();
        try {
            PBEKeySpec spec = new PBEKeySpec(secretChars, saltBytes, this.iterationCount, length);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_JCA_ALGORITHM_BASE + jcaPRF);
            return new SecretKeySpec(skf.generateSecret(spec).getEncoded(), jcaKeyAlgorithm);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new KeyDerivationException("Error generating SecretKey via PBKDF2", e);
        }
    }

    protected byte[] getEffectiveSalt() throws KeyDerivationException {
        byte[] saltBytes = null;
        if (this.salt == null) {
            saltBytes = new byte[this.generatedSaltLength.intValue()];
            this.secureRandom.nextBytes(saltBytes);
            try {
                this.salt = Base64Support.encode(saltBytes, false);
            }
            catch (EncodingException e) {
                throw new KeyDerivationException("Error Base64-encoding generated salt", e);
            }
        }
        try {
            assert (this.salt != null);
            saltBytes = Base64Support.decode(this.salt);
        }
        catch (DecodingException e) {
            throw new KeyDerivationException("Error Base64-decoding supplied salt", e);
        }
        return saltBytes;
    }

    protected Integer getEffectiveKeyLength(@Nonnull String keyAlgorithm, @Nullable Integer specifiedKeyLength) throws KeyDerivationException {
        Integer jcaKeyLength = KeyDerivationSupport.getEffectiveKeyLength(keyAlgorithm, specifiedKeyLength);
        if (this.keyLength == null) {
            this.keyLength = jcaKeyLength;
        } else {
            assert (this.keyLength != null);
            if (!this.keyLength.equals(jcaKeyLength)) {
                throw new KeyDerivationException(String.format("Specified key length '%d' does not match URI: %s", this.keyLength, keyAlgorithm));
            }
        }
        return this.keyLength;
    }

    @Override
    public PBKDF2 clone() {
        try {
            return (PBKDF2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    public XMLObject buildXMLObject() {
        this.checkComponentActive();
        if (this.keyLength == null) {
            throw new IllegalStateException("PBKDF2 is missing KeyLength element data");
        }
        if (this.salt == null) {
            throw new IllegalStateException("PBKDF2 is missing Salt element data");
        }
        KeyDerivationMethod method = (KeyDerivationMethod)XMLObjectSupport.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        method.setAlgorithm(this.getAlgorithm());
        PBKDF2Params params = (PBKDF2Params)XMLObjectSupport.buildXMLObject(PBKDF2Params.DEFAULT_ELEMENT_NAME);
        Salt xmlSalt = (Salt)XMLObjectSupport.buildXMLObject(Salt.DEFAULT_ELEMENT_NAME);
        Specified specified = (Specified)XMLObjectSupport.buildXMLObject(Specified.DEFAULT_ELEMENT_NAME);
        specified.setValue(this.salt);
        xmlSalt.setSpecified(specified);
        params.setSalt(xmlSalt);
        IterationCount xmlIterationcount = (IterationCount)XMLObjectSupport.buildXMLObject(IterationCount.DEFAULT_ELEMENT_NAME);
        xmlIterationcount.setValue(this.iterationCount);
        params.setIterationCount(xmlIterationcount);
        KeyLength xmlKeyLength = (KeyLength)XMLObjectSupport.buildXMLObject(KeyLength.DEFAULT_ELEMENT_NAME);
        assert (this.keyLength != null);
        xmlKeyLength.setValue(this.keyLength / 8);
        params.setKeyLength(xmlKeyLength);
        PRF xmlPRF = (PRF)XMLObjectSupport.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME);
        xmlPRF.setAlgorithm(this.prf);
        params.setPRF(xmlPRF);
        method.getUnknownXMLObjects().add(params);
        return method;
    }

    @Nonnull
    public static PBKDF2 fromXMLObject(@Nonnull KeyDerivationMethod xmlObject) throws ComponentInitializationException {
        Constraint.isNotNull(xmlObject, "XMLObject was null");
        if (!"http://www.w3.org/2009/xmlenc11#pbkdf2".equals(xmlObject.getAlgorithm())) {
            throw new ComponentInitializationException("KeyDerivationMethod contains unsupported algorithm: " + xmlObject.getAlgorithm());
        }
        if (xmlObject.getUnknownXMLObjects().size() != 1 || xmlObject.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).size() != 1) {
            throw new ComponentInitializationException("KeyDerivationMethod contains unsupported children");
        }
        PBKDF2Params xmlParams = (PBKDF2Params)xmlObject.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        assert (xmlParams != null);
        return PBKDF2.validateAndSetXMLObjectParameters(xmlParams);
    }

    @Nonnull
    private static PBKDF2 validateAndSetXMLObjectParameters(@Nonnull PBKDF2Params xmlParams) throws ComponentInitializationException {
        Specified specified;
        Integer keyLength;
        IterationCount iterCount = xmlParams.getIterationCount();
        if (iterCount == null || iterCount.getValue() == null) {
            throw new ComponentInitializationException("PBKDF2-params did not contain IterationCount value");
        }
        KeyLength keyLengthObject = xmlParams.getKeyLength();
        Integer n = keyLength = keyLengthObject != null ? keyLengthObject.getValue() : null;
        if (keyLength == null) {
            throw new ComponentInitializationException("PBKDF2-params did not contain KeyLength value");
        }
        PRF prf = xmlParams.getPRF();
        if (prf == null || prf.getAlgorithm() == null) {
            throw new ComponentInitializationException("PBKDF2-params did not contain PRF value");
        }
        if (prf.getParameters() != null) {
            throw new ComponentInitializationException("PBKDF2-params contained unsupported PRF parameters");
        }
        Salt salt = xmlParams.getSalt();
        Specified specified2 = specified = salt != null ? salt.getSpecified() : null;
        if (specified == null || specified.getValue() == null) {
            throw new ComponentInitializationException("PBKDF2-params did not contain Salt Specified value");
        }
        PBKDF2 param = new PBKDF2();
        param.setIterationCount(iterCount.getValue());
        param.setKeyLength(keyLength * 8);
        param.setPRF(prf.getAlgorithm());
        param.setSalt(specified.getValue());
        param.initialize();
        return param;
    }

    public static class Parser
    implements KeyAgreementParameterParser {
        @Override
        public boolean handles(@Nonnull XMLObject xmlObject) {
            return KeyDerivationMethod.class.isInstance(xmlObject) && "http://www.w3.org/2009/xmlenc11#pbkdf2".equals(((KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject)).getAlgorithm());
        }

        @Override
        @Nonnull
        public KeyAgreementParameter parse(@Nonnull XMLObject xmlObject) throws KeyAgreementException {
            if (!this.handles(xmlObject)) {
                throw new KeyAgreementException("This implementation does not handle: " + xmlObject.getClass().getName());
            }
            try {
                return PBKDF2.fromXMLObject((KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject));
            }
            catch (ComponentInitializationException e) {
                throw new KeyAgreementException(e);
            }
        }
    }
}

