/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.lucene;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.AbstractKNNMethod;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.lucene.LuceneHNSWSearchContext;
import org.opensearch.knn.index.engine.lucene.LuceneSQEncoder;

public class LuceneHNSWMethod
extends AbstractKNNMethod {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT), (Object)((Object)VectorDataType.BYTE), (Object)((Object)VectorDataType.BINARY));
    public static final List<SpaceType> SUPPORTED_SPACES = Arrays.asList(SpaceType.UNDEFINED, SpaceType.L2, SpaceType.COSINESIMIL, SpaceType.INNER_PRODUCT, SpaceType.HAMMING);
    static final Encoder SQ_ENCODER = new LuceneSQEncoder();
    static final Map<String, Encoder> SUPPORTED_ENCODERS = Map.of(SQ_ENCODER.getName(), SQ_ENCODER);
    static final MethodComponent HNSW_METHOD_COMPONENT = LuceneHNSWMethod.initMethodComponent();

    public LuceneHNSWMethod() {
        super(HNSW_METHOD_COMPONENT, Set.copyOf(SUPPORTED_SPACES), new LuceneHNSWSearchContext());
    }

    private static MethodComponent initMethodComponent() {
        return MethodComponent.Builder.builder("hnsw").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("m", new Parameter.IntegerParameter("m", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M, (v, context) -> v > 0)).addParameter("ef_construction", new Parameter.IntegerParameter("ef_construction", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, (v, context) -> v > 0)).addParameter("encoder", LuceneHNSWMethod.initEncoderParameter()).build();
    }

    private static Parameter.MethodComponentContextParameter initEncoderParameter() {
        return new Parameter.MethodComponentContextParameter("encoder", null, SUPPORTED_ENCODERS.values().stream().collect(Collectors.toMap(Encoder::getName, Encoder::getMethodComponent)));
    }
}

