/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.protocol;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.ArrayList;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.keycloak.jgroups.header.TracerHeader;

@MBean(description="Records OpenTelemetry traces of sent and received messages")
public class OPEN_TELEMETRY
extends Protocol {
    public static final short OPEN_TELEMETRY_ID = 1026;
    protected OpenTelemetry otel;
    protected Tracer tracer;
    @Property(description="When active, traces are recorded, otherwise not")
    protected boolean active = true;
    protected static final TextMapGetter<TracerHeader> TEXT_MAP_GETTER = new TextMapGetter<TracerHeader>(){

        public String get(TracerHeader carrier, String key) {
            return carrier.get(key);
        }

        public Iterable<String> keys(TracerHeader carrier) {
            return carrier.keys();
        }
    };

    public boolean active() {
        return this.active;
    }

    public OPEN_TELEMETRY active(boolean f) {
        this.active = this.activate(f);
        return this;
    }

    public void start() throws Exception {
        super.start();
        this.activate(this.active);
    }

    public Object down(Message msg) {
        if (!this.active || !Span.current().getSpanContext().isValid()) {
            return this.down_prot.down(msg);
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder("JGroups.sendSingleMessage");
        if (Span.current().isRecording()) {
            if (msg.getDest() != null) {
                spanBuilder.setAttribute("kc.jgroups.dest", msg.getDest().toString());
            }
            if (msg.getSrc() != null) {
                spanBuilder.setAttribute("kc.jgroups.src", msg.getSrc().toString());
            }
        }
        Span span = spanBuilder.startSpan();
        try {
            Object object;
            block15: {
                Scope ignored = span.makeCurrent();
                try {
                    TracerHeader hdr = new TracerHeader();
                    OPEN_TELEMETRY.populateHeader(hdr);
                    msg.putHeader((short)1026, (Header)hdr);
                    object = this.down_prot.down(msg);
                    if (ignored == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.setStatus(StatusCode.ERROR, String.format("failed delivering single message to %s", msg.dest()));
                        span.recordException(t);
                        throw t;
                    }
                }
                ignored.close();
            }
            return object;
        }
        finally {
            span.end();
        }
    }

    public Object up(Message msg) {
        if (!this.active) {
            return this.up_prot.up(msg);
        }
        TracerHeader hdr = (TracerHeader)msg.getHeader((short)1026);
        if (hdr != null) {
            Context extractedContext = this.otel.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)hdr, TEXT_MAP_GETTER);
            Span span = this.tracer.spanBuilder("JGroups.deliverSingleMessage").setSpanKind(SpanKind.SERVER).setParent(extractedContext).startSpan();
            try {
                Object object;
                block13: {
                    Scope ignored = span.makeCurrent();
                    try {
                        span.setAttribute("from", msg.src().toString());
                        object = this.up_prot.up(msg);
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            span.setStatus(StatusCode.ERROR, String.format("failed delivering single message from %s", msg.src()));
                            span.recordException(t);
                            throw t;
                        }
                    }
                    ignored.close();
                }
                return object;
            }
            finally {
                span.end();
            }
        }
        return this.up_prot.up(msg);
    }

    public void up(MessageBatch batch) {
        if (!this.active) {
            if (!batch.isEmpty()) {
                this.up_prot.up(batch);
            }
            return;
        }
        ArrayList<Span> spans = new ArrayList<Span>(batch.size());
        int index = 0;
        int batch_size = batch.size();
        for (Message msg : batch) {
            ++index;
            TracerHeader hdr = (TracerHeader)msg.getHeader((short)1026);
            if (hdr == null) continue;
            Context extractedContext = this.otel.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)hdr, TEXT_MAP_GETTER);
            Span span = this.tracer.spanBuilder("deliver-batched-msg").setSpanKind(SpanKind.SERVER).setParent(extractedContext).startSpan();
            span.setAttribute("batch-msg", String.format("%d/%d", index, batch_size));
            spans.add(span);
        }
        try {
            if (!batch.isEmpty()) {
                this.up_prot.up(batch);
            }
        }
        catch (Throwable t) {
            spans.forEach(s -> s.setStatus(StatusCode.ERROR, String.format("failed delivering batched message from %s", batch.sender())).recordException(t));
            throw t;
        }
        finally {
            spans.forEach(Span::end);
        }
    }

    protected static void populateHeader(TracerHeader hdr) {
        W3CTraceContextPropagator.getInstance().inject(Context.current(), (Object)hdr, (carrier, key, val) -> hdr.put(key, val));
    }

    protected boolean activate(boolean flag) {
        if (flag && this.otel == null) {
            this.otel = GlobalOpenTelemetry.get();
        }
        if (flag && this.tracer == null) {
            this.tracer = this.otel.getTracer("org.jgroups.trace", Version.printVersion());
        }
        return flag;
    }
}

