/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javajs.api.GenericColor;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javax.imageio.ImageIO;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPdfWriter;
import jspecview.common.ColorParameters;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.GenericMouseInterface;
import org.jmol.api.GenericPlatform;
import org.jmol.util.Font;
import org.jmol.util.Logger;

public class AwtPanel
extends JPanel
implements JSVPanel,
Printable {
    private static final long serialVersionUID = 1L;
    private GenericPlatform apiPlatform;
    private PanelData pd;
    private JSViewer vwr;
    private GenericMouseInterface mouse;
    private GenericColor bgcolor;

    @Override
    public GenericPlatform getApiPlatform() {
        return this.apiPlatform;
    }

    @Override
    public PanelData getPanelData() {
        return this.pd;
    }

    public static AwtPanel getEmptyPanel(JSViewer viewer) {
        return new AwtPanel(viewer, false);
    }

    public static AwtPanel getPanelOne(JSViewer viewer, Spectrum spectrum) {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        AwtPanel p = new AwtPanel(viewer, true);
        p.pd.initOne(spectrum);
        return p;
    }

    public static AwtPanel getPanelMany(JSViewer viewer, Lst<Spectrum> spectra) {
        AwtPanel p = new AwtPanel(viewer, true);
        p.pd.initMany(spectra, viewer.initialStartIndex, viewer.initialEndIndex);
        return p;
    }

    private AwtPanel(JSViewer viewer, boolean withPD) {
        this.vwr = viewer;
        this.pd = withPD ? new PanelData(this, viewer) : null;
        this.apiPlatform = viewer.apiPlatform;
        this.mouse = this.apiPlatform.getMouseManager(0.0, this);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public String getTitle() {
        return this.pd.getTitle();
    }

    @Override
    public void dispose() {
        if (this.pd != null) {
            this.pd.dispose();
        }
        this.pd = null;
        this.mouse.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.pd.setTitle(title);
        this.setName(title);
    }

    public void setColorOrFont(ColorParameters ds, ScriptToken st) {
        this.pd.setColorOrFont(ds, st);
    }

    @Override
    public void setBackgroundColor(GenericColor color) {
        this.bgcolor = color;
        this.setBackground((Color)((Object)this.bgcolor));
    }

    public GenericColor getBackgroundColor() {
        return this.bgcolor;
    }

    @Override
    public void doRepaint(boolean andTaintAll) {
        if (andTaintAll) {
            this.pd.setTaintedAll();
        }
        if (!this.pd.isPrinting) {
            this.vwr.requestRepaint();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Object display) {
        super.paintComponent((Graphics)display);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.vwr == null || this.pd == null || this.pd.graphSets == null || this.pd.isPrinting) {
            return;
        }
        super.paintComponent(g);
        try {
            this.pd.g2d = this.pd.g2d0;
            this.paintPanel(g, this.getWidth(), this.getHeight(), false);
        }
        catch (Exception e) {
            System.out.println("Exception while painting " + e);
            e.printStackTrace();
        }
        this.vwr.repaintDone();
    }

    private void paintPanel(Graphics g, int width, int height, boolean isImage) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        this.pd.drawGraph(g, g, g, width, height, false, isImage);
    }

    @Override
    public String getInput(String message, String title, String sval) {
        String ret = (String)JOptionPane.showInputDialog(this, message, title, 3, null, null, sval);
        this.getFocusNow(true);
        return ret;
    }

    @Override
    public void showMessage(String msg, String title) {
        Logger.info(msg);
        if (title != null) {
            JOptionPane.showMessageDialog(this, msg, title, msg.startsWith("<html>") ? 1 : -1);
        }
        this.getFocusNow(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPanel(PrintLayout pl, OutputStream os, String title) {
        block14: {
            pl.title = title;
            pl.date = this.apiPlatform.getDateFormat("8824");
            this.pd.setPrint(pl, os == null ? pl.font : "Helvetica");
            if (pl.paper == null) {
                pl.paper = MediaSizeName.NA_LETTER;
            }
            try {
                PrinterJob pj;
                PrinterJob printerJob = pj = os == null ? PrinterJob.getPrinterJob() : null;
                if (pj != null) {
                    if (title.length() > 30) {
                        title = title.substring(0, 30);
                    }
                    pj.setJobName(title);
                    pj.setPrintable(this);
                }
                if (pj != null && !pj.printDialog()) break block14;
                try {
                    if (pj == null) {
                        Dimension d = this.getDimension((MediaSizeName)pl.paper);
                        pl.paperWidth = d.width;
                        pl.paperHeight = d.height;
                        ((JSVPdfWriter)JSViewer.getInterface("jspecview.common.PDFWriter")).createPdfDocument(this, pl, os);
                    } else {
                        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                        aset.add(pl.layout.equals("landscape") ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
                        aset.add((Attribute)pl.paper);
                        pj.print(aset);
                    }
                }
                catch (PrinterException ex) {
                    String s = ex.getMessage();
                    if (s == null) {
                        this.pd.setPrint(null, null);
                        return;
                    }
                    try {
                        s = PT.rep(s, "not accepting job.", "not accepting jobs.");
                        this.showMessage(s, "Printer Error");
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.pd.setPrint(null, null);
            }
        }
    }

    private Dimension getDimension(MediaSizeName paper) {
        if (paper == MediaSizeName.NA_LETTER) {
            return new Dimension(612, 792);
        }
        if (paper == MediaSizeName.NA_LEGAL) {
            return new Dimension(612, 1008);
        }
        if (paper == MediaSizeName.ISO_A4) {
            return new Dimension(595, 841);
        }
        return new Dimension(708, 1000);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        return this.pd.print(g, pf.getImageableHeight(), pf.getImageableWidth(), pf.getImageableX(), pf.getImageableY(), pf.getPaper().getHeight(), pf.getPaper().getWidth(), pf.getOrientation() == 1, pi);
    }

    @Override
    public int getFontFaceID(String name) {
        return Font.getFontFaceID("SansSerif");
    }

    @Override
    public String saveImage(String type, GenericFileInterface file, OC out, int width, int height) {
        block6: {
            if (width == 0) {
                width = this.getWidth() * 2;
            }
            if (height == 0) {
                height = (int)(2.0 * (double)width / (double)this.getWidth() * (double)this.getHeight());
            }
            String msg = "OK " + width + "x" + height + " ";
            try {
                Image image = this.createImage(width, height);
                this.pd.setTaintedAll();
                Graphics2D g = (Graphics2D)image.getGraphics();
                this.paintPanel(g, width, height, true);
                if (file == null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((Object)image), type, bos);
                    byte[] bytes = bos.toByteArray();
                    out.write(bytes);
                    out.closeChannel();
                    String sf = out.getFileName();
                    if (sf == null || new File(sf).exists()) {
                        return msg + bytes.length + " bytes";
                    }
                    break block6;
                }
                File f = (File)((Object)file);
                ImageIO.write((RenderedImage)((Object)image), type, f);
                return msg + f.length() + " bytes";
            }
            catch (IOException e) {
                msg = e.toString();
                this.showMessage(msg, "Error Saving Image");
            }
        }
        return null;
    }

    @Override
    public void getFocusNow(boolean asThread) {
        if (asThread) {
            SwingUtilities.invokeLater(new RequestThread());
        } else {
            this.requestFocusInWindow();
        }
        if (this.pd != null) {
            this.pd.dialogsToFront(null);
        }
    }

    @Override
    public String toString() {
        return this.pd.getSpectrumAt(0).toString();
    }

    @Override
    public boolean processMouseEvent(int id, int x, int y, int modifiers, long time) {
        return this.mouse.processEvent(id, x, y, modifiers, time);
    }

    @Override
    public void processKeyEvent(Object event) {
        this.mouse.processKeyEvent(event);
    }

    @Override
    public void processTwoPointGesture(float[][][] touches) {
    }

    @Override
    public void showMenu(int x, int y) {
        this.vwr.showMenu(x, y);
    }

    public class RequestThread
    implements Runnable {
        @Override
        public void run() {
            AwtPanel.this.requestFocusInWindow();
        }
    }
}

