---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Foundational agents
---

{{< details >}}

- Tier: Premium, Ultimate
- Add-on: GitLab Duo Core, Pro, or Enterprise
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated
- Status: Beta

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/576618) in GitLab 18.6.

{{< /history >}}

Foundational agents are specialized AI assistants that extend the capabilities of GitLab Duo Chat
with domain-specific expertise and context awareness.

Unlike the general-purpose GitLab Duo agent, foundational agents understand the unique workflows,
frameworks, and best practices of their specialized domains. Each agent combines deep knowledge of
GitLab features with role-specific reasoning to provide targeted help that aligns with how
practitioners actually work.

When you interact with a foundational agent, you're engaging with an AI tool that understands not just
what you're asking, but the broader context of your role and objectives. For example:

- A product planning agent that understands prioritization frameworks and dependency management.
- A security agent that recognizes vulnerability patterns and compliance requirements.

These agents integrate into your existing GitLab workflows through Chat,
and can help provide specialized support without requiring you to leave your current context.

GitLab provides foundational agents for workflows where specialized knowledge significantly improves
outcome quality. Each agent maintains awareness of GitLab-specific implementations, organizational
standards, and industry best practices in its domain. This specialization helps enable more accurate,
actionable, and contextually appropriate responses compared to general-purpose AI help.

## Available foundational agents

The following foundational agents are available:

- [GitLab Planner Agent](planner.md), for product management and
  planning workflows.
- [GitLab Security Analyst Agent](security_analyst_agent.md), for
  security analysis and vulnerability management.

## Turn foundational agents on or off

By default, foundational agents are turned on.
You can turn them on or off for a top-level group (namespace) or for an instance.

If you turn foundational agents off, you can still use the default GitLab Duo agent.

{{< tabs >}}

{{< tab title="For GitLab.com" >}}

Prerequisites:

- You must have the Owner role for the group.

1. On the left sidebar, select **Search or go to** and find your group. If you've [turned on the new navigation](../../../interface_redesign.md#turn-new-navigation-on-or-off), this field is on the top bar.
1. Select **Settings** > **GitLab Duo**.
1. Select **Change configuration**.
1. Under **Foundational agents**, select either:
   - **On by default**
   - **Off by default**
1. Select **Save changes**.

If you turn off foundational agents for a top-level group, users with that group as their default GitLab Duo namespace can't access foundational agents in any namespace.

{{< /tab >}}

{{< tab title="For an instance" >}}

Prerequisites:

- You must be an administrator.

1. On the left sidebar, at the bottom, select **Admin**. If you've [turned on the new navigation](../../../interface_redesign.md#turn-new-navigation-on-or-off), in the upper-right corner, select **Admin**.
1. Select **GitLab Duo**.
1. Select **Change configuration**.
1. Under **Foundational agents**, select either:
   - **On by default**
   - **Off by default**
1. Select **Save changes**.

{{< /tab >}}

{{< /tabs >}}
