/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.cmd.function.CaptureFunctionDataTypesCmd;
import ghidra.app.cmd.function.CaptureFunctionDataTypesListener;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProgramArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class CaptureFunctionDataTypesAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CaptureFunctionDataTypesAction(DataTypeManagerPlugin plugin) {
        super("Capture Function Data Types", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Capture Function Data Types"}, null, "VeryLast"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.plugin.getProgram() == null) {
            return false;
        }
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        return node instanceof ProgramArchiveNode || node instanceof FileArchiveNode || node instanceof ProjectArchiveNode;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath selectionPath = gTree.getSelectionPath();
        ArchiveNode node = (ArchiveNode)((Object)selectionPath.getLastPathComponent());
        if (!node.getArchive().isModifiable()) {
            this.informNotModifiable(node);
            return;
        }
        Program program = this.plugin.getProgram();
        AddressSetView currentSelection = this.plugin.getCurrentSelection();
        if (currentSelection == null || currentSelection.isEmpty()) {
            currentSelection = program.getMemory();
        }
        final DataTypeManager manager = node.getArchive().getDataTypeManager();
        final PluginTool tool = this.plugin.getTool();
        CaptureFunctionDataTypesCmd cmd = new CaptureFunctionDataTypesCmd(manager, currentSelection, new CaptureFunctionDataTypesListener(){

            @Override
            public void captureFunctionDataTypesCompleted(CaptureFunctionDataTypesCmd command) {
                tool.setStatusInfo("Captured function data types to \"" + manager.getName() + "\".");
            }
        });
        tool.executeBackgroundCommand((BackgroundCommand)cmd, (DomainObject)program);
    }

    private void informNotModifiable(ArchiveNode node) {
        String message = node instanceof ProgramArchiveNode ? "The program \"" + node.getName() + "\" isn't modifiable." : (node instanceof ProjectArchiveNode ? "The data type archive \"" + node.getName() + "\" isn't checked out." : (node instanceof ProjectArchiveNode ? "The data type archive \"" + node.getName() + "\" isn't open for editing." : "The data type archive \"" + node.getName() + "\" isn't modifiable."));
        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Cannot Capture Data Types", (Object)message);
    }
}

