/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.values.AbstractValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileValue
extends AbstractValue<File> {
    private GhidraFileChooserMode chooserMode;
    private File startingDir;
    private FileValuePanel filePanel;

    public FileValue(String name) {
        this(name, null);
    }

    public FileValue(String name, File defaultValue) {
        this(name, defaultValue, null, GhidraFileChooserMode.FILES_AND_DIRECTORIES);
    }

    public FileValue(String name, File defaultValue, File startingDir, GhidraFileChooserMode mode) {
        super(name, defaultValue);
        this.chooserMode = mode;
        this.startingDir = startingDir;
    }

    @Override
    public JComponent getComponent() {
        if (this.filePanel == null) {
            this.filePanel = new FileValuePanel(this.getName());
        }
        return this.filePanel;
    }

    @Override
    public void updateValueFromComponent() {
        this.setValue(this.filePanel.getFile());
    }

    @Override
    public void updateComponentFromValue() {
        this.filePanel.setValue((File)this.getValue());
    }

    @Override
    public File fromString(String valueString) {
        return new File(valueString);
    }

    class FileValuePanel
    extends JPanel {
        private JTextField textField;
        private JButton browseButton;

        public FileValuePanel(String name) {
            super(new BorderLayout());
            this.setName(name);
            this.textField = new JTextField(20);
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(e -> this.showFileChooser());
            this.add((Component)this.textField, "Center");
            this.add((Component)this.browseButton, "East");
        }

        public void setValue(File value) {
            String text = value == null ? "" : value.toString();
            this.textField.setText(text);
        }

        private void showFileChooser() {
            File selectedFile;
            GhidraFileChooser chooser = new GhidraFileChooser(null);
            chooser.setSelectedFile(this.getFile());
            chooser.setTitle("Choose " + this.getName());
            chooser.setFileSelectionMode(FileValue.this.chooserMode);
            if (FileValue.this.startingDir != null) {
                chooser.setCurrentDirectory(FileValue.this.startingDir);
            }
            if ((selectedFile = chooser.getSelectedFile()) != null) {
                this.textField.setText(selectedFile.toString());
            }
            chooser.dispose();
        }

        public File getFile() {
            String text = this.textField.getText().trim();
            if (text.isBlank()) {
                return null;
            }
            return new File(text);
        }
    }
}

