/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype;

import mdemangler.MDMang;
import mdemangler.MDType;

public class MDDataType
extends MDType {
    private static final String UNSIGNED = "unsigned ";
    private static final String SIGNED = "signed ";
    private Signage sign = Signage._SIGNED;
    protected String typeName = null;

    public MDDataType(MDMang dmang) {
        this(dmang, 1);
    }

    public MDDataType(MDMang dmang, String typeName) {
        this(dmang, 1);
        this.typeName = typeName;
    }

    public MDDataType(MDMang dmang, String typeName, int startIndexOffset) {
        this(dmang, startIndexOffset);
        this.typeName = typeName;
    }

    public MDDataType(MDMang dmang, int startIndexOffset) {
        super(dmang, startIndexOffset);
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public void setSigned() {
        this.sign = Signage._SPECIFIED_SIGNED;
    }

    public boolean isSigned() {
        return this.sign != Signage._UNSIGNED;
    }

    public void setUnsigned() {
        this.sign = Signage._UNSIGNED;
    }

    public boolean isSpecifiedSigned() {
        return this.sign == Signage._SPECIFIED_SIGNED;
    }

    public boolean isUnsigned() {
        return this.sign == Signage._UNSIGNED;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.getTypeName().length() != 0) {
            if (builder.length() != 0) {
                this.dmang.insertString(builder, " ");
            }
            this.dmang.insertString(builder, this.getTypeName());
        }
        if (this.sign == Signage._SPECIFIED_SIGNED) {
            this.dmang.insertSpacedString(builder, SIGNED);
        }
        if (this.sign == Signage._UNSIGNED) {
            this.dmang.insertSpacedString(builder, UNSIGNED);
        }
    }

    private static enum Signage {
        _SIGNED,
        _SPECIFIED_SIGNED,
        _UNSIGNED;

    }
}

