/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.data.ProgramProviderContext;
import ghidra.app.plugin.core.data.ProgramStructureProviderContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.DataTypeProviderContext;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class StructureFactory {
    public static final String DEFAULT_STRUCTURE_NAME = "struct";

    public static Structure createStructureDataType(Program program, Address address, int dataLength) {
        return StructureFactory.createStructureDataType(program, address, dataLength, DEFAULT_STRUCTURE_NAME, true);
    }

    public static Structure createStructureDataType(Program program, Address address, int dataLength, String structureName, boolean makeUniqueName) {
        Address endAddress;
        if (structureName == null) {
            throw new IllegalArgumentException("Structure name cannot be null.");
        }
        if (dataLength <= 0) {
            throw new IllegalArgumentException("Structure length must be positive, not " + dataLength);
        }
        try {
            endAddress = address.addNoWrap(dataLength - 1);
        }
        catch (AddressOverflowException e1) {
            throw new IllegalArgumentException("Can't create structure because length exceeds address space" + dataLength);
        }
        AddressSet set = new AddressSet(address, endAddress);
        InstructionIterator iter = program.getListing().getInstructions(set, true);
        if (iter.hasNext()) {
            throw new IllegalArgumentException("Can't create structure because the current selection contains instructions");
        }
        ProgramProviderContext providerContext = new ProgramProviderContext(program, address);
        String name = structureName;
        if (makeUniqueName) {
            name = providerContext.getUniqueName(name);
        }
        StructureDataType newStructure = new StructureDataType(name, 0, (DataTypeManager)program.getDataTypeManager());
        StructureFactory.initializeStructureFromContext(newStructure, providerContext, dataLength);
        return newStructure;
    }

    public static Structure createStructureDataTypeInStrucuture(Program program, Address address, int[] fromPath, int[] toPath) {
        return StructureFactory.createStructureDataTypeInStrucuture(program, address, fromPath, toPath, DEFAULT_STRUCTURE_NAME, true);
    }

    public static Structure createStructureDataTypeInStrucuture(Program program, Address address, int[] fromPath, int[] toPath, String structureName, boolean makeUniqueName) {
        if (structureName == null) {
            throw new IllegalArgumentException("Structure name cannot be null.");
        }
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(address);
        Data comp1 = data.getComponent(fromPath);
        Data comp2 = data.getComponent(toPath);
        if (comp1 == null || comp2 == null) {
            throw new IllegalArgumentException("Invalid selection");
        }
        int dataLength = comp2.getParentOffset() + comp2.getLength() - comp1.getParentOffset();
        if (dataLength <= 0) {
            throw new IllegalArgumentException("Data length must be positive, not " + dataLength);
        }
        Data firstComponent = data.getComponent(fromPath);
        DataType parentDataType = firstComponent.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            throw new IllegalArgumentException("New structure is not in a structure");
        }
        ProgramStructureProviderContext providerContext = new ProgramStructureProviderContext(program, data.getMinAddress(), (Structure)parentDataType, comp1.getParentOffset());
        String name = structureName;
        if (makeUniqueName) {
            name = providerContext.getUniqueName(name);
        }
        StructureDataType newStructure = new StructureDataType(name, 0, (DataTypeManager)program.getDataTypeManager());
        StructureFactory.initializeStructureFromContext(newStructure, providerContext, dataLength);
        return newStructure;
    }

    private static void initializeStructureFromContext(Structure structure, DataTypeProviderContext context, int dataLength) {
        DataTypeComponent[] dataComps = context.getDataTypeComponents(0, dataLength - 1);
        if (dataComps.length == 0) {
            throw new IllegalArgumentException("No data type components found");
        }
        DataType parent = dataComps[0].getParent();
        if (parent instanceof Composite) {
            Composite c = (Composite)parent;
            structure.setPackingEnabled(c.isPackingEnabled());
            if (c.getPackingType() == PackingType.EXPLICIT) {
                structure.setExplicitPackingValue(c.getExplicitPackingValue());
            }
        }
        for (DataTypeComponent dataComp : dataComps) {
            structure.add(dataComp.getDataType(), dataComp.getLength(), dataComp.getFieldName(), dataComp.getComment());
        }
    }
}

