/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.model.DomainFile;
import ghidra.framework.protocol.ghidra.GhidraURL;
import java.io.IOException;
import java.util.function.Consumer;

public interface LinkFileInfo {
    public DomainFile getFile();

    default public boolean isExternalLink() {
        return GhidraURL.isGhidraURL(this.getLinkPath());
    }

    default public boolean isFolderLink() {
        return "FolderLink".equals(this.getFile().getContentType());
    }

    public LinkedGhidraFolder getLinkedFolder();

    public String getLinkPath();

    public String getAbsoluteLinkPath() throws IOException;

    default public LinkHandler.LinkStatus getLinkStatus(Consumer<String> errorConsumer) {
        return LinkHandler.getLinkFileStatus(this.getFile(), errorConsumer);
    }
}

