﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/Omics_EXPORTS.h>
#include <aws/omics/model/FileType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Omics {
namespace Model {

/**
 * <p> Part of the response to ListMultipartReadSetUploads, excluding completed and
 * aborted multipart uploads. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/MultipartReadSetUploadListItem">AWS
 * API Reference</a></p>
 */
class MultipartReadSetUploadListItem {
 public:
  AWS_OMICS_API MultipartReadSetUploadListItem() = default;
  AWS_OMICS_API MultipartReadSetUploadListItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API MultipartReadSetUploadListItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The sequence store ID used for the multipart upload. </p>
   */
  inline const Aws::String& GetSequenceStoreId() const { return m_sequenceStoreId; }
  inline bool SequenceStoreIdHasBeenSet() const { return m_sequenceStoreIdHasBeenSet; }
  template <typename SequenceStoreIdT = Aws::String>
  void SetSequenceStoreId(SequenceStoreIdT&& value) {
    m_sequenceStoreIdHasBeenSet = true;
    m_sequenceStoreId = std::forward<SequenceStoreIdT>(value);
  }
  template <typename SequenceStoreIdT = Aws::String>
  MultipartReadSetUploadListItem& WithSequenceStoreId(SequenceStoreIdT&& value) {
    SetSequenceStoreId(std::forward<SequenceStoreIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The ID for the initiated multipart upload. </p>
   */
  inline const Aws::String& GetUploadId() const { return m_uploadId; }
  inline bool UploadIdHasBeenSet() const { return m_uploadIdHasBeenSet; }
  template <typename UploadIdT = Aws::String>
  void SetUploadId(UploadIdT&& value) {
    m_uploadIdHasBeenSet = true;
    m_uploadId = std::forward<UploadIdT>(value);
  }
  template <typename UploadIdT = Aws::String>
  MultipartReadSetUploadListItem& WithUploadId(UploadIdT&& value) {
    SetUploadId(std::forward<UploadIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of file the read set originated from. </p>
   */
  inline FileType GetSourceFileType() const { return m_sourceFileType; }
  inline bool SourceFileTypeHasBeenSet() const { return m_sourceFileTypeHasBeenSet; }
  inline void SetSourceFileType(FileType value) {
    m_sourceFileTypeHasBeenSet = true;
    m_sourceFileType = value;
  }
  inline MultipartReadSetUploadListItem& WithSourceFileType(FileType value) {
    SetSourceFileType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The read set source's subject ID. </p>
   */
  inline const Aws::String& GetSubjectId() const { return m_subjectId; }
  inline bool SubjectIdHasBeenSet() const { return m_subjectIdHasBeenSet; }
  template <typename SubjectIdT = Aws::String>
  void SetSubjectId(SubjectIdT&& value) {
    m_subjectIdHasBeenSet = true;
    m_subjectId = std::forward<SubjectIdT>(value);
  }
  template <typename SubjectIdT = Aws::String>
  MultipartReadSetUploadListItem& WithSubjectId(SubjectIdT&& value) {
    SetSubjectId(std::forward<SubjectIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The read set source's sample ID. </p>
   */
  inline const Aws::String& GetSampleId() const { return m_sampleId; }
  inline bool SampleIdHasBeenSet() const { return m_sampleIdHasBeenSet; }
  template <typename SampleIdT = Aws::String>
  void SetSampleId(SampleIdT&& value) {
    m_sampleIdHasBeenSet = true;
    m_sampleId = std::forward<SampleIdT>(value);
  }
  template <typename SampleIdT = Aws::String>
  MultipartReadSetUploadListItem& WithSampleId(SampleIdT&& value) {
    SetSampleId(std::forward<SampleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The source of an uploaded part. </p>
   */
  inline const Aws::String& GetGeneratedFrom() const { return m_generatedFrom; }
  inline bool GeneratedFromHasBeenSet() const { return m_generatedFromHasBeenSet; }
  template <typename GeneratedFromT = Aws::String>
  void SetGeneratedFrom(GeneratedFromT&& value) {
    m_generatedFromHasBeenSet = true;
    m_generatedFrom = std::forward<GeneratedFromT>(value);
  }
  template <typename GeneratedFromT = Aws::String>
  MultipartReadSetUploadListItem& WithGeneratedFrom(GeneratedFromT&& value) {
    SetGeneratedFrom(std::forward<GeneratedFromT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The source's reference ARN. </p>
   */
  inline const Aws::String& GetReferenceArn() const { return m_referenceArn; }
  inline bool ReferenceArnHasBeenSet() const { return m_referenceArnHasBeenSet; }
  template <typename ReferenceArnT = Aws::String>
  void SetReferenceArn(ReferenceArnT&& value) {
    m_referenceArnHasBeenSet = true;
    m_referenceArn = std::forward<ReferenceArnT>(value);
  }
  template <typename ReferenceArnT = Aws::String>
  MultipartReadSetUploadListItem& WithReferenceArn(ReferenceArnT&& value) {
    SetReferenceArn(std::forward<ReferenceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of a read set. </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  MultipartReadSetUploadListItem& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The description of a read set. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  MultipartReadSetUploadListItem& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Any tags you wish to add to a read set. </p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  MultipartReadSetUploadListItem& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  MultipartReadSetUploadListItem& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The time stamp for when a direct upload was created. </p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  MultipartReadSetUploadListItem& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sequenceStoreId;

  Aws::String m_uploadId;

  FileType m_sourceFileType{FileType::NOT_SET};

  Aws::String m_subjectId;

  Aws::String m_sampleId;

  Aws::String m_generatedFrom;

  Aws::String m_referenceArn;

  Aws::String m_name;

  Aws::String m_description;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::Utils::DateTime m_creationTime{};
  bool m_sequenceStoreIdHasBeenSet = false;
  bool m_uploadIdHasBeenSet = false;
  bool m_sourceFileTypeHasBeenSet = false;
  bool m_subjectIdHasBeenSet = false;
  bool m_sampleIdHasBeenSet = false;
  bool m_generatedFromHasBeenSet = false;
  bool m_referenceArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Omics
}  // namespace Aws
