﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/PortalStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {
class DeletePortalResult {
 public:
  AWS_IOTSITEWISE_API DeletePortalResult() = default;
  AWS_IOTSITEWISE_API DeletePortalResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTSITEWISE_API DeletePortalResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The status of the portal, which contains a state (<code>DELETING</code> after
   * successfully calling this operation) and any error message.</p>
   */
  inline const PortalStatus& GetPortalStatus() const { return m_portalStatus; }
  template <typename PortalStatusT = PortalStatus>
  void SetPortalStatus(PortalStatusT&& value) {
    m_portalStatusHasBeenSet = true;
    m_portalStatus = std::forward<PortalStatusT>(value);
  }
  template <typename PortalStatusT = PortalStatus>
  DeletePortalResult& WithPortalStatus(PortalStatusT&& value) {
    SetPortalStatus(std::forward<PortalStatusT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeletePortalResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  PortalStatus m_portalStatus;

  Aws::String m_requestId;
  bool m_portalStatusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
