/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.observation.transport.Kind;
import io.micrometer.observation.transport.SenderContext;

public class LettuceObservationContext
extends SenderContext<Object> {
    private volatile RedisCommand<?, ?, ?> command;
    private volatile Tracing.Endpoint endpoint;

    public LettuceObservationContext(String serviceName) {
        super((carrier, key, value) -> {}, Kind.CLIENT);
        this.setRemoteServiceName(serviceName);
    }

    public RedisCommand<?, ?, ?> getRequiredCommand() {
        RedisCommand<?, ?, ?> local = this.command;
        if (local == null) {
            throw new IllegalStateException("LettuceObservationContext is not associated with a Command");
        }
        return local;
    }

    public void setCommand(RedisCommand<?, ?, ?> command) {
        this.command = command;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public Tracing.Endpoint getRequiredEndpoint() {
        Tracing.Endpoint local = this.endpoint;
        if (local == null) {
            throw new IllegalStateException("LettuceObservationContext is not associated with a Endpoint");
        }
        return local;
    }

    public void setEndpoint(Tracing.Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(" [name=").append(this.getName());
        sb.append(", contextualName=").append(this.getContextualName());
        sb.append(", error=").append(this.getError());
        sb.append(", lowCardinalityKeyValues=").append(this.getLowCardinalityKeyValues());
        sb.append(", highCardinalityKeyValues=").append(this.getHighCardinalityKeyValues());
        sb.append(", parentObservation=").append(this.getParentObservation());
        sb.append(", command=").append(this.command);
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(']');
        return sb.toString();
    }
}

