/**
 * SECTION:potential-match
 * @short_description: Match calculator for pairs of individuals.
 * @folks_potential_match_known_email_aliases: A set of e-mail addresses known to be aliases of each other, such as various forms of administrator address.
 * 
 * <para>This provides functionality to explore the degree of a potential match between two individuals. It compares the similarity of the individuals&apos; properties to determine how likely it is that the individuals represent the same physical person.</para><para>This can be used by folks clients to, for example, present suggestions of pairs of individuals which should be linked by the user.</para>
 *
 * Since: 0.5.0
 */
/**
 * FOLKS_TYPE_POTENTIAL_MATCH:
 * 
 * The type for <link linkend="FolksPotentialMatch"><type>FolksPotentialMatch</type></link>.
 */
/**
 * folks_potential_match_potential_match:
 * @self: the <link linkend="FolksPotentialMatch"><type>FolksPotentialMatch</type></link> instance
 * @a: (in): &nbsp;.  <para>an individual to compare </para>
 * @b: (in): &nbsp;.  <para>another individual to compare </para>
 * 
 * Whether two individuals are likely to be the same person.
 *
 * Since: 0.5.0
 */
/**
 * folks_potential_match_new:
 * 
 * Create a new PotentialMatch.
 * 
 * Returns: <para>a new PotentialMatch </para>
 *
 * Since: 0.5.0
 */
/**
 * FolksPotentialMatch:
 * @folks_potential_match_known_email_aliases: A set of e-mail addresses known to be aliases of each other, such as various forms of administrator address.
 * 
 * Match calculator for pairs of individuals.
 * 
 * <para>This provides functionality to explore the degree of a potential match between two individuals. It compares the similarity of the individuals&apos; properties to determine how likely it is that the individuals represent the same physical person.</para><para>This can be used by folks clients to, for example, present suggestions of pairs of individuals which should be linked by the user.</para>
 *
 * Since: 0.5.0
 */
/**
 * FolksPotentialMatchClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-POTENTIAL-MATCH:CAPS"><literal>FOLKS_TYPE_POTENTIAL_MATCH</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksMatchResult:
 * @FOLKS_MATCH_RESULT_NONE: Zero likelihood of a match.<para>This is used in situations where two individuals should never be linked, such as when one of them has a <link linkend="FolksIndividual--trust-level"><type>"trust-level"</type></link> of <link linkend="FOLKS-TRUST-LEVEL-NONE"><type>FOLKS_TRUST_LEVEL_NONE</type></link>, or when the individuals are explicitly anti-linked.</para>
 * @FOLKS_MATCH_RESULT_VERY_LOW: Very low likelihood of a match.
 * @FOLKS_MATCH_RESULT_LOW: Low likelihood of a match.
 * @FOLKS_MATCH_RESULT_MEDIUM: Medium likelihood of a match.
 * @FOLKS_MATCH_RESULT_HIGH: High likelihood of a match.
 * @FOLKS_MATCH_RESULT_VERY_HIGH: Very high likelihood of a match.
 * @FOLKS_MATCH_RESULT_MIN: Minimum likelihood of a match.
 * @FOLKS_MATCH_RESULT_MAX: Maximum likelihood of a match.
 * 
 * Likely-ness of a potential match.
 * 
 * <para>Note that the order should be maintained.</para>
 *
 * Since: 0.5.0
 */
