/**
 * Executes shell command as it would happen in BASH script
 * @param {string} command
 * @param {Object} [options] Object with options.
 *                           Set `echo` to TRUE, to echo command passed.
 *                           Set `ignore` to TRUE to ignore stdout
 *                           Set `capture` to TRUE, to capture and return stdout.
 *
 * @returns {Promise<{code: number, data: string | undefined, error: Object}>}
 *
 * https://github.com/oclif/core/issues/453#issuecomment-1200778612
 * codespool:
 * You could wrap spawn in a promise, listen to exit event, and resolve when it happens. That should play nicely with oclif/core.
 * We are using it here:
 * https://github.com/AstarNetwork/swanky-cli/blob/master/src/commands/compile/index.ts
 */
import { IExec } from '../interfaces/index.js';
/**
 *
 * @param command
 * @param param1
 * @returns
 */
export declare function exec(command: string, { capture, echo, ignore }?: {
    capture?: boolean | undefined;
    echo?: boolean | undefined;
    ignore?: boolean | undefined;
}): Promise<IExec>;
