/**
 * ./src/components/title.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { Box, Newline, Text } from 'ink';
// pjson
import { createRequire } from 'module';
import React from 'react';
import Utils from '../../classes/utils.js';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Title({ title = "", version = "" }) {
    let arch = "-";
    if (Utils.isAppImage()) {
        arch += "AppImage";
    }
    else
        switch (process.arch) {
            case "arm64": {
                arch += "arm64";
                break;
            }
            case "ia32": {
                arch += "i386";
                break;
            }
            case "riscv64": {
                arch += "riscv64";
                break;
            }
            case "x64": {
                arch += "x86_64";
                break;
            }
            // No default
        }
    if (title === "")
        title = `${pjson.name}`;
    const green = ` ${title}`.padEnd(25, " ");
    const white = ` Perri's brewery edition `.padEnd(25, " ");
    const red = ` v${pjson.version}${arch} `.padStart(25, " ");
    return (React.createElement(React.Fragment, null,
        React.createElement(Box, { flexDirection: "column" },
            React.createElement(Box, null),
            React.createElement(Box, null,
                React.createElement(Text, null, "E G G S: reproductive system of penguins")),
            React.createElement(Newline, null)),
        React.createElement(Box, { flexDirection: "row" },
            React.createElement(Text, { backgroundColor: "green" }, green),
            React.createElement(Text, { backgroundColor: "white", color: "blue" }, white),
            React.createElement(Text, { backgroundColor: "red" }, red))));
}
