# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.1.1.9999
#hackport: flags: -wall

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
CABAL_HACKAGE_REVISION="1"
inherit haskell-cabal

CABAL_FILE="${S}/${PN}.cabal"
CABAL_DISTFILE="${P}-rev${CABAL_HACKAGE_REVISION}.cabal"

DESCRIPTION="Efficient Arrays"
HOMEPAGE="https://github.com/haskell/vector"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz
	https://hackage.haskell.org/package/${P}/revision/${CABAL_HACKAGE_REVISION}.cabal
		-> ${CABAL_DISTFILE}"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="+boundschecks internalchecks unsafechecks"

PATCHES=(
	"${FILESDIR}/${PN}-0.12.3.1-cabal-doctest.patch"
	"${FILESDIR}/${PN}-0.12.3.1-fix-testdata-float.patch"

)

RDEPEND=">=dev-haskell/primitive-0.6.4.0:=[profile?] <dev-haskell/primitive-0.8:=[profile?]
	>=dev-lang/ghc-8.4.3:=
"

# doctests do not work on >=ghc-9.2
RDEPEND+="
	test? (
		<dev-lang/ghc-9.1
	)
"

DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.2.0.1
	dev-haskell/cabal-doctest
	test? ( >=dev-haskell/base-orphans-0.6
		dev-haskell/base-compat
		>=dev-haskell/doctest-0.15
		dev-haskell/hunit
		>=dev-haskell/quickcheck-2.9 <dev-haskell/quickcheck-2.15
		dev-haskell/random
		dev-haskell/tasty
		dev-haskell/tasty-hunit
		dev-haskell/tasty-quickcheck )
"

CABAL_CHDEPS=(
	'doctest   >=0.15 && <0.19' 'doctest >=0.15'
)

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag boundschecks boundschecks) \
		$(cabal_flag internalchecks internalchecks) \
		$(cabal_flag unsafechecks unsafechecks) \
		--flag=-wall
}

GHC_BOOTSTRAP_PACKAGES=( cabal-doctest )
