/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;

public class MIMEReader {
    private static final int H_NAME = 1;
    private static final int H_VALUE = 2;
    private static final int H_DONE = 3;
    private static final int B_SOL = 4;
    private static final int B_CR = 5;
    private static final int B_MATCHSEP = 6;
    private static final int B_DATA = 7;
    private static final int B_MATCHLAST = 8;
    private InputStream stream = null;
    private String boundary = null;
    private String separator = null;
    private String lastsep = null;
    int peek = -1;
    private Header[] headers;
    private int headerPos = 0;

    public MIMEReader(InputStream inputStream, String string) {
        this.stream = inputStream;
        this.boundary = string;
        this.separator = "--" + string;
        this.lastsep = this.separator + "--";
        if (this.separator == null) {
            throw new NullPointerException();
        }
        String string2 = this.getLine();
        if (!this.separator.equals(string2)) {
            throw new XProcException("MIME multipart doesn't start with separator?");
        }
    }

    public boolean readHeaders() {
        int n = 5;
        int n2 = 2;
        this.headers = new Header[n];
        this.headerPos = 0;
        if (this.peekByte() < 0) {
            return false;
        }
        Header header = this.getHeader();
        while (header != null) {
            if (this.headerPos == n) {
                Header[] headerArray = new Header[n + n2];
                System.arraycopy(this.headers, 0, headerArray, 0, n);
                this.headers = headerArray;
                n += n2;
            }
            this.headers[this.headerPos++] = header;
            header = this.getHeader();
        }
        return true;
    }

    public Header[] getHeaders() {
        Header[] headerArray = new Header[this.headerPos];
        System.arraycopy(this.headers, 0, headerArray, 0, this.headerPos);
        return headerArray;
    }

    public Header getHeader(String string) {
        for (int i = 0; i < this.headerPos; ++i) {
            if (!string.toLowerCase().equals(this.headers[i].getName().toLowerCase())) continue;
            return this.headers[i];
        }
        return null;
    }

    private Header getHeader() {
        String string = "";
        String string2 = "";
        int n = 1;
        block4: while (n != 3) {
            int n2 = this.nextByte();
            int n3 = this.peekByte();
            if (n2 == 13) {
                if (n3 == 10) {
                    n2 = this.nextByte();
                    n3 = this.peekByte();
                } else {
                    n2 = 10;
                }
            }
            if (n2 < 0) {
                throw new XProcException("Got -1 reading stream...");
            }
            switch (n) {
                case 1: {
                    if (n2 == 10) {
                        n = 3;
                        break;
                    }
                    if (n2 == 58) {
                        n = 2;
                        break;
                    }
                    string = string + (char)n2;
                    break;
                }
                case 2: {
                    if (n2 == 10) {
                        if (n3 == 32) continue block4;
                        if (n3 == 9) break;
                        n = 3;
                        break;
                    }
                    string2 = string2 + (char)n2;
                    break;
                }
                default: {
                    throw new XProcException("Default in getHeader?");
                }
            }
        }
        if ("".equals(string)) {
            return null;
        }
        string = string.trim();
        string2 = string2.trim();
        return new Header(string, string2);
    }

    public String getLine() {
        String string = "";
        boolean bl = false;
        while (!bl) {
            int n = this.nextByte();
            int n2 = this.peekByte();
            if (n == 13) {
                if (n2 == 10) {
                    n = this.nextByte();
                    n2 = this.peekByte();
                } else {
                    n = 10;
                }
            }
            if (n < 0) {
                throw new XProcException("Got -1 reading stream...");
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            string = string + (char)n;
        }
        return string;
    }

    public InputStream readBodyPart(int n) {
        String string;
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        if (this.peek >= 0) {
            byArray[0] = (byte)this.peek;
            this.peek = -1;
            ++n3;
            --n;
        }
        while (n > 0) {
            try {
                n2 = this.stream.read(byArray, n3, n);
                if (n2 < 0) {
                    throw new XProcException("Read returned -1?");
                }
                n3 += n2;
                n -= n2;
            }
            catch (IOException iOException) {
                throw new XProcException(iOException);
            }
        }
        n2 = this.peekByte();
        if (n2 == 13) {
            this.nextByte();
            n2 = this.peekByte();
        }
        if (n2 == 10) {
            this.nextByte();
        }
        if (!this.separator.equals(string = this.getLine()) && !this.lastsep.equals(string)) {
            throw new XProcException("MIME multipart missing separator?");
        }
        return new ByteArrayInputStream(byArray);
    }

    public InputStream readBodyPart() {
        int n = 4096;
        int n2 = 16384;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 4;
        while (!bl) {
            int n6 = this.nextByte();
            if (n6 < 0) {
                throw new XProcException("Got -1 in readBodyPart?");
            }
            if (n3 == n2) {
                byte[] byArray2 = new byte[n2 + n];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                n2 += n;
            }
            char c = (char)n6;
            byArray[n3++] = (byte)n6;
            switch (n5) {
                case 4: 
                case 6: {
                    if (n4 == this.separator.length()) {
                        if (n6 == 45) {
                            n5 = 8;
                            this.nextByte();
                            break;
                        }
                        if (n6 == 13 || n6 == 10) {
                            bl = true;
                            n3 -= this.separator.length() + 3;
                            if (n6 != 13 || this.peekByte() != 10) break;
                            this.nextByte();
                            break;
                        }
                        n5 = 7;
                        n4 = 0;
                        break;
                    }
                    if ((char)n6 == this.separator.charAt(n4)) {
                        n5 = 6;
                        ++n4;
                        break;
                    }
                    n4 = 0;
                    if (n6 == 10) {
                        n5 = 4;
                        break;
                    }
                    n5 = 7;
                    break;
                }
                case 8: {
                    if (n6 == 13 || n6 == 10) {
                        bl = true;
                        n3 -= this.separator.length() + 4;
                        if (n6 != 13 || this.peekByte() != 10) break;
                        this.nextByte();
                        break;
                    }
                    n5 = 7;
                    n4 = 0;
                    break;
                }
                case 5: 
                case 7: {
                    if (n6 != 10) break;
                    n5 = 4;
                }
            }
            if (n6 != 13) continue;
            n5 = 5;
        }
        return new ByteArrayInputStream(byArray, 0, n3);
    }

    private int peekByte() {
        if (this.peek >= 0) {
            return this.peek;
        }
        try {
            this.peek = this.stream.read();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        return this.peek;
    }

    private int nextByte() {
        if (this.peek >= 0) {
            int n = this.peek;
            this.peek = -1;
            return n;
        }
        try {
            return this.stream.read();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }
}

