package styles

import (
	"github.com/alecthomas/chroma"
)

// Murphy style.
var Murphy = Register(chroma.MustNewStyle("murphy", chroma.StyleEntries{
	chroma.TextWhitespace:        "#bbbbbb",
	chroma.Comment:               "#666 italic",
	chroma.CommentPreproc:        "#579 noitalic",
	chroma.CommentSpecial:        "#c00 bold",
	chroma.Keyword:               "bold #289",
	chroma.KeywordPseudo:         "#08f",
	chroma.KeywordType:           "#66f",
	chroma.Operator:              "#333",
	chroma.OperatorWord:          "bold #000",
	chroma.NameBuiltin:           "#072",
	chroma.NameFunction:          "bold #5ed",
	chroma.NameClass:             "bold #e9e",
	chroma.NameNamespace:         "bold #0e84b5",
	chroma.NameException:         "bold #F00",
	chroma.NameVariable:          "#036",
	chroma.NameVariableInstance:  "#aaf",
	chroma.NameVariableClass:     "#ccf",
	chroma.NameVariableGlobal:    "#f84",
	chroma.NameConstant:          "bold #5ed",
	chroma.NameLabel:             "bold #970",
	chroma.NameEntity:            "#800",
	chroma.NameAttribute:         "#007",
	chroma.NameTag:               "#070",
	chroma.NameDecorator:         "bold #555",
	chroma.LiteralString:         "bg:#e0e0ff",
	chroma.LiteralStringChar:     "#88F bg:",
	chroma.LiteralStringDoc:      "#D42 bg:",
	chroma.LiteralStringInterpol: "bg:#eee",
	chroma.LiteralStringEscape:   "bold #666",
	chroma.LiteralStringRegex:    "bg:#e0e0ff #000",
	chroma.LiteralStringSymbol:   "#fc8 bg:",
	chroma.LiteralStringOther:    "#f88",
	chroma.LiteralNumber:         "bold #60E",
	chroma.LiteralNumberInteger:  "bold #66f",
	chroma.LiteralNumberFloat:    "bold #60E",
	chroma.LiteralNumberHex:      "bold #058",
	chroma.LiteralNumberOct:      "bold #40E",
	chroma.GenericHeading:        "bold #000080",
	chroma.GenericSubheading:     "bold #800080",
	chroma.GenericDeleted:        "#A00000",
	chroma.GenericInserted:       "#00A000",
	chroma.GenericError:          "#FF0000",
	chroma.GenericEmph:           "italic",
	chroma.GenericStrong:         "bold",
	chroma.GenericPrompt:         "bold #c65d09",
	chroma.GenericOutput:         "#888",
	chroma.GenericTraceback:      "#04D",
	chroma.GenericUnderline:      "underline",
	chroma.Error:                 "#F00 bg:#FAA",
	chroma.Background:            " bg:#ffffff",
}))
