<div align="center">
  <h1><code>wasip3</code></h1>

<strong>A <a href="https://bytecodealliance.org/">Bytecode Alliance</a> project</strong>

  <p>
    <strong>WASIp2 API Bindings for Rust</strong>
  </p>

  <p>
    <a href="https://crates.io/crates/wasip3"><img src="https://img.shields.io/crates/v/wasip3.svg?style=flat-square" alt="Crates.io version" /></a>
    <a href="https://crates.io/crates/wasip3"><img src="https://img.shields.io/crates/d/wasip3.svg?style=flat-square" alt="Download" /></a>
    <a href="https://docs.rs/wasip3/"><img src="https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square" alt="docs.rs docs" /></a>
  </p>
</div>

This crate contains bindings for [WASIp3](https://github.com/WebAssembly/WASI)
APIs for the worlds:

* [`wasi:cli/command`]
* [`wasi:http/proxy`]

This crate is procedurally generated from [WIT] files using [`wit-bindgen`].

[`wasi:cli/command`]: https://github.com/WebAssembly/wasi-cli
[`wasi:http/proxy`]: https://github.com/WebAssembly/wasi-http
[WIT]: https://component-model.bytecodealliance.org/design/wit.html
[`wit-bindgen`]: https://github.com/bytecodealliance/wit-bindgen
[components]: https://component-model.bytecodealliance.org/
[`wasm-tools`]: https://github.com/bytecodealliance/wasm-tools

# Usage

Depending on this crate can be done by adding it to your dependencies:

```sh
$ cargo add wasip3
```

Using this crate requires Rust 1.90.0. If you're using this before 2025-09-18
you'll want to use the beta channel of Rust. You'll also want to use this crate
with the `wasm32-wasip2` target (the Rust compiler does not currently have a
`wasm32-wasip3` target).

# Development

The bulk of the `wasip3` crate is generated by the [`wit-bindgen`] tool. The
`src/bindings.rs` file can be regenerated with:

```
$ ./ci/regenerate.sh
```

WASI definitions are located in the `wit` directory of this repository.
Currently they're copied from upstream repositories but are hoped to be better
managed in the future.
