// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	proto "google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// ApiKeyClient provides methods for managing ApiKey resources of Yandex.Cloud IAM.
type ApiKeyClient interface {
	ApiKeyClientIterator
	List(context.Context, *iam.ListApiKeysRequest, ...grpc.CallOption) (*iam.ListApiKeysResponse, error)
	Get(context.Context, *iam.GetApiKeyRequest, ...grpc.CallOption) (*iam.ApiKey, error)
	Create(context.Context, *iam.CreateApiKeyRequest, ...grpc.CallOption) (*iam.CreateApiKeyResponse, error)
	Update(context.Context, *iam.UpdateApiKeyRequest, ...grpc.CallOption) (*ApiKeyUpdateOperation, error)
	Delete(context.Context, *iam.DeleteApiKeyRequest, ...grpc.CallOption) (*ApiKeyDeleteOperation, error)
	ListOperations(context.Context, *iam.ListApiKeyOperationsRequest, ...grpc.CallOption) (*iam.ListApiKeyOperationsResponse, error)
	ListScopes(context.Context, *iam.ListApiKeyScopesRequest, ...grpc.CallOption) (*iam.ListApiKeyScopesResponse, error)
}

var _ ApiKeyClient = apiKeyClient{}

type apiKeyClient struct {
	connector transport.Connector
}

// NewApiKeyClient returns ApiKeyClient implementation.
func NewApiKeyClient(connector transport.Connector) ApiKeyClient {
	return apiKeyClient{connector}
}

// List is an operation of Yandex.Cloud IAM ApiKey service.
func (c apiKeyClient) List(ctx context.Context, in *iam.ListApiKeysRequest, opts ...grpc.CallOption) (*iam.ListApiKeysResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewApiKeyServiceClient(connection).List(ctx, in, opts...)
}

// Get is an operation of Yandex.Cloud IAM ApiKey service.
func (c apiKeyClient) Get(ctx context.Context, in *iam.GetApiKeyRequest, opts ...grpc.CallOption) (*iam.ApiKey, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyGet, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewApiKeyServiceClient(connection).Get(ctx, in, opts...)
}

// Create is an operation of Yandex.Cloud IAM ApiKey service.
func (c apiKeyClient) Create(ctx context.Context, in *iam.CreateApiKeyRequest, opts ...grpc.CallOption) (*iam.CreateApiKeyResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyCreate, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewApiKeyServiceClient(connection).Create(ctx, in, opts...)
}

// ApiKeyUpdateOperation is used to monitor the state of Update operations.
type ApiKeyUpdateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *ApiKeyUpdateOperation) Metadata() *iam.UpdateApiKeyMetadata {
	return o.Operation.Metadata().(*iam.UpdateApiKeyMetadata)
}

// Response retrieves the operation response.
func (o *ApiKeyUpdateOperation) Response() *iam.ApiKey {
	return o.Operation.Response().(*iam.ApiKey)
}

// Wait polls the operation until it's done.
func (o *ApiKeyUpdateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.ApiKey, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.ApiKey)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *ApiKeyUpdateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.ApiKey, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.ApiKey)
	return response, err
}

// Update is an operation of Yandex.Cloud IAM ApiKey service.
// It returns an object which should be used to monitor the operation state.
func (c apiKeyClient) Update(ctx context.Context, in *iam.UpdateApiKeyRequest, opts ...grpc.CallOption) (*ApiKeyUpdateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyUpdate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewApiKeyServiceClient(connection).Update(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*iam.UpdateApiKeyMetadata).GetApiKeyId()
		},
		MetadataType: (*iam.UpdateApiKeyMetadata)(nil),
		ResponseType: (*iam.ApiKey)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &ApiKeyUpdateOperation{*op}, nil
}

// ApiKeyDeleteOperation is used to monitor the state of Delete operations.
type ApiKeyDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *ApiKeyDeleteOperation) Metadata() *iam.DeleteApiKeyMetadata {
	return o.Operation.Metadata().(*iam.DeleteApiKeyMetadata)
}

// Response retrieves the operation response.
func (o *ApiKeyDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *ApiKeyDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *ApiKeyDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud IAM ApiKey service.
// It returns an object which should be used to monitor the operation state.
func (c apiKeyClient) Delete(ctx context.Context, in *iam.DeleteApiKeyRequest, opts ...grpc.CallOption) (*ApiKeyDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewApiKeyServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*iam.DeleteApiKeyMetadata).GetApiKeyId()
		},
		MetadataType: (*iam.DeleteApiKeyMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &ApiKeyDeleteOperation{*op}, nil
}

// ListOperations is an operation of Yandex.Cloud IAM ApiKey service.
func (c apiKeyClient) ListOperations(ctx context.Context, in *iam.ListApiKeyOperationsRequest, opts ...grpc.CallOption) (*iam.ListApiKeyOperationsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyListOperations, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewApiKeyServiceClient(connection).ListOperations(ctx, in, opts...)
}

// ListScopes is an operation of Yandex.Cloud IAM ApiKey service.
func (c apiKeyClient) ListScopes(ctx context.Context, in *iam.ListApiKeyScopesRequest, opts ...grpc.CallOption) (*iam.ListApiKeyScopesResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyListScopes, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewApiKeyServiceClient(connection).ListScopes(ctx, in, opts...)
}

// pollOperation returns the current state of the polled operation.
func (c apiKeyClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ApiKeyOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	ApiKeyList            = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.List")
	ApiKeyGet             = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.Get")
	ApiKeyCreate          = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.Create")
	ApiKeyUpdate          = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.Update")
	ApiKeyDelete          = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.Delete")
	ApiKeyListOperations  = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.ListOperations")
	ApiKeyListScopes      = protoreflect.FullName("yandex.cloud.iam.v1.ApiKeyService.ListScopes")
	ApiKeyOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
