// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmincidents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetIncidentFindings = "BatchGetIncidentFindings"

// BatchGetIncidentFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetIncidentFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetIncidentFindings for more information on using the BatchGetIncidentFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetIncidentFindingsRequest method.
//	req, resp := client.BatchGetIncidentFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/BatchGetIncidentFindings
func (c *SSMIncidents) BatchGetIncidentFindingsRequest(input *BatchGetIncidentFindingsInput) (req *request.Request, output *BatchGetIncidentFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchGetIncidentFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/batchGetIncidentFindings",
	}

	if input == nil {
		input = &BatchGetIncidentFindingsInput{}
	}

	output = &BatchGetIncidentFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetIncidentFindings API operation for AWS Systems Manager Incident Manager.
//
// Retrieves details about all specified findings for an incident, including
// descriptive details about each finding. A finding represents a recent application
// environment change made by an CodeDeploy deployment or an CloudFormation
// stack creation or update that can be investigated as a potential cause of
// the incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation BatchGetIncidentFindings for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/BatchGetIncidentFindings
func (c *SSMIncidents) BatchGetIncidentFindings(input *BatchGetIncidentFindingsInput) (*BatchGetIncidentFindingsOutput, error) {
	req, out := c.BatchGetIncidentFindingsRequest(input)
	return out, req.Send()
}

// BatchGetIncidentFindingsWithContext is the same as BatchGetIncidentFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetIncidentFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) BatchGetIncidentFindingsWithContext(ctx aws.Context, input *BatchGetIncidentFindingsInput, opts ...request.Option) (*BatchGetIncidentFindingsOutput, error) {
	req, out := c.BatchGetIncidentFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationSet = "CreateReplicationSet"

// CreateReplicationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationSet for more information on using the CreateReplicationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationSetRequest method.
//	req, resp := client.CreateReplicationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateReplicationSet
func (c *SSMIncidents) CreateReplicationSetRequest(input *CreateReplicationSetInput) (req *request.Request, output *CreateReplicationSetOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/createReplicationSet",
	}

	if input == nil {
		input = &CreateReplicationSetInput{}
	}

	output = &CreateReplicationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationSet API operation for AWS Systems Manager Incident Manager.
//
// A replication set replicates and encrypts your data to the provided Regions
// with the provided KMS key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation CreateReplicationSet for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateReplicationSet
func (c *SSMIncidents) CreateReplicationSet(input *CreateReplicationSetInput) (*CreateReplicationSetOutput, error) {
	req, out := c.CreateReplicationSetRequest(input)
	return out, req.Send()
}

// CreateReplicationSetWithContext is the same as CreateReplicationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) CreateReplicationSetWithContext(ctx aws.Context, input *CreateReplicationSetInput, opts ...request.Option) (*CreateReplicationSetOutput, error) {
	req, out := c.CreateReplicationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResponsePlan = "CreateResponsePlan"

// CreateResponsePlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateResponsePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResponsePlan for more information on using the CreateResponsePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResponsePlanRequest method.
//	req, resp := client.CreateResponsePlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateResponsePlan
func (c *SSMIncidents) CreateResponsePlanRequest(input *CreateResponsePlanInput) (req *request.Request, output *CreateResponsePlanOutput) {
	op := &request.Operation{
		Name:       opCreateResponsePlan,
		HTTPMethod: "POST",
		HTTPPath:   "/createResponsePlan",
	}

	if input == nil {
		input = &CreateResponsePlanInput{}
	}

	output = &CreateResponsePlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResponsePlan API operation for AWS Systems Manager Incident Manager.
//
// Creates a response plan that automates the initial response to incidents.
// A response plan engages contacts, starts chat channel collaboration, and
// initiates runbooks at the beginning of an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation CreateResponsePlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateResponsePlan
func (c *SSMIncidents) CreateResponsePlan(input *CreateResponsePlanInput) (*CreateResponsePlanOutput, error) {
	req, out := c.CreateResponsePlanRequest(input)
	return out, req.Send()
}

// CreateResponsePlanWithContext is the same as CreateResponsePlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResponsePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) CreateResponsePlanWithContext(ctx aws.Context, input *CreateResponsePlanInput, opts ...request.Option) (*CreateResponsePlanOutput, error) {
	req, out := c.CreateResponsePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTimelineEvent = "CreateTimelineEvent"

// CreateTimelineEventRequest generates a "aws/request.Request" representing the
// client's request for the CreateTimelineEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTimelineEvent for more information on using the CreateTimelineEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTimelineEventRequest method.
//	req, resp := client.CreateTimelineEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateTimelineEvent
func (c *SSMIncidents) CreateTimelineEventRequest(input *CreateTimelineEventInput) (req *request.Request, output *CreateTimelineEventOutput) {
	op := &request.Operation{
		Name:       opCreateTimelineEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/createTimelineEvent",
	}

	if input == nil {
		input = &CreateTimelineEventInput{}
	}

	output = &CreateTimelineEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTimelineEvent API operation for AWS Systems Manager Incident Manager.
//
// Creates a custom timeline event on the incident details page of an incident
// record. Incident Manager automatically creates timeline events that mark
// key moments during an incident. You can create custom timeline events to
// mark important events that Incident Manager can detect automatically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation CreateTimelineEvent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateTimelineEvent
func (c *SSMIncidents) CreateTimelineEvent(input *CreateTimelineEventInput) (*CreateTimelineEventOutput, error) {
	req, out := c.CreateTimelineEventRequest(input)
	return out, req.Send()
}

// CreateTimelineEventWithContext is the same as CreateTimelineEvent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTimelineEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) CreateTimelineEventWithContext(ctx aws.Context, input *CreateTimelineEventInput, opts ...request.Option) (*CreateTimelineEventOutput, error) {
	req, out := c.CreateTimelineEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIncidentRecord = "DeleteIncidentRecord"

// DeleteIncidentRecordRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIncidentRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIncidentRecord for more information on using the DeleteIncidentRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIncidentRecordRequest method.
//	req, resp := client.DeleteIncidentRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteIncidentRecord
func (c *SSMIncidents) DeleteIncidentRecordRequest(input *DeleteIncidentRecordInput) (req *request.Request, output *DeleteIncidentRecordOutput) {
	op := &request.Operation{
		Name:       opDeleteIncidentRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteIncidentRecord",
	}

	if input == nil {
		input = &DeleteIncidentRecordInput{}
	}

	output = &DeleteIncidentRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIncidentRecord API operation for AWS Systems Manager Incident Manager.
//
// Delete an incident record from Incident Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation DeleteIncidentRecord for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteIncidentRecord
func (c *SSMIncidents) DeleteIncidentRecord(input *DeleteIncidentRecordInput) (*DeleteIncidentRecordOutput, error) {
	req, out := c.DeleteIncidentRecordRequest(input)
	return out, req.Send()
}

// DeleteIncidentRecordWithContext is the same as DeleteIncidentRecord with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIncidentRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) DeleteIncidentRecordWithContext(ctx aws.Context, input *DeleteIncidentRecordInput, opts ...request.Option) (*DeleteIncidentRecordOutput, error) {
	req, out := c.DeleteIncidentRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationSet = "DeleteReplicationSet"

// DeleteReplicationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationSet for more information on using the DeleteReplicationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationSetRequest method.
//	req, resp := client.DeleteReplicationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteReplicationSet
func (c *SSMIncidents) DeleteReplicationSetRequest(input *DeleteReplicationSetInput) (req *request.Request, output *DeleteReplicationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteReplicationSet",
	}

	if input == nil {
		input = &DeleteReplicationSetInput{}
	}

	output = &DeleteReplicationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationSet API operation for AWS Systems Manager Incident Manager.
//
// Deletes all Regions in your replication set. Deleting the replication set
// deletes all Incident Manager data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation DeleteReplicationSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteReplicationSet
func (c *SSMIncidents) DeleteReplicationSet(input *DeleteReplicationSetInput) (*DeleteReplicationSetOutput, error) {
	req, out := c.DeleteReplicationSetRequest(input)
	return out, req.Send()
}

// DeleteReplicationSetWithContext is the same as DeleteReplicationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) DeleteReplicationSetWithContext(ctx aws.Context, input *DeleteReplicationSetInput, opts ...request.Option) (*DeleteReplicationSetOutput, error) {
	req, out := c.DeleteReplicationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResourcePolicy
func (c *SSMIncidents) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteResourcePolicy",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for AWS Systems Manager Incident Manager.
//
// Deletes the resource policy that Resource Access Manager uses to share your
// Incident Manager resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResourcePolicy
func (c *SSMIncidents) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResponsePlan = "DeleteResponsePlan"

// DeleteResponsePlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResponsePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResponsePlan for more information on using the DeleteResponsePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResponsePlanRequest method.
//	req, resp := client.DeleteResponsePlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResponsePlan
func (c *SSMIncidents) DeleteResponsePlanRequest(input *DeleteResponsePlanInput) (req *request.Request, output *DeleteResponsePlanOutput) {
	op := &request.Operation{
		Name:       opDeleteResponsePlan,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteResponsePlan",
	}

	if input == nil {
		input = &DeleteResponsePlanInput{}
	}

	output = &DeleteResponsePlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResponsePlan API operation for AWS Systems Manager Incident Manager.
//
// Deletes the specified response plan. Deleting a response plan stops all linked
// CloudWatch alarms and EventBridge events from creating an incident with this
// response plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation DeleteResponsePlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResponsePlan
func (c *SSMIncidents) DeleteResponsePlan(input *DeleteResponsePlanInput) (*DeleteResponsePlanOutput, error) {
	req, out := c.DeleteResponsePlanRequest(input)
	return out, req.Send()
}

// DeleteResponsePlanWithContext is the same as DeleteResponsePlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResponsePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) DeleteResponsePlanWithContext(ctx aws.Context, input *DeleteResponsePlanInput, opts ...request.Option) (*DeleteResponsePlanOutput, error) {
	req, out := c.DeleteResponsePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTimelineEvent = "DeleteTimelineEvent"

// DeleteTimelineEventRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTimelineEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTimelineEvent for more information on using the DeleteTimelineEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTimelineEventRequest method.
//	req, resp := client.DeleteTimelineEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteTimelineEvent
func (c *SSMIncidents) DeleteTimelineEventRequest(input *DeleteTimelineEventInput) (req *request.Request, output *DeleteTimelineEventOutput) {
	op := &request.Operation{
		Name:       opDeleteTimelineEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteTimelineEvent",
	}

	if input == nil {
		input = &DeleteTimelineEventInput{}
	}

	output = &DeleteTimelineEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTimelineEvent API operation for AWS Systems Manager Incident Manager.
//
// Deletes a timeline event from an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation DeleteTimelineEvent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteTimelineEvent
func (c *SSMIncidents) DeleteTimelineEvent(input *DeleteTimelineEventInput) (*DeleteTimelineEventOutput, error) {
	req, out := c.DeleteTimelineEventRequest(input)
	return out, req.Send()
}

// DeleteTimelineEventWithContext is the same as DeleteTimelineEvent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTimelineEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) DeleteTimelineEventWithContext(ctx aws.Context, input *DeleteTimelineEventInput, opts ...request.Option) (*DeleteTimelineEventOutput, error) {
	req, out := c.DeleteTimelineEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIncidentRecord = "GetIncidentRecord"

// GetIncidentRecordRequest generates a "aws/request.Request" representing the
// client's request for the GetIncidentRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIncidentRecord for more information on using the GetIncidentRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIncidentRecordRequest method.
//	req, resp := client.GetIncidentRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetIncidentRecord
func (c *SSMIncidents) GetIncidentRecordRequest(input *GetIncidentRecordInput) (req *request.Request, output *GetIncidentRecordOutput) {
	op := &request.Operation{
		Name:       opGetIncidentRecord,
		HTTPMethod: "GET",
		HTTPPath:   "/getIncidentRecord",
	}

	if input == nil {
		input = &GetIncidentRecordInput{}
	}

	output = &GetIncidentRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIncidentRecord API operation for AWS Systems Manager Incident Manager.
//
// Returns the details for the specified incident record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation GetIncidentRecord for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetIncidentRecord
func (c *SSMIncidents) GetIncidentRecord(input *GetIncidentRecordInput) (*GetIncidentRecordOutput, error) {
	req, out := c.GetIncidentRecordRequest(input)
	return out, req.Send()
}

// GetIncidentRecordWithContext is the same as GetIncidentRecord with the addition of
// the ability to pass a context and additional request options.
//
// See GetIncidentRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetIncidentRecordWithContext(ctx aws.Context, input *GetIncidentRecordInput, opts ...request.Option) (*GetIncidentRecordOutput, error) {
	req, out := c.GetIncidentRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReplicationSet = "GetReplicationSet"

// GetReplicationSetRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReplicationSet for more information on using the GetReplicationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReplicationSetRequest method.
//	req, resp := client.GetReplicationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetReplicationSet
func (c *SSMIncidents) GetReplicationSetRequest(input *GetReplicationSetInput) (req *request.Request, output *GetReplicationSetOutput) {
	op := &request.Operation{
		Name:       opGetReplicationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/getReplicationSet",
	}

	if input == nil {
		input = &GetReplicationSetInput{}
	}

	output = &GetReplicationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationSet API operation for AWS Systems Manager Incident Manager.
//
// Retrieve your Incident Manager replication set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation GetReplicationSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetReplicationSet
func (c *SSMIncidents) GetReplicationSet(input *GetReplicationSetInput) (*GetReplicationSetOutput, error) {
	req, out := c.GetReplicationSetRequest(input)
	return out, req.Send()
}

// GetReplicationSetWithContext is the same as GetReplicationSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetReplicationSetWithContext(ctx aws.Context, input *GetReplicationSetInput, opts ...request.Option) (*GetReplicationSetOutput, error) {
	req, out := c.GetReplicationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicies = "GetResourcePolicies"

// GetResourcePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicies for more information on using the GetResourcePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePoliciesRequest method.
//	req, resp := client.GetResourcePoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies
func (c *SSMIncidents) GetResourcePoliciesRequest(input *GetResourcePoliciesInput) (req *request.Request, output *GetResourcePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/getResourcePolicies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcePoliciesInput{}
	}

	output = &GetResourcePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicies API operation for AWS Systems Manager Incident Manager.
//
// Retrieves the resource policies attached to the specified response plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation GetResourcePolicies for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies
func (c *SSMIncidents) GetResourcePolicies(input *GetResourcePoliciesInput) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	return out, req.Send()
}

// GetResourcePoliciesWithContext is the same as GetResourcePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetResourcePoliciesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, opts ...request.Option) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcePoliciesPages iterates over the pages of a GetResourcePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourcePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourcePolicies operation.
//	pageNum := 0
//	err := client.GetResourcePoliciesPages(params,
//	    func(page *ssmincidents.GetResourcePoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) GetResourcePoliciesPages(input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool) error {
	return c.GetResourcePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcePoliciesPagesWithContext same as GetResourcePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetResourcePoliciesPagesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResponsePlan = "GetResponsePlan"

// GetResponsePlanRequest generates a "aws/request.Request" representing the
// client's request for the GetResponsePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResponsePlan for more information on using the GetResponsePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResponsePlanRequest method.
//	req, resp := client.GetResponsePlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResponsePlan
func (c *SSMIncidents) GetResponsePlanRequest(input *GetResponsePlanInput) (req *request.Request, output *GetResponsePlanOutput) {
	op := &request.Operation{
		Name:       opGetResponsePlan,
		HTTPMethod: "GET",
		HTTPPath:   "/getResponsePlan",
	}

	if input == nil {
		input = &GetResponsePlanInput{}
	}

	output = &GetResponsePlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResponsePlan API operation for AWS Systems Manager Incident Manager.
//
// Retrieves the details of the specified response plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation GetResponsePlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResponsePlan
func (c *SSMIncidents) GetResponsePlan(input *GetResponsePlanInput) (*GetResponsePlanOutput, error) {
	req, out := c.GetResponsePlanRequest(input)
	return out, req.Send()
}

// GetResponsePlanWithContext is the same as GetResponsePlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetResponsePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetResponsePlanWithContext(ctx aws.Context, input *GetResponsePlanInput, opts ...request.Option) (*GetResponsePlanOutput, error) {
	req, out := c.GetResponsePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTimelineEvent = "GetTimelineEvent"

// GetTimelineEventRequest generates a "aws/request.Request" representing the
// client's request for the GetTimelineEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTimelineEvent for more information on using the GetTimelineEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTimelineEventRequest method.
//	req, resp := client.GetTimelineEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetTimelineEvent
func (c *SSMIncidents) GetTimelineEventRequest(input *GetTimelineEventInput) (req *request.Request, output *GetTimelineEventOutput) {
	op := &request.Operation{
		Name:       opGetTimelineEvent,
		HTTPMethod: "GET",
		HTTPPath:   "/getTimelineEvent",
	}

	if input == nil {
		input = &GetTimelineEventInput{}
	}

	output = &GetTimelineEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTimelineEvent API operation for AWS Systems Manager Incident Manager.
//
// Retrieves a timeline event based on its ID and incident record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation GetTimelineEvent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetTimelineEvent
func (c *SSMIncidents) GetTimelineEvent(input *GetTimelineEventInput) (*GetTimelineEventOutput, error) {
	req, out := c.GetTimelineEventRequest(input)
	return out, req.Send()
}

// GetTimelineEventWithContext is the same as GetTimelineEvent with the addition of
// the ability to pass a context and additional request options.
//
// See GetTimelineEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) GetTimelineEventWithContext(ctx aws.Context, input *GetTimelineEventInput, opts ...request.Option) (*GetTimelineEventOutput, error) {
	req, out := c.GetTimelineEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIncidentFindings = "ListIncidentFindings"

// ListIncidentFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListIncidentFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIncidentFindings for more information on using the ListIncidentFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIncidentFindingsRequest method.
//	req, resp := client.ListIncidentFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentFindings
func (c *SSMIncidents) ListIncidentFindingsRequest(input *ListIncidentFindingsInput) (req *request.Request, output *ListIncidentFindingsOutput) {
	op := &request.Operation{
		Name:       opListIncidentFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/listIncidentFindings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIncidentFindingsInput{}
	}

	output = &ListIncidentFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIncidentFindings API operation for AWS Systems Manager Incident Manager.
//
// Retrieves a list of the IDs of findings, plus their last modified times,
// that have been identified for a specified incident. A finding represents
// a recent application environment change made by an CloudFormation stack creation
// or update or an CodeDeploy deployment that can be investigated as a potential
// cause of the incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListIncidentFindings for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentFindings
func (c *SSMIncidents) ListIncidentFindings(input *ListIncidentFindingsInput) (*ListIncidentFindingsOutput, error) {
	req, out := c.ListIncidentFindingsRequest(input)
	return out, req.Send()
}

// ListIncidentFindingsWithContext is the same as ListIncidentFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListIncidentFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListIncidentFindingsWithContext(ctx aws.Context, input *ListIncidentFindingsInput, opts ...request.Option) (*ListIncidentFindingsOutput, error) {
	req, out := c.ListIncidentFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIncidentFindingsPages iterates over the pages of a ListIncidentFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIncidentFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIncidentFindings operation.
//	pageNum := 0
//	err := client.ListIncidentFindingsPages(params,
//	    func(page *ssmincidents.ListIncidentFindingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListIncidentFindingsPages(input *ListIncidentFindingsInput, fn func(*ListIncidentFindingsOutput, bool) bool) error {
	return c.ListIncidentFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIncidentFindingsPagesWithContext same as ListIncidentFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListIncidentFindingsPagesWithContext(ctx aws.Context, input *ListIncidentFindingsInput, fn func(*ListIncidentFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIncidentFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIncidentFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIncidentFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIncidentRecords = "ListIncidentRecords"

// ListIncidentRecordsRequest generates a "aws/request.Request" representing the
// client's request for the ListIncidentRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIncidentRecords for more information on using the ListIncidentRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIncidentRecordsRequest method.
//	req, resp := client.ListIncidentRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords
func (c *SSMIncidents) ListIncidentRecordsRequest(input *ListIncidentRecordsInput) (req *request.Request, output *ListIncidentRecordsOutput) {
	op := &request.Operation{
		Name:       opListIncidentRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/listIncidentRecords",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIncidentRecordsInput{}
	}

	output = &ListIncidentRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIncidentRecords API operation for AWS Systems Manager Incident Manager.
//
// Lists all incident records in your account. Use this command to retrieve
// the Amazon Resource Name (ARN) of the incident record you want to update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListIncidentRecords for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords
func (c *SSMIncidents) ListIncidentRecords(input *ListIncidentRecordsInput) (*ListIncidentRecordsOutput, error) {
	req, out := c.ListIncidentRecordsRequest(input)
	return out, req.Send()
}

// ListIncidentRecordsWithContext is the same as ListIncidentRecords with the addition of
// the ability to pass a context and additional request options.
//
// See ListIncidentRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListIncidentRecordsWithContext(ctx aws.Context, input *ListIncidentRecordsInput, opts ...request.Option) (*ListIncidentRecordsOutput, error) {
	req, out := c.ListIncidentRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIncidentRecordsPages iterates over the pages of a ListIncidentRecords operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIncidentRecords method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIncidentRecords operation.
//	pageNum := 0
//	err := client.ListIncidentRecordsPages(params,
//	    func(page *ssmincidents.ListIncidentRecordsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListIncidentRecordsPages(input *ListIncidentRecordsInput, fn func(*ListIncidentRecordsOutput, bool) bool) error {
	return c.ListIncidentRecordsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIncidentRecordsPagesWithContext same as ListIncidentRecordsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListIncidentRecordsPagesWithContext(ctx aws.Context, input *ListIncidentRecordsInput, fn func(*ListIncidentRecordsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIncidentRecordsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIncidentRecordsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIncidentRecordsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRelatedItems = "ListRelatedItems"

// ListRelatedItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListRelatedItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRelatedItems for more information on using the ListRelatedItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRelatedItemsRequest method.
//	req, resp := client.ListRelatedItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems
func (c *SSMIncidents) ListRelatedItemsRequest(input *ListRelatedItemsInput) (req *request.Request, output *ListRelatedItemsOutput) {
	op := &request.Operation{
		Name:       opListRelatedItems,
		HTTPMethod: "POST",
		HTTPPath:   "/listRelatedItems",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRelatedItemsInput{}
	}

	output = &ListRelatedItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRelatedItems API operation for AWS Systems Manager Incident Manager.
//
// List all related items for an incident record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListRelatedItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems
func (c *SSMIncidents) ListRelatedItems(input *ListRelatedItemsInput) (*ListRelatedItemsOutput, error) {
	req, out := c.ListRelatedItemsRequest(input)
	return out, req.Send()
}

// ListRelatedItemsWithContext is the same as ListRelatedItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListRelatedItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListRelatedItemsWithContext(ctx aws.Context, input *ListRelatedItemsInput, opts ...request.Option) (*ListRelatedItemsOutput, error) {
	req, out := c.ListRelatedItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRelatedItemsPages iterates over the pages of a ListRelatedItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRelatedItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRelatedItems operation.
//	pageNum := 0
//	err := client.ListRelatedItemsPages(params,
//	    func(page *ssmincidents.ListRelatedItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListRelatedItemsPages(input *ListRelatedItemsInput, fn func(*ListRelatedItemsOutput, bool) bool) error {
	return c.ListRelatedItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRelatedItemsPagesWithContext same as ListRelatedItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListRelatedItemsPagesWithContext(ctx aws.Context, input *ListRelatedItemsInput, fn func(*ListRelatedItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRelatedItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRelatedItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRelatedItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReplicationSets = "ListReplicationSets"

// ListReplicationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReplicationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReplicationSets for more information on using the ListReplicationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReplicationSetsRequest method.
//	req, resp := client.ListReplicationSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets
func (c *SSMIncidents) ListReplicationSetsRequest(input *ListReplicationSetsInput) (req *request.Request, output *ListReplicationSetsOutput) {
	op := &request.Operation{
		Name:       opListReplicationSets,
		HTTPMethod: "POST",
		HTTPPath:   "/listReplicationSets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReplicationSetsInput{}
	}

	output = &ListReplicationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReplicationSets API operation for AWS Systems Manager Incident Manager.
//
// Lists details about the replication set configured in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListReplicationSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets
func (c *SSMIncidents) ListReplicationSets(input *ListReplicationSetsInput) (*ListReplicationSetsOutput, error) {
	req, out := c.ListReplicationSetsRequest(input)
	return out, req.Send()
}

// ListReplicationSetsWithContext is the same as ListReplicationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListReplicationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListReplicationSetsWithContext(ctx aws.Context, input *ListReplicationSetsInput, opts ...request.Option) (*ListReplicationSetsOutput, error) {
	req, out := c.ListReplicationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReplicationSetsPages iterates over the pages of a ListReplicationSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReplicationSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReplicationSets operation.
//	pageNum := 0
//	err := client.ListReplicationSetsPages(params,
//	    func(page *ssmincidents.ListReplicationSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListReplicationSetsPages(input *ListReplicationSetsInput, fn func(*ListReplicationSetsOutput, bool) bool) error {
	return c.ListReplicationSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReplicationSetsPagesWithContext same as ListReplicationSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListReplicationSetsPagesWithContext(ctx aws.Context, input *ListReplicationSetsInput, fn func(*ListReplicationSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReplicationSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReplicationSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReplicationSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResponsePlans = "ListResponsePlans"

// ListResponsePlansRequest generates a "aws/request.Request" representing the
// client's request for the ListResponsePlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResponsePlans for more information on using the ListResponsePlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResponsePlansRequest method.
//	req, resp := client.ListResponsePlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans
func (c *SSMIncidents) ListResponsePlansRequest(input *ListResponsePlansInput) (req *request.Request, output *ListResponsePlansOutput) {
	op := &request.Operation{
		Name:       opListResponsePlans,
		HTTPMethod: "POST",
		HTTPPath:   "/listResponsePlans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResponsePlansInput{}
	}

	output = &ListResponsePlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResponsePlans API operation for AWS Systems Manager Incident Manager.
//
// Lists all response plans in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListResponsePlans for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans
func (c *SSMIncidents) ListResponsePlans(input *ListResponsePlansInput) (*ListResponsePlansOutput, error) {
	req, out := c.ListResponsePlansRequest(input)
	return out, req.Send()
}

// ListResponsePlansWithContext is the same as ListResponsePlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListResponsePlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListResponsePlansWithContext(ctx aws.Context, input *ListResponsePlansInput, opts ...request.Option) (*ListResponsePlansOutput, error) {
	req, out := c.ListResponsePlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResponsePlansPages iterates over the pages of a ListResponsePlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResponsePlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResponsePlans operation.
//	pageNum := 0
//	err := client.ListResponsePlansPages(params,
//	    func(page *ssmincidents.ListResponsePlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListResponsePlansPages(input *ListResponsePlansInput, fn func(*ListResponsePlansOutput, bool) bool) error {
	return c.ListResponsePlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResponsePlansPagesWithContext same as ListResponsePlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListResponsePlansPagesWithContext(ctx aws.Context, input *ListResponsePlansInput, fn func(*ListResponsePlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResponsePlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResponsePlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResponsePlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTagsForResource
func (c *SSMIncidents) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Systems Manager Incident Manager.
//
// Lists the tags that are attached to the specified response plan or incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTagsForResource
func (c *SSMIncidents) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTimelineEvents = "ListTimelineEvents"

// ListTimelineEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListTimelineEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTimelineEvents for more information on using the ListTimelineEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTimelineEventsRequest method.
//	req, resp := client.ListTimelineEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents
func (c *SSMIncidents) ListTimelineEventsRequest(input *ListTimelineEventsInput) (req *request.Request, output *ListTimelineEventsOutput) {
	op := &request.Operation{
		Name:       opListTimelineEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/listTimelineEvents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTimelineEventsInput{}
	}

	output = &ListTimelineEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTimelineEvents API operation for AWS Systems Manager Incident Manager.
//
// Lists timeline events for the specified incident record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation ListTimelineEvents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents
func (c *SSMIncidents) ListTimelineEvents(input *ListTimelineEventsInput) (*ListTimelineEventsOutput, error) {
	req, out := c.ListTimelineEventsRequest(input)
	return out, req.Send()
}

// ListTimelineEventsWithContext is the same as ListTimelineEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListTimelineEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListTimelineEventsWithContext(ctx aws.Context, input *ListTimelineEventsInput, opts ...request.Option) (*ListTimelineEventsOutput, error) {
	req, out := c.ListTimelineEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTimelineEventsPages iterates over the pages of a ListTimelineEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTimelineEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTimelineEvents operation.
//	pageNum := 0
//	err := client.ListTimelineEventsPages(params,
//	    func(page *ssmincidents.ListTimelineEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMIncidents) ListTimelineEventsPages(input *ListTimelineEventsInput, fn func(*ListTimelineEventsOutput, bool) bool) error {
	return c.ListTimelineEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTimelineEventsPagesWithContext same as ListTimelineEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) ListTimelineEventsPagesWithContext(ctx aws.Context, input *ListTimelineEventsInput, fn func(*ListTimelineEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTimelineEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTimelineEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTimelineEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/PutResourcePolicy
func (c *SSMIncidents) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/putResourcePolicy",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for AWS Systems Manager Incident Manager.
//
// Adds a resource policy to the specified response plan. The resource policy
// is used to share the response plan using Resource Access Manager (RAM). For
// more information about cross-account sharing, see Cross-Region and cross-account
// incident management (https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/PutResourcePolicy
func (c *SSMIncidents) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartIncident = "StartIncident"

// StartIncidentRequest generates a "aws/request.Request" representing the
// client's request for the StartIncident operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartIncident for more information on using the StartIncident
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartIncidentRequest method.
//	req, resp := client.StartIncidentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/StartIncident
func (c *SSMIncidents) StartIncidentRequest(input *StartIncidentInput) (req *request.Request, output *StartIncidentOutput) {
	op := &request.Operation{
		Name:       opStartIncident,
		HTTPMethod: "POST",
		HTTPPath:   "/startIncident",
	}

	if input == nil {
		input = &StartIncidentInput{}
	}

	output = &StartIncidentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartIncident API operation for AWS Systems Manager Incident Manager.
//
// Used to start an incident from CloudWatch alarms, EventBridge events, or
// manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation StartIncident for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/StartIncident
func (c *SSMIncidents) StartIncident(input *StartIncidentInput) (*StartIncidentOutput, error) {
	req, out := c.StartIncidentRequest(input)
	return out, req.Send()
}

// StartIncidentWithContext is the same as StartIncident with the addition of
// the ability to pass a context and additional request options.
//
// See StartIncident for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) StartIncidentWithContext(ctx aws.Context, input *StartIncidentInput, opts ...request.Option) (*StartIncidentOutput, error) {
	req, out := c.StartIncidentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/TagResource
func (c *SSMIncidents) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Systems Manager Incident Manager.
//
// Adds a tag to a response plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/TagResource
func (c *SSMIncidents) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UntagResource
func (c *SSMIncidents) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Systems Manager Incident Manager.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UntagResource
func (c *SSMIncidents) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeletionProtection = "UpdateDeletionProtection"

// UpdateDeletionProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeletionProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeletionProtection for more information on using the UpdateDeletionProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDeletionProtectionRequest method.
//	req, resp := client.UpdateDeletionProtectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateDeletionProtection
func (c *SSMIncidents) UpdateDeletionProtectionRequest(input *UpdateDeletionProtectionInput) (req *request.Request, output *UpdateDeletionProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateDeletionProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/updateDeletionProtection",
	}

	if input == nil {
		input = &UpdateDeletionProtectionInput{}
	}

	output = &UpdateDeletionProtectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDeletionProtection API operation for AWS Systems Manager Incident Manager.
//
// Update deletion protection to either allow or deny deletion of the final
// Region in a replication set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateDeletionProtection for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateDeletionProtection
func (c *SSMIncidents) UpdateDeletionProtection(input *UpdateDeletionProtectionInput) (*UpdateDeletionProtectionOutput, error) {
	req, out := c.UpdateDeletionProtectionRequest(input)
	return out, req.Send()
}

// UpdateDeletionProtectionWithContext is the same as UpdateDeletionProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeletionProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateDeletionProtectionWithContext(ctx aws.Context, input *UpdateDeletionProtectionInput, opts ...request.Option) (*UpdateDeletionProtectionOutput, error) {
	req, out := c.UpdateDeletionProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIncidentRecord = "UpdateIncidentRecord"

// UpdateIncidentRecordRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIncidentRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIncidentRecord for more information on using the UpdateIncidentRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIncidentRecordRequest method.
//	req, resp := client.UpdateIncidentRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateIncidentRecord
func (c *SSMIncidents) UpdateIncidentRecordRequest(input *UpdateIncidentRecordInput) (req *request.Request, output *UpdateIncidentRecordOutput) {
	op := &request.Operation{
		Name:       opUpdateIncidentRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/updateIncidentRecord",
	}

	if input == nil {
		input = &UpdateIncidentRecordInput{}
	}

	output = &UpdateIncidentRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIncidentRecord API operation for AWS Systems Manager Incident Manager.
//
// Update the details of an incident record. You can use this operation to update
// an incident record from the defined chat channel. For more information about
// using actions in chat channels, see Interacting through chat (https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateIncidentRecord for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateIncidentRecord
func (c *SSMIncidents) UpdateIncidentRecord(input *UpdateIncidentRecordInput) (*UpdateIncidentRecordOutput, error) {
	req, out := c.UpdateIncidentRecordRequest(input)
	return out, req.Send()
}

// UpdateIncidentRecordWithContext is the same as UpdateIncidentRecord with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIncidentRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateIncidentRecordWithContext(ctx aws.Context, input *UpdateIncidentRecordInput, opts ...request.Option) (*UpdateIncidentRecordOutput, error) {
	req, out := c.UpdateIncidentRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelatedItems = "UpdateRelatedItems"

// UpdateRelatedItemsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelatedItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelatedItems for more information on using the UpdateRelatedItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRelatedItemsRequest method.
//	req, resp := client.UpdateRelatedItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateRelatedItems
func (c *SSMIncidents) UpdateRelatedItemsRequest(input *UpdateRelatedItemsInput) (req *request.Request, output *UpdateRelatedItemsOutput) {
	op := &request.Operation{
		Name:       opUpdateRelatedItems,
		HTTPMethod: "POST",
		HTTPPath:   "/updateRelatedItems",
	}

	if input == nil {
		input = &UpdateRelatedItemsInput{}
	}

	output = &UpdateRelatedItemsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRelatedItems API operation for AWS Systems Manager Incident Manager.
//
// Add or remove related items from the related items tab of an incident record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateRelatedItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateRelatedItems
func (c *SSMIncidents) UpdateRelatedItems(input *UpdateRelatedItemsInput) (*UpdateRelatedItemsOutput, error) {
	req, out := c.UpdateRelatedItemsRequest(input)
	return out, req.Send()
}

// UpdateRelatedItemsWithContext is the same as UpdateRelatedItems with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelatedItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateRelatedItemsWithContext(ctx aws.Context, input *UpdateRelatedItemsInput, opts ...request.Option) (*UpdateRelatedItemsOutput, error) {
	req, out := c.UpdateRelatedItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationSet = "UpdateReplicationSet"

// UpdateReplicationSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationSet for more information on using the UpdateReplicationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReplicationSetRequest method.
//	req, resp := client.UpdateReplicationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateReplicationSet
func (c *SSMIncidents) UpdateReplicationSetRequest(input *UpdateReplicationSetInput) (req *request.Request, output *UpdateReplicationSetOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/updateReplicationSet",
	}

	if input == nil {
		input = &UpdateReplicationSetInput{}
	}

	output = &UpdateReplicationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateReplicationSet API operation for AWS Systems Manager Incident Manager.
//
// Add or delete Regions from your replication set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateReplicationSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateReplicationSet
func (c *SSMIncidents) UpdateReplicationSet(input *UpdateReplicationSetInput) (*UpdateReplicationSetOutput, error) {
	req, out := c.UpdateReplicationSetRequest(input)
	return out, req.Send()
}

// UpdateReplicationSetWithContext is the same as UpdateReplicationSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateReplicationSetWithContext(ctx aws.Context, input *UpdateReplicationSetInput, opts ...request.Option) (*UpdateReplicationSetOutput, error) {
	req, out := c.UpdateReplicationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResponsePlan = "UpdateResponsePlan"

// UpdateResponsePlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResponsePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResponsePlan for more information on using the UpdateResponsePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResponsePlanRequest method.
//	req, resp := client.UpdateResponsePlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateResponsePlan
func (c *SSMIncidents) UpdateResponsePlanRequest(input *UpdateResponsePlanInput) (req *request.Request, output *UpdateResponsePlanOutput) {
	op := &request.Operation{
		Name:       opUpdateResponsePlan,
		HTTPMethod: "POST",
		HTTPPath:   "/updateResponsePlan",
	}

	if input == nil {
		input = &UpdateResponsePlanInput{}
	}

	output = &UpdateResponsePlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResponsePlan API operation for AWS Systems Manager Incident Manager.
//
// Updates the specified response plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateResponsePlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateResponsePlan
func (c *SSMIncidents) UpdateResponsePlan(input *UpdateResponsePlanInput) (*UpdateResponsePlanOutput, error) {
	req, out := c.UpdateResponsePlanRequest(input)
	return out, req.Send()
}

// UpdateResponsePlanWithContext is the same as UpdateResponsePlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResponsePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateResponsePlanWithContext(ctx aws.Context, input *UpdateResponsePlanInput, opts ...request.Option) (*UpdateResponsePlanOutput, error) {
	req, out := c.UpdateResponsePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTimelineEvent = "UpdateTimelineEvent"

// UpdateTimelineEventRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTimelineEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTimelineEvent for more information on using the UpdateTimelineEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTimelineEventRequest method.
//	req, resp := client.UpdateTimelineEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateTimelineEvent
func (c *SSMIncidents) UpdateTimelineEventRequest(input *UpdateTimelineEventInput) (req *request.Request, output *UpdateTimelineEventOutput) {
	op := &request.Operation{
		Name:       opUpdateTimelineEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/updateTimelineEvent",
	}

	if input == nil {
		input = &UpdateTimelineEventInput{}
	}

	output = &UpdateTimelineEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTimelineEvent API operation for AWS Systems Manager Incident Manager.
//
// Updates a timeline event. You can update events of type Custom Event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager's
// API operation UpdateTimelineEvent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which doesn't exist.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateTimelineEvent
func (c *SSMIncidents) UpdateTimelineEvent(input *UpdateTimelineEventInput) (*UpdateTimelineEventOutput, error) {
	req, out := c.UpdateTimelineEventRequest(input)
	return out, req.Send()
}

// UpdateTimelineEventWithContext is the same as UpdateTimelineEvent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTimelineEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMIncidents) UpdateTimelineEventWithContext(ctx aws.Context, input *UpdateTimelineEventInput, opts ...request.Option) (*UpdateTimelineEventOutput, error) {
	req, out := c.UpdateTimelineEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient access to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action that starts at the beginning of an incident. The response plan
// defines the action.
type Action struct {
	_ struct{} `type:"structure"`

	// The Systems Manager automation document to start as the runbook at the beginning
	// of the incident.
	SsmAutomation *SsmAutomation `locationName:"ssmAutomation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.SsmAutomation != nil {
		if err := s.SsmAutomation.Validate(); err != nil {
			invalidParams.AddNested("SsmAutomation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSsmAutomation sets the SsmAutomation field's value.
func (s *Action) SetSsmAutomation(v *SsmAutomation) *Action {
	s.SsmAutomation = v
	return s
}

// Defines the Amazon Web Services Region and KMS key to add to the replication
// set.
type AddRegionAction struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Region name to add to the replication set.
	//
	// RegionName is a required field
	RegionName *string `locationName:"regionName" type:"string" required:"true"`

	// The KMS key ID to use to encrypt your replication set.
	SseKmsKeyId *string `locationName:"sseKmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddRegionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddRegionAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRegionAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRegionAction"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *AddRegionAction) SetRegionName(v string) *AddRegionAction {
	s.RegionName = &v
	return s
}

// SetSseKmsKeyId sets the SseKmsKeyId field's value.
func (s *AddRegionAction) SetSseKmsKeyId(v string) *AddRegionAction {
	s.SseKmsKeyId = &v
	return s
}

// Use the AttributeValueList to filter by string or integer values.
type AttributeValueList struct {
	_ struct{} `type:"structure"`

	// The list of integer values that the filter matches.
	IntegerValues []*int64 `locationName:"integerValues" type:"list"`

	// The list of string values that the filter matches.
	StringValues []*string `locationName:"stringValues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValueList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValueList) GoString() string {
	return s.String()
}

// SetIntegerValues sets the IntegerValues field's value.
func (s *AttributeValueList) SetIntegerValues(v []*int64) *AttributeValueList {
	s.IntegerValues = v
	return s
}

// SetStringValues sets the StringValues field's value.
func (s *AttributeValueList) SetStringValues(v []*string) *AttributeValueList {
	s.StringValues = v
	return s
}

// The Systems Manager automation document process to start as the runbook at
// the beginning of the incident.
type AutomationExecution struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the automation process.
	SsmExecutionArn *string `locationName:"ssmExecutionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecution) GoString() string {
	return s.String()
}

// SetSsmExecutionArn sets the SsmExecutionArn field's value.
func (s *AutomationExecution) SetSsmExecutionArn(v string) *AutomationExecution {
	s.SsmExecutionArn = &v
	return s
}

// Details about an error returned for a BatchGetIncidentFindings operation.
type BatchGetIncidentFindingsError struct {
	_ struct{} `type:"structure"`

	// The code associated with an error that was returned for a BatchGetIncidentFindings
	// operation.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// The ID of a specified finding for which an error was returned for a BatchGetIncidentFindings
	// operation.
	//
	// FindingId is a required field
	FindingId *string `locationName:"findingId" type:"string" required:"true"`

	// The description for an error that was returned for a BatchGetIncidentFindings
	// operation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetIncidentFindingsError) SetCode(v string) *BatchGetIncidentFindingsError {
	s.Code = &v
	return s
}

// SetFindingId sets the FindingId field's value.
func (s *BatchGetIncidentFindingsError) SetFindingId(v string) *BatchGetIncidentFindingsError {
	s.FindingId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetIncidentFindingsError) SetMessage(v string) *BatchGetIncidentFindingsError {
	s.Message = &v
	return s
}

type BatchGetIncidentFindingsInput struct {
	_ struct{} `type:"structure"`

	// A list of IDs of findings for which you want to view details.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the incident for which you want to view
	// finding details.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetIncidentFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetIncidentFindingsInput"}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingIds sets the FindingIds field's value.
func (s *BatchGetIncidentFindingsInput) SetFindingIds(v []*string) *BatchGetIncidentFindingsInput {
	s.FindingIds = v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *BatchGetIncidentFindingsInput) SetIncidentRecordArn(v string) *BatchGetIncidentFindingsInput {
	s.IncidentRecordArn = &v
	return s
}

type BatchGetIncidentFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered during the operation.
	//
	// Errors is a required field
	Errors []*BatchGetIncidentFindingsError `locationName:"errors" type:"list" required:"true"`

	// Information about the requested findings.
	//
	// Findings is a required field
	Findings []*Finding `locationName:"findings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetIncidentFindingsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetIncidentFindingsOutput) SetErrors(v []*BatchGetIncidentFindingsError) *BatchGetIncidentFindingsOutput {
	s.Errors = v
	return s
}

// SetFindings sets the Findings field's value.
func (s *BatchGetIncidentFindingsOutput) SetFindings(v []*Finding) *BatchGetIncidentFindingsOutput {
	s.Findings = v
	return s
}

// The Chatbot chat channel used for collaboration during an incident.
type ChatChannel struct {
	_ struct{} `type:"structure"`

	// The Amazon SNS targets that Chatbot uses to notify the chat channel of updates
	// to an incident. You can also make updates to the incident through the chat
	// channel by using the Amazon SNS topics.
	ChatbotSns []*string `locationName:"chatbotSns" min:"1" type:"list"`

	// Used to remove the chat channel from an incident record or response plan.
	Empty *EmptyChatChannel `locationName:"empty" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatChannel"}
	if s.ChatbotSns != nil && len(s.ChatbotSns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChatbotSns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChatbotSns sets the ChatbotSns field's value.
func (s *ChatChannel) SetChatbotSns(v []*string) *ChatChannel {
	s.ChatbotSns = v
	return s
}

// SetEmpty sets the Empty field's value.
func (s *ChatChannel) SetEmpty(v *EmptyChatChannel) *ChatChannel {
	s.Empty = v
	return s
}

// Information about an CloudFormation stack creation or update that occurred
// around the time of an incident and could be a potential cause of the incident.
type CloudFormationStackUpdate struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the CloudFormation stack creation or update ended.
	// Not reported for deployments that are still in progress.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the CloudFormation stack involved in the
	// update.
	//
	// StackArn is a required field
	StackArn *string `locationName:"stackArn" type:"string" required:"true"`

	// The timestamp for when the CloudFormation stack creation or update began.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationStackUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationStackUpdate) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *CloudFormationStackUpdate) SetEndTime(v time.Time) *CloudFormationStackUpdate {
	s.EndTime = &v
	return s
}

// SetStackArn sets the StackArn field's value.
func (s *CloudFormationStackUpdate) SetStackArn(v string) *CloudFormationStackUpdate {
	s.StackArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CloudFormationStackUpdate) SetStartTime(v time.Time) *CloudFormationStackUpdate {
	s.StartTime = &v
	return s
}

// Information about a CodeDeploy deployment that occurred around the time of
// an incident and could be a possible cause of the incident.
type CodeDeployDeployment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CodeDeploy deployment group associated
	// with the deployment.
	//
	// DeploymentGroupArn is a required field
	DeploymentGroupArn *string `locationName:"deploymentGroupArn" type:"string" required:"true"`

	// The ID of the CodeDeploy deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The timestamp for when the CodeDeploy deployment ended. Not reported for
	// deployments that are still in progress.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The timestamp for when the CodeDeploy deployment began.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeployDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeployDeployment) GoString() string {
	return s.String()
}

// SetDeploymentGroupArn sets the DeploymentGroupArn field's value.
func (s *CodeDeployDeployment) SetDeploymentGroupArn(v string) *CodeDeployDeployment {
	s.DeploymentGroupArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CodeDeployDeployment) SetDeploymentId(v string) *CodeDeployDeployment {
	s.DeploymentId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CodeDeployDeployment) SetEndTime(v time.Time) *CodeDeployDeployment {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CodeDeployDeployment) SetStartTime(v time.Time) *CodeDeployDeployment {
	s.StartTime = &v
	return s
}

// A conditional statement with which to compare a value, after a timestamp,
// before a timestamp, or equal to a string or integer. If multiple conditions
// are specified, the conditionals become an ANDed statement. If multiple values
// are specified for a conditional, the values are ORd.
type Condition struct {
	_ struct{} `type:"structure"`

	// After the specified timestamp.
	After *time.Time `locationName:"after" type:"timestamp"`

	// Before the specified timestamp
	Before *time.Time `locationName:"before" type:"timestamp"`

	// The value is equal to the provided string or integer.
	Equals *AttributeValueList `locationName:"equals" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// SetAfter sets the After field's value.
func (s *Condition) SetAfter(v time.Time) *Condition {
	s.After = &v
	return s
}

// SetBefore sets the Before field's value.
func (s *Condition) SetBefore(v time.Time) *Condition {
	s.Before = &v
	return s
}

// SetEquals sets the Equals field's value.
func (s *Condition) SetEquals(v *AttributeValueList) *Condition {
	s.Equals = v
	return s
}

// Updating or deleting a resource causes an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the requested resource
	ResourceIdentifier *string `locationName:"resourceIdentifier" type:"string"`

	// The resource type
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// If present in the output, the operation can be retried after this time
	RetryAfter *time.Time `locationName:"retryAfter" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateReplicationSetInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The Regions that Incident Manager replicates your data to. You can have up
	// to three Regions in your replication set.
	//
	// Regions is a required field
	Regions map[string]*RegionMapInputValue `locationName:"regions" min:"1" type:"map" required:"true"`

	// A list of tags to add to the replication set.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationSetInput"}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateReplicationSetInput) SetClientToken(v string) *CreateReplicationSetInput {
	s.ClientToken = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateReplicationSetInput) SetRegions(v map[string]*RegionMapInputValue) *CreateReplicationSetInput {
	s.Regions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationSetInput) SetTags(v map[string]*string) *CreateReplicationSetInput {
	s.Tags = v
	return s
}

type CreateReplicationSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication set.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateReplicationSetOutput) SetArn(v string) *CreateReplicationSetOutput {
	s.Arn = &v
	return s
}

type CreateResponsePlanInput struct {
	_ struct{} `type:"structure"`

	// The actions that the response plan starts at the beginning of an incident.
	Actions []*Action `locationName:"actions" type:"list"`

	// The Chatbot chat channel used for collaboration during an incident.
	ChatChannel *ChatChannel `locationName:"chatChannel" type:"structure"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The long format of the response plan name. This field can contain spaces.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The Amazon Resource Name (ARN) for the contacts and escalation plans that
	// the response plan engages during an incident.
	Engagements []*string `locationName:"engagements" type:"list"`

	// Details used to create an incident when using this response plan.
	//
	// IncidentTemplate is a required field
	IncidentTemplate *IncidentTemplate `locationName:"incidentTemplate" type:"structure" required:"true"`

	// Information about third-party services integrated into the response plan.
	Integrations []*Integration `locationName:"integrations" type:"list"`

	// The short format name of the response plan. Can't include spaces.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of tags that you are adding to the response plan.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResponsePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResponsePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResponsePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResponsePlanInput"}
	if s.IncidentTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentTemplate"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChatChannel != nil {
		if err := s.ChatChannel.Validate(); err != nil {
			invalidParams.AddNested("ChatChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.IncidentTemplate != nil {
		if err := s.IncidentTemplate.Validate(); err != nil {
			invalidParams.AddNested("IncidentTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.Integrations != nil {
		for i, v := range s.Integrations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Integrations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateResponsePlanInput) SetActions(v []*Action) *CreateResponsePlanInput {
	s.Actions = v
	return s
}

// SetChatChannel sets the ChatChannel field's value.
func (s *CreateResponsePlanInput) SetChatChannel(v *ChatChannel) *CreateResponsePlanInput {
	s.ChatChannel = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResponsePlanInput) SetClientToken(v string) *CreateResponsePlanInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateResponsePlanInput) SetDisplayName(v string) *CreateResponsePlanInput {
	s.DisplayName = &v
	return s
}

// SetEngagements sets the Engagements field's value.
func (s *CreateResponsePlanInput) SetEngagements(v []*string) *CreateResponsePlanInput {
	s.Engagements = v
	return s
}

// SetIncidentTemplate sets the IncidentTemplate field's value.
func (s *CreateResponsePlanInput) SetIncidentTemplate(v *IncidentTemplate) *CreateResponsePlanInput {
	s.IncidentTemplate = v
	return s
}

// SetIntegrations sets the Integrations field's value.
func (s *CreateResponsePlanInput) SetIntegrations(v []*Integration) *CreateResponsePlanInput {
	s.Integrations = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResponsePlanInput) SetName(v string) *CreateResponsePlanInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResponsePlanInput) SetTags(v map[string]*string) *CreateResponsePlanInput {
	s.Tags = v
	return s
}

type CreateResponsePlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the response plan.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResponsePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResponsePlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateResponsePlanOutput) SetArn(v string) *CreateResponsePlanOutput {
	s.Arn = &v
	return s
}

type CreateTimelineEventInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures that a client calls the action only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A short description of the event.
	//
	// EventData is a required field
	EventData *string `locationName:"eventData" type:"string" required:"true"`

	// Adds one or more references to the TimelineEvent. A reference is an Amazon
	// Web Services resource involved or associated with the incident. To specify
	// a reference, enter its Amazon Resource Name (ARN). You can also specify a
	// related item associated with a resource. For example, to specify an Amazon
	// DynamoDB (DynamoDB) table as a resource, use the table's ARN. You can also
	// specify an Amazon CloudWatch metric associated with the DynamoDB table as
	// a related item.
	EventReferences []*EventReference `locationName:"eventReferences" type:"list"`

	// The timestamp for when the event occurred.
	//
	// EventTime is a required field
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" required:"true"`

	// The type of event. You can create timeline events of type Custom Event and
	// Note.
	//
	// To make a Note-type event appear on the Incident notes panel in the console,
	// specify eventType as Noteand enter the Amazon Resource Name (ARN) of the
	// incident as the value for eventReference.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the incident record that the action adds
	// the incident to.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTimelineEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTimelineEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTimelineEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTimelineEventInput"}
	if s.EventData == nil {
		invalidParams.Add(request.NewErrParamRequired("EventData"))
	}
	if s.EventTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTime"))
	}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTimelineEventInput) SetClientToken(v string) *CreateTimelineEventInput {
	s.ClientToken = &v
	return s
}

// SetEventData sets the EventData field's value.
func (s *CreateTimelineEventInput) SetEventData(v string) *CreateTimelineEventInput {
	s.EventData = &v
	return s
}

// SetEventReferences sets the EventReferences field's value.
func (s *CreateTimelineEventInput) SetEventReferences(v []*EventReference) *CreateTimelineEventInput {
	s.EventReferences = v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *CreateTimelineEventInput) SetEventTime(v time.Time) *CreateTimelineEventInput {
	s.EventTime = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateTimelineEventInput) SetEventType(v string) *CreateTimelineEventInput {
	s.EventType = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *CreateTimelineEventInput) SetIncidentRecordArn(v string) *CreateTimelineEventInput {
	s.IncidentRecordArn = &v
	return s
}

type CreateTimelineEventOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the event for easy reference later.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The ARN of the incident record that you added the event to.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTimelineEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTimelineEventOutput) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *CreateTimelineEventOutput) SetEventId(v string) *CreateTimelineEventOutput {
	s.EventId = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *CreateTimelineEventOutput) SetIncidentRecordArn(v string) *CreateTimelineEventOutput {
	s.IncidentRecordArn = &v
	return s
}

type DeleteIncidentRecordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident record you are deleting.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIncidentRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIncidentRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIncidentRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIncidentRecordInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteIncidentRecordInput) SetArn(v string) *DeleteIncidentRecordInput {
	s.Arn = &v
	return s
}

type DeleteIncidentRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIncidentRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIncidentRecordOutput) GoString() string {
	return s.String()
}

// Defines the information about the Amazon Web Services Region you're deleting
// from your replication set.
type DeleteRegionAction struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Web Services Region you're deleting from the replication
	// set.
	//
	// RegionName is a required field
	RegionName *string `locationName:"regionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRegionAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRegionAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRegionAction"}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegionName sets the RegionName field's value.
func (s *DeleteRegionAction) SetRegionName(v string) *DeleteRegionAction {
	s.RegionName = &v
	return s
}

type DeleteReplicationSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the replication set you're deleting.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationSetInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteReplicationSetInput) SetArn(v string) *DeleteReplicationSetInput {
	s.Arn = &v
	return s
}

type DeleteReplicationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationSetOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource policy you're deleting.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource you're deleting the policy
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeleteResourcePolicyInput) SetPolicyId(v string) *DeleteResourcePolicyInput {
	s.PolicyId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteResponsePlanInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the response plan.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResponsePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResponsePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResponsePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResponsePlanInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteResponsePlanInput) SetArn(v string) *DeleteResponsePlanInput {
	s.Arn = &v
	return s
}

type DeleteResponsePlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResponsePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResponsePlanOutput) GoString() string {
	return s.String()
}

type DeleteTimelineEventInput struct {
	_ struct{} `type:"structure"`

	// The ID of the event to update. You can use ListTimelineEvents to find an
	// event's ID.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the incident that includes the timeline
	// event.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimelineEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimelineEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTimelineEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTimelineEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *DeleteTimelineEventInput) SetEventId(v string) *DeleteTimelineEventInput {
	s.EventId = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *DeleteTimelineEventInput) SetIncidentRecordArn(v string) *DeleteTimelineEventInput {
	s.IncidentRecordArn = &v
	return s
}

type DeleteTimelineEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimelineEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimelineEventOutput) GoString() string {
	return s.String()
}

// The dynamic SSM parameter value.
type DynamicSsmParameterValue struct {
	_ struct{} `type:"structure"`

	// Variable dynamic parameters. A parameter value is determined when an incident
	// is created.
	Variable *string `locationName:"variable" type:"string" enum:"VariableType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicSsmParameterValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicSsmParameterValue) GoString() string {
	return s.String()
}

// SetVariable sets the Variable field's value.
func (s *DynamicSsmParameterValue) SetVariable(v string) *DynamicSsmParameterValue {
	s.Variable = &v
	return s
}

// Used to remove the chat channel from an incident record or response plan.
type EmptyChatChannel struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmptyChatChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmptyChatChannel) GoString() string {
	return s.String()
}

// An item referenced in a TimelineEvent that is involved in or somehow associated
// with an incident. You can specify an Amazon Resource Name (ARN) for an Amazon
// Web Services resource or a RelatedItem ID.
type EventReference struct {
	_ struct{} `type:"structure"`

	// The ID of a RelatedItem referenced in a TimelineEvent.
	RelatedItemId *string `locationName:"relatedItemId" type:"string"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services resource referenced
	// in a TimelineEvent.
	Resource *string `locationName:"resource" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventReference) GoString() string {
	return s.String()
}

// SetRelatedItemId sets the RelatedItemId field's value.
func (s *EventReference) SetRelatedItemId(v string) *EventReference {
	s.RelatedItemId = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *EventReference) SetResource(v string) *EventReference {
	s.Resource = &v
	return s
}

// Details about a timeline event during an incident.
type EventSummary struct {
	_ struct{} `type:"structure"`

	// The timeline event ID.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// A list of references in a TimelineEvent.
	EventReferences []*EventReference `locationName:"eventReferences" type:"list"`

	// The timestamp for when the event occurred.
	//
	// EventTime is a required field
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" required:"true"`

	// The type of event. The timeline event must be Custom Event or Note.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true"`

	// The timestamp for when the timeline event was last updated.
	//
	// EventUpdatedTime is a required field
	EventUpdatedTime *time.Time `locationName:"eventUpdatedTime" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the incident that the event happened during.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSummary) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *EventSummary) SetEventId(v string) *EventSummary {
	s.EventId = &v
	return s
}

// SetEventReferences sets the EventReferences field's value.
func (s *EventSummary) SetEventReferences(v []*EventReference) *EventSummary {
	s.EventReferences = v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *EventSummary) SetEventTime(v time.Time) *EventSummary {
	s.EventTime = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *EventSummary) SetEventType(v string) *EventSummary {
	s.EventType = &v
	return s
}

// SetEventUpdatedTime sets the EventUpdatedTime field's value.
func (s *EventSummary) SetEventUpdatedTime(v time.Time) *EventSummary {
	s.EventUpdatedTime = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *EventSummary) SetIncidentRecordArn(v string) *EventSummary {
	s.IncidentRecordArn = &v
	return s
}

// Filter the selection by using a condition.
type Filter struct {
	_ struct{} `type:"structure"`

	// The condition accepts before or after a specified time, equal to a string,
	// or equal to an integer.
	//
	// Condition is a required field
	Condition *Condition `locationName:"condition" type:"structure" required:"true"`

	// The key that you're filtering on.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *Filter) SetCondition(v *Condition) *Filter {
	s.Condition = v
	return s
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// Information about a specific CodeDeploy deployment or CloudFormation stack
// creation or update that occurred around the time of a reported incident.
// These activities can be investigated as a potential cause of the incident.
type Finding struct {
	_ struct{} `type:"structure"`

	// The timestamp for when a finding was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// Details about the finding.
	Details *FindingDetails `locationName:"details" type:"structure"`

	// The ID assigned to the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The timestamp for when the finding was most recently updated with additional
	// information.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Finding) SetCreationTime(v time.Time) *Finding {
	s.CreationTime = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *Finding) SetDetails(v *FindingDetails) *Finding {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Finding) SetLastModifiedTime(v time.Time) *Finding {
	s.LastModifiedTime = &v
	return s
}

// Extended textual information about the finding.
type FindingDetails struct {
	_ struct{} `type:"structure"`

	// Information about the CloudFormation stack creation or update associated
	// with the finding.
	CloudFormationStackUpdate *CloudFormationStackUpdate `locationName:"cloudFormationStackUpdate" type:"structure"`

	// Information about the CodeDeploy deployment associated with the finding.
	CodeDeployDeployment *CodeDeployDeployment `locationName:"codeDeployDeployment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetails) GoString() string {
	return s.String()
}

// SetCloudFormationStackUpdate sets the CloudFormationStackUpdate field's value.
func (s *FindingDetails) SetCloudFormationStackUpdate(v *CloudFormationStackUpdate) *FindingDetails {
	s.CloudFormationStackUpdate = v
	return s
}

// SetCodeDeployDeployment sets the CodeDeployDeployment field's value.
func (s *FindingDetails) SetCodeDeployDeployment(v *CodeDeployDeployment) *FindingDetails {
	s.CodeDeployDeployment = v
	return s
}

// Identifying information about the finding.
type FindingSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The timestamp for when the finding was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *FindingSummary) SetId(v string) *FindingSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FindingSummary) SetLastModifiedTime(v time.Time) *FindingSummary {
	s.LastModifiedTime = &v
	return s
}

type GetIncidentRecordInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the incident record.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIncidentRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIncidentRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIncidentRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIncidentRecordInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetIncidentRecordInput) SetArn(v string) *GetIncidentRecordInput {
	s.Arn = &v
	return s
}

type GetIncidentRecordOutput struct {
	_ struct{} `type:"structure"`

	// Details the structure of the incident record.
	//
	// IncidentRecord is a required field
	IncidentRecord *IncidentRecord `locationName:"incidentRecord" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIncidentRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIncidentRecordOutput) GoString() string {
	return s.String()
}

// SetIncidentRecord sets the IncidentRecord field's value.
func (s *GetIncidentRecordOutput) SetIncidentRecord(v *IncidentRecord) *GetIncidentRecordOutput {
	s.IncidentRecord = v
	return s
}

type GetReplicationSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the replication set you want to retrieve.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReplicationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReplicationSetInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetReplicationSetInput) SetArn(v string) *GetReplicationSetInput {
	s.Arn = &v
	return s
}

type GetReplicationSetOutput struct {
	_ struct{} `type:"structure"`

	// Details of the replication set.
	//
	// ReplicationSet is a required field
	ReplicationSet *ReplicationSet `locationName:"replicationSet" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationSetOutput) GoString() string {
	return s.String()
}

// SetReplicationSet sets the ReplicationSet field's value.
func (s *GetReplicationSetOutput) SetReplicationSet(v *ReplicationSet) *GetReplicationSetOutput {
	s.ReplicationSet = v
	return s
}

type GetResourcePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of resource policies to display for each page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the response plan with the attached resource
	// policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourcePoliciesInput) SetMaxResults(v int64) *GetResourcePoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesInput) SetNextToken(v string) *GetResourcePoliciesInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePoliciesInput) SetResourceArn(v string) *GetResourcePoliciesInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about the resource policy attached to the response plan.
	//
	// ResourcePolicies is a required field
	ResourcePolicies []*ResourcePolicy `locationName:"resourcePolicies" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesOutput) SetNextToken(v string) *GetResourcePoliciesOutput {
	s.NextToken = &v
	return s
}

// SetResourcePolicies sets the ResourcePolicies field's value.
func (s *GetResourcePoliciesOutput) SetResourcePolicies(v []*ResourcePolicy) *GetResourcePoliciesOutput {
	s.ResourcePolicies = v
	return s
}

type GetResponsePlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the response plan.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResponsePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResponsePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResponsePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResponsePlanInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResponsePlanInput) SetArn(v string) *GetResponsePlanInput {
	s.Arn = &v
	return s
}

type GetResponsePlanOutput struct {
	_ struct{} `type:"structure"`

	// The actions that this response plan takes at the beginning of the incident.
	Actions []*Action `locationName:"actions" type:"list"`

	// The ARN of the response plan.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Chatbot chat channel used for collaboration during an incident.
	ChatChannel *ChatChannel `locationName:"chatChannel" type:"structure"`

	// The long format name of the response plan. Can contain spaces.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The Amazon Resource Name (ARN) for the contacts and escalation plans that
	// the response plan engages during an incident.
	Engagements []*string `locationName:"engagements" type:"list"`

	// Details used to create the incident when using this response plan.
	//
	// IncidentTemplate is a required field
	IncidentTemplate *IncidentTemplate `locationName:"incidentTemplate" type:"structure" required:"true"`

	// Information about third-party services integrated into the Incident Manager
	// response plan.
	Integrations []*Integration `locationName:"integrations" type:"list"`

	// The short format name of the response plan. The name can't contain spaces.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResponsePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResponsePlanOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *GetResponsePlanOutput) SetActions(v []*Action) *GetResponsePlanOutput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetResponsePlanOutput) SetArn(v string) *GetResponsePlanOutput {
	s.Arn = &v
	return s
}

// SetChatChannel sets the ChatChannel field's value.
func (s *GetResponsePlanOutput) SetChatChannel(v *ChatChannel) *GetResponsePlanOutput {
	s.ChatChannel = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetResponsePlanOutput) SetDisplayName(v string) *GetResponsePlanOutput {
	s.DisplayName = &v
	return s
}

// SetEngagements sets the Engagements field's value.
func (s *GetResponsePlanOutput) SetEngagements(v []*string) *GetResponsePlanOutput {
	s.Engagements = v
	return s
}

// SetIncidentTemplate sets the IncidentTemplate field's value.
func (s *GetResponsePlanOutput) SetIncidentTemplate(v *IncidentTemplate) *GetResponsePlanOutput {
	s.IncidentTemplate = v
	return s
}

// SetIntegrations sets the Integrations field's value.
func (s *GetResponsePlanOutput) SetIntegrations(v []*Integration) *GetResponsePlanOutput {
	s.Integrations = v
	return s
}

// SetName sets the Name field's value.
func (s *GetResponsePlanOutput) SetName(v string) *GetResponsePlanOutput {
	s.Name = &v
	return s
}

type GetTimelineEventInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the event. You can get an event's ID when you create it, or by
	// using ListTimelineEvents.
	//
	// EventId is a required field
	EventId *string `location:"querystring" locationName:"eventId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the incident that includes the timeline
	// event.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `location:"querystring" locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTimelineEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTimelineEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTimelineEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTimelineEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *GetTimelineEventInput) SetEventId(v string) *GetTimelineEventInput {
	s.EventId = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *GetTimelineEventInput) SetIncidentRecordArn(v string) *GetTimelineEventInput {
	s.IncidentRecordArn = &v
	return s
}

type GetTimelineEventOutput struct {
	_ struct{} `type:"structure"`

	// Details about the timeline event.
	//
	// Event is a required field
	Event *TimelineEvent `locationName:"event" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTimelineEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTimelineEventOutput) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *GetTimelineEventOutput) SetEvent(v *TimelineEvent) *GetTimelineEventOutput {
	s.Event = v
	return s
}

// The record of the incident that's created when an incident occurs.
type IncidentRecord struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident record.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The runbook, or automation document, that's run at the beginning of the incident.
	AutomationExecutions []*AutomationExecution `locationName:"automationExecutions" type:"list"`

	// The chat channel used for collaboration during an incident.
	ChatChannel *ChatChannel `locationName:"chatChannel" type:"structure"`

	// The timestamp for when Incident Manager created the incident record.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The string Incident Manager uses to prevent duplicate incidents from being
	// created by the same incident in the same account.
	//
	// DedupeString is a required field
	DedupeString *string `locationName:"dedupeString" type:"string" required:"true"`

	// The impact of the incident on customers and applications.
	//
	// Supported impact codes
	//
	//    * 1 - Critical
	//
	//    * 2 - High
	//
	//    * 3 - Medium
	//
	//    * 4 - Low
	//
	//    * 5 - No Impact
	//
	// Impact is a required field
	Impact *int64 `locationName:"impact" min:"1" type:"integer" required:"true"`

	// Details about the action that started the incident.
	//
	// IncidentRecordSource is a required field
	IncidentRecordSource *IncidentRecordSource `locationName:"incidentRecordSource" type:"structure" required:"true"`

	// Who modified the incident most recently.
	//
	// LastModifiedBy is a required field
	LastModifiedBy *string `locationName:"lastModifiedBy" type:"string" required:"true"`

	// The timestamp for when the incident was most recently modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" required:"true"`

	// The Amazon SNS targets that are notified when updates are made to an incident.
	NotificationTargets []*NotificationTargetItem `locationName:"notificationTargets" type:"list"`

	// The timestamp for when the incident was resolved. This appears as a timeline
	// event.
	ResolvedTime *time.Time `locationName:"resolvedTime" type:"timestamp"`

	// The current status of the incident.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IncidentRecordStatus"`

	// The summary of the incident. The summary is a brief synopsis of what occurred,
	// what's currently happening, and context of the incident.
	Summary *string `locationName:"summary" type:"string"`

	// The title of the incident.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecord) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IncidentRecord) SetArn(v string) *IncidentRecord {
	s.Arn = &v
	return s
}

// SetAutomationExecutions sets the AutomationExecutions field's value.
func (s *IncidentRecord) SetAutomationExecutions(v []*AutomationExecution) *IncidentRecord {
	s.AutomationExecutions = v
	return s
}

// SetChatChannel sets the ChatChannel field's value.
func (s *IncidentRecord) SetChatChannel(v *ChatChannel) *IncidentRecord {
	s.ChatChannel = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *IncidentRecord) SetCreationTime(v time.Time) *IncidentRecord {
	s.CreationTime = &v
	return s
}

// SetDedupeString sets the DedupeString field's value.
func (s *IncidentRecord) SetDedupeString(v string) *IncidentRecord {
	s.DedupeString = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *IncidentRecord) SetImpact(v int64) *IncidentRecord {
	s.Impact = &v
	return s
}

// SetIncidentRecordSource sets the IncidentRecordSource field's value.
func (s *IncidentRecord) SetIncidentRecordSource(v *IncidentRecordSource) *IncidentRecord {
	s.IncidentRecordSource = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *IncidentRecord) SetLastModifiedBy(v string) *IncidentRecord {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *IncidentRecord) SetLastModifiedTime(v time.Time) *IncidentRecord {
	s.LastModifiedTime = &v
	return s
}

// SetNotificationTargets sets the NotificationTargets field's value.
func (s *IncidentRecord) SetNotificationTargets(v []*NotificationTargetItem) *IncidentRecord {
	s.NotificationTargets = v
	return s
}

// SetResolvedTime sets the ResolvedTime field's value.
func (s *IncidentRecord) SetResolvedTime(v time.Time) *IncidentRecord {
	s.ResolvedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IncidentRecord) SetStatus(v string) *IncidentRecord {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *IncidentRecord) SetSummary(v string) *IncidentRecord {
	s.Summary = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *IncidentRecord) SetTitle(v string) *IncidentRecord {
	s.Title = &v
	return s
}

// Details about what created the incident record and when it was created.
type IncidentRecordSource struct {
	_ struct{} `type:"structure"`

	// The principal that started the incident.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The service principal that assumed the role specified in createdBy. If no
	// service principal assumed the role this will be left blank.
	InvokedBy *string `locationName:"invokedBy" type:"string"`

	// The resource that caused the incident to be created.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The service that started the incident. This can be manually created from
	// Incident Manager, automatically created using an Amazon CloudWatch alarm,
	// or Amazon EventBridge event.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecordSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecordSource) GoString() string {
	return s.String()
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *IncidentRecordSource) SetCreatedBy(v string) *IncidentRecordSource {
	s.CreatedBy = &v
	return s
}

// SetInvokedBy sets the InvokedBy field's value.
func (s *IncidentRecordSource) SetInvokedBy(v string) *IncidentRecordSource {
	s.InvokedBy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *IncidentRecordSource) SetResourceArn(v string) *IncidentRecordSource {
	s.ResourceArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *IncidentRecordSource) SetSource(v string) *IncidentRecordSource {
	s.Source = &v
	return s
}

// Details describing an incident record.
type IncidentRecordSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The timestamp for when the incident was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// Defines the impact to customers and applications.
	//
	// Impact is a required field
	Impact *int64 `locationName:"impact" min:"1" type:"integer" required:"true"`

	// What caused Incident Manager to create the incident.
	//
	// IncidentRecordSource is a required field
	IncidentRecordSource *IncidentRecordSource `locationName:"incidentRecordSource" type:"structure" required:"true"`

	// The timestamp for when the incident was resolved.
	ResolvedTime *time.Time `locationName:"resolvedTime" type:"timestamp"`

	// The current status of the incident.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IncidentRecordStatus"`

	// The title of the incident. This value is either provided by the response
	// plan or overwritten on creation.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecordSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentRecordSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IncidentRecordSummary) SetArn(v string) *IncidentRecordSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *IncidentRecordSummary) SetCreationTime(v time.Time) *IncidentRecordSummary {
	s.CreationTime = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *IncidentRecordSummary) SetImpact(v int64) *IncidentRecordSummary {
	s.Impact = &v
	return s
}

// SetIncidentRecordSource sets the IncidentRecordSource field's value.
func (s *IncidentRecordSummary) SetIncidentRecordSource(v *IncidentRecordSource) *IncidentRecordSummary {
	s.IncidentRecordSource = v
	return s
}

// SetResolvedTime sets the ResolvedTime field's value.
func (s *IncidentRecordSummary) SetResolvedTime(v time.Time) *IncidentRecordSummary {
	s.ResolvedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IncidentRecordSummary) SetStatus(v string) *IncidentRecordSummary {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *IncidentRecordSummary) SetTitle(v string) *IncidentRecordSummary {
	s.Title = &v
	return s
}

// Basic details used in creating a response plan. The response plan is then
// used to create an incident record.
type IncidentTemplate struct {
	_ struct{} `type:"structure"`

	// The string Incident Manager uses to prevent the same root cause from creating
	// multiple incidents in the same account.
	//
	// A deduplication string is a term or phrase the system uses to check for duplicate
	// incidents. If you specify a deduplication string, Incident Manager searches
	// for open incidents that contain the same string in the dedupeString field
	// when it creates the incident. If a duplicate is detected, Incident Manager
	// deduplicates the newer incident into the existing incident.
	//
	// By default, Incident Manager automatically deduplicates multiple incidents
	// created by the same Amazon CloudWatch alarm or Amazon EventBridge event.
	// You don't have to enter your own deduplication string to prevent duplication
	// for these resource types.
	DedupeString *string `locationName:"dedupeString" type:"string"`

	// The impact of the incident on your customers and applications.
	//
	// Supported impact codes
	//
	//    * 1 - Critical
	//
	//    * 2 - High
	//
	//    * 3 - Medium
	//
	//    * 4 - Low
	//
	//    * 5 - No Impact
	//
	// Impact is a required field
	Impact *int64 `locationName:"impact" min:"1" type:"integer" required:"true"`

	// Tags to assign to the template. When the StartIncident API action is called,
	// Incident Manager assigns the tags specified in the template to the incident.
	IncidentTags map[string]*string `locationName:"incidentTags" min:"1" type:"map"`

	// The Amazon SNS targets that are notified when updates are made to an incident.
	NotificationTargets []*NotificationTargetItem `locationName:"notificationTargets" type:"list"`

	// The summary of the incident. The summary is a brief synopsis of what occurred,
	// what's currently happening, and context.
	Summary *string `locationName:"summary" type:"string"`

	// The title of the incident.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncidentTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncidentTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncidentTemplate"}
	if s.Impact == nil {
		invalidParams.Add(request.NewErrParamRequired("Impact"))
	}
	if s.Impact != nil && *s.Impact < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Impact", 1))
	}
	if s.IncidentTags != nil && len(s.IncidentTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncidentTags", 1))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDedupeString sets the DedupeString field's value.
func (s *IncidentTemplate) SetDedupeString(v string) *IncidentTemplate {
	s.DedupeString = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *IncidentTemplate) SetImpact(v int64) *IncidentTemplate {
	s.Impact = &v
	return s
}

// SetIncidentTags sets the IncidentTags field's value.
func (s *IncidentTemplate) SetIncidentTags(v map[string]*string) *IncidentTemplate {
	s.IncidentTags = v
	return s
}

// SetNotificationTargets sets the NotificationTargets field's value.
func (s *IncidentTemplate) SetNotificationTargets(v []*NotificationTargetItem) *IncidentTemplate {
	s.NotificationTargets = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *IncidentTemplate) SetSummary(v string) *IncidentTemplate {
	s.Summary = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *IncidentTemplate) SetTitle(v string) *IncidentTemplate {
	s.Title = &v
	return s
}

// Information about third-party services integrated into a response plan.
type Integration struct {
	_ struct{} `type:"structure"`

	// Information about the PagerDuty service where the response plan creates an
	// incident.
	PagerDutyConfiguration *PagerDutyConfiguration `locationName:"pagerDutyConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Integration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Integration"}
	if s.PagerDutyConfiguration != nil {
		if err := s.PagerDutyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PagerDutyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPagerDutyConfiguration sets the PagerDutyConfiguration field's value.
func (s *Integration) SetPagerDutyConfiguration(v *PagerDutyConfiguration) *Integration {
	s.PagerDutyConfiguration = v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details and type of a related item.
type ItemIdentifier struct {
	_ struct{} `type:"structure"`

	// The type of related item.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ItemType"`

	// Details about the related item.
	//
	// Value is a required field
	Value *ItemValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ItemIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ItemIdentifier"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ItemIdentifier) SetType(v string) *ItemIdentifier {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ItemIdentifier) SetValue(v *ItemValue) *ItemIdentifier {
	s.Value = v
	return s
}

// Describes a related item.
type ItemValue struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the related item, if the related item is
	// an Amazon resource.
	Arn *string `locationName:"arn" type:"string"`

	// The metric definition, if the related item is a metric in Amazon CloudWatch.
	MetricDefinition *string `locationName:"metricDefinition" type:"string"`

	// Details about an incident that is associated with a PagerDuty incident.
	PagerDutyIncidentDetail *PagerDutyIncidentDetail `locationName:"pagerDutyIncidentDetail" type:"structure"`

	// The URL, if the related item is a non-Amazon Web Services resource.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ItemValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ItemValue"}
	if s.PagerDutyIncidentDetail != nil {
		if err := s.PagerDutyIncidentDetail.Validate(); err != nil {
			invalidParams.AddNested("PagerDutyIncidentDetail", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ItemValue) SetArn(v string) *ItemValue {
	s.Arn = &v
	return s
}

// SetMetricDefinition sets the MetricDefinition field's value.
func (s *ItemValue) SetMetricDefinition(v string) *ItemValue {
	s.MetricDefinition = &v
	return s
}

// SetPagerDutyIncidentDetail sets the PagerDutyIncidentDetail field's value.
func (s *ItemValue) SetPagerDutyIncidentDetail(v *PagerDutyIncidentDetail) *ItemValue {
	s.PagerDutyIncidentDetail = v
	return s
}

// SetUrl sets the Url field's value.
func (s *ItemValue) SetUrl(v string) *ItemValue {
	s.Url = &v
	return s
}

type ListIncidentFindingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident for which you want to view
	// associated findings.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`

	// The maximum number of findings to retrieve per call.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIncidentFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIncidentFindingsInput"}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *ListIncidentFindingsInput) SetIncidentRecordArn(v string) *ListIncidentFindingsInput {
	s.IncidentRecordArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIncidentFindingsInput) SetMaxResults(v int64) *ListIncidentFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncidentFindingsInput) SetNextToken(v string) *ListIncidentFindingsInput {
	s.NextToken = &v
	return s
}

type ListIncidentFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings that represent deployments that might be the potential
	// cause of the incident.
	//
	// Findings is a required field
	Findings []*FindingSummary `locationName:"findings" type:"list" required:"true"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListIncidentFindingsOutput) SetFindings(v []*FindingSummary) *ListIncidentFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncidentFindingsOutput) SetNextToken(v string) *ListIncidentFindingsOutput {
	s.NextToken = &v
	return s
}

type ListIncidentRecordsInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of incident records you want to search through. You can
	// filter on the following keys:
	//
	//    * creationTime
	//
	//    * impact
	//
	//    * status
	//
	//    * createdBy
	//
	// Note the following when when you use Filters:
	//
	//    * If you don't specify a Filter, the response includes all incident records.
	//
	//    * If you specify more than one filter in a single request, the response
	//    returns incident records that match all filters.
	//
	//    * If you specify a filter with more than one value, the response returns
	//    incident records that match any of the values provided.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The maximum number of results per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIncidentRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIncidentRecordsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListIncidentRecordsInput) SetFilters(v []*Filter) *ListIncidentRecordsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIncidentRecordsInput) SetMaxResults(v int64) *ListIncidentRecordsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncidentRecordsInput) SetNextToken(v string) *ListIncidentRecordsInput {
	s.NextToken = &v
	return s
}

type ListIncidentRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The details of each listed incident record.
	//
	// IncidentRecordSummaries is a required field
	IncidentRecordSummaries []*IncidentRecordSummary `locationName:"incidentRecordSummaries" type:"list" required:"true"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIncidentRecordsOutput) GoString() string {
	return s.String()
}

// SetIncidentRecordSummaries sets the IncidentRecordSummaries field's value.
func (s *ListIncidentRecordsOutput) SetIncidentRecordSummaries(v []*IncidentRecordSummary) *ListIncidentRecordsOutput {
	s.IncidentRecordSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIncidentRecordsOutput) SetNextToken(v string) *ListIncidentRecordsOutput {
	s.NextToken = &v
	return s
}

type ListRelatedItemsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident record containing the listed
	// related items.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`

	// The maximum number of related items per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelatedItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelatedItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRelatedItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRelatedItemsInput"}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *ListRelatedItemsInput) SetIncidentRecordArn(v string) *ListRelatedItemsInput {
	s.IncidentRecordArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRelatedItemsInput) SetMaxResults(v int64) *ListRelatedItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRelatedItemsInput) SetNextToken(v string) *ListRelatedItemsInput {
	s.NextToken = &v
	return s
}

type ListRelatedItemsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about each related item.
	//
	// RelatedItems is a required field
	RelatedItems []*RelatedItem `locationName:"relatedItems" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelatedItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelatedItemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRelatedItemsOutput) SetNextToken(v string) *ListRelatedItemsOutput {
	s.NextToken = &v
	return s
}

// SetRelatedItems sets the RelatedItems field's value.
func (s *ListRelatedItemsOutput) SetRelatedItems(v []*RelatedItem) *ListRelatedItemsOutput {
	s.RelatedItems = v
	return s
}

type ListReplicationSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplicationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplicationSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReplicationSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReplicationSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReplicationSetsInput) SetMaxResults(v int64) *ListReplicationSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplicationSetsInput) SetNextToken(v string) *ListReplicationSetsInput {
	s.NextToken = &v
	return s
}

type ListReplicationSetsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the list replication set.
	//
	// ReplicationSetArns is a required field
	ReplicationSetArns []*string `locationName:"replicationSetArns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplicationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplicationSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplicationSetsOutput) SetNextToken(v string) *ListReplicationSetsOutput {
	s.NextToken = &v
	return s
}

// SetReplicationSetArns sets the ReplicationSetArns field's value.
func (s *ListReplicationSetsOutput) SetReplicationSetArns(v []*string) *ListReplicationSetsOutput {
	s.ReplicationSetArns = v
	return s
}

type ListResponsePlansInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of response plans per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResponsePlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResponsePlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResponsePlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResponsePlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResponsePlansInput) SetMaxResults(v int64) *ListResponsePlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResponsePlansInput) SetNextToken(v string) *ListResponsePlansInput {
	s.NextToken = &v
	return s
}

type ListResponsePlansOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details of each response plan.
	//
	// ResponsePlanSummaries is a required field
	ResponsePlanSummaries []*ResponsePlanSummary `locationName:"responsePlanSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResponsePlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResponsePlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResponsePlansOutput) SetNextToken(v string) *ListResponsePlansOutput {
	s.NextToken = &v
	return s
}

// SetResponsePlanSummaries sets the ResponsePlanSummaries field's value.
func (s *ListResponsePlansOutput) SetResponsePlanSummaries(v []*ResponsePlanSummary) *ListResponsePlansOutput {
	s.ResponsePlanSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the response plan or incident.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags for the response plan or incident.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTimelineEventsInput struct {
	_ struct{} `type:"structure"`

	// Filters the timeline events based on the provided conditional values. You
	// can filter timeline events with the following keys:
	//
	//    * eventReference
	//
	//    * eventTime
	//
	//    * eventType
	//
	// Note the following when deciding how to use Filters:
	//
	//    * If you don't specify a Filter, the response includes all timeline events.
	//
	//    * If you specify more than one filter in a single request, the response
	//    returns timeline events that match all filters.
	//
	//    * If you specify a filter with more than one value, the response returns
	//    timeline events that match any of the values provided.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The Amazon Resource Name (ARN) of the incident that includes the timeline
	// event.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`

	// The maximum number of results per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `locationName:"nextToken" type:"string"`

	// Sort timeline events by the specified key value pair.
	SortBy *string `locationName:"sortBy" type:"string" enum:"TimelineEventSort"`

	// Sorts the order of timeline events by the value specified in the sortBy field.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimelineEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimelineEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTimelineEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTimelineEventsInput"}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTimelineEventsInput) SetFilters(v []*Filter) *ListTimelineEventsInput {
	s.Filters = v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *ListTimelineEventsInput) SetIncidentRecordArn(v string) *ListTimelineEventsInput {
	s.IncidentRecordArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTimelineEventsInput) SetMaxResults(v int64) *ListTimelineEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTimelineEventsInput) SetNextToken(v string) *ListTimelineEventsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListTimelineEventsInput) SetSortBy(v string) *ListTimelineEventsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListTimelineEventsInput) SetSortOrder(v string) *ListTimelineEventsInput {
	s.SortOrder = &v
	return s
}

type ListTimelineEventsOutput struct {
	_ struct{} `type:"structure"`

	// Details about each event that occurred during the incident.
	//
	// EventSummaries is a required field
	EventSummaries []*EventSummary `locationName:"eventSummaries" type:"list" required:"true"`

	// The pagination token to use when requesting the next set of items. If there
	// are no additional items to return, the string is null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimelineEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTimelineEventsOutput) GoString() string {
	return s.String()
}

// SetEventSummaries sets the EventSummaries field's value.
func (s *ListTimelineEventsOutput) SetEventSummaries(v []*EventSummary) *ListTimelineEventsOutput {
	s.EventSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTimelineEventsOutput) SetNextToken(v string) *ListTimelineEventsOutput {
	s.NextToken = &v
	return s
}

// The SNS targets that are notified when updates are made to an incident.
type NotificationTargetItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SNS topic.
	SnsTopicArn *string `locationName:"snsTopicArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationTargetItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationTargetItem) GoString() string {
	return s.String()
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *NotificationTargetItem) SetSnsTopicArn(v string) *NotificationTargetItem {
	s.SnsTopicArn = &v
	return s
}

// Details about the PagerDuty configuration for a response plan.
type PagerDutyConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the PagerDuty configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Details about the PagerDuty service associated with the configuration.
	//
	// PagerDutyIncidentConfiguration is a required field
	PagerDutyIncidentConfiguration *PagerDutyIncidentConfiguration `locationName:"pagerDutyIncidentConfiguration" type:"structure" required:"true"`

	// The ID of the Amazon Web Services Secrets Manager secret that stores your
	// PagerDuty key, either a General Access REST API Key or User Token REST API
	// Key, and other user credentials.
	//
	// SecretId is a required field
	SecretId *string `locationName:"secretId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PagerDutyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PagerDutyConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PagerDutyIncidentConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("PagerDutyIncidentConfiguration"))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.PagerDutyIncidentConfiguration != nil {
		if err := s.PagerDutyIncidentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PagerDutyIncidentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PagerDutyConfiguration) SetName(v string) *PagerDutyConfiguration {
	s.Name = &v
	return s
}

// SetPagerDutyIncidentConfiguration sets the PagerDutyIncidentConfiguration field's value.
func (s *PagerDutyConfiguration) SetPagerDutyIncidentConfiguration(v *PagerDutyIncidentConfiguration) *PagerDutyConfiguration {
	s.PagerDutyIncidentConfiguration = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PagerDutyConfiguration) SetSecretId(v string) *PagerDutyConfiguration {
	s.SecretId = &v
	return s
}

// Details about the PagerDuty service where the response plan creates an incident.
type PagerDutyIncidentConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the PagerDuty service that the response plan associates with an
	// incident when it launches.
	//
	// ServiceId is a required field
	ServiceId *string `locationName:"serviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyIncidentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyIncidentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PagerDutyIncidentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PagerDutyIncidentConfiguration"}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}
	if s.ServiceId != nil && len(*s.ServiceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceId sets the ServiceId field's value.
func (s *PagerDutyIncidentConfiguration) SetServiceId(v string) *PagerDutyIncidentConfiguration {
	s.ServiceId = &v
	return s
}

// Details about the PagerDuty incident associated with an incident created
// by an Incident Manager response plan.
type PagerDutyIncidentDetail struct {
	_ struct{} `type:"structure"`

	// Indicates whether to resolve the PagerDuty incident when you resolve the
	// associated Incident Manager incident.
	AutoResolve *bool `locationName:"autoResolve" type:"boolean"`

	// The ID of the incident associated with the PagerDuty service for the response
	// plan.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services Secrets Manager secret that stores your
	// PagerDuty key, either a General Access REST API Key or User Token REST API
	// Key, and other user credentials.
	SecretId *string `locationName:"secretId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyIncidentDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PagerDutyIncidentDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PagerDutyIncidentDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PagerDutyIncidentDetail"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoResolve sets the AutoResolve field's value.
func (s *PagerDutyIncidentDetail) SetAutoResolve(v bool) *PagerDutyIncidentDetail {
	s.AutoResolve = &v
	return s
}

// SetId sets the Id field's value.
func (s *PagerDutyIncidentDetail) SetId(v string) *PagerDutyIncidentDetail {
	s.Id = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PagerDutyIncidentDetail) SetSecretId(v string) *PagerDutyIncidentDetail {
	s.SecretId = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Details of the resource policy.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the response plan to add the resource policy
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource policy.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyId sets the PolicyId field's value.
func (s *PutResourcePolicyOutput) SetPolicyId(v string) *PutResourcePolicyOutput {
	s.PolicyId = &v
	return s
}

// Information about a Amazon Web Services Region in your replication set.
type RegionInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the KMS key used to encrypt the data in this Amazon Web Services
	// Region.
	SseKmsKeyId *string `locationName:"sseKmsKeyId" type:"string"`

	// The status of the Amazon Web Services Region in the replication set.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegionStatus"`

	// Information displayed about the status of the Amazon Web Services Region.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The timestamp for when Incident Manager updated the status of the Amazon
	// Web Services Region.
	//
	// StatusUpdateDateTime is a required field
	StatusUpdateDateTime *time.Time `locationName:"statusUpdateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionInfo) GoString() string {
	return s.String()
}

// SetSseKmsKeyId sets the SseKmsKeyId field's value.
func (s *RegionInfo) SetSseKmsKeyId(v string) *RegionInfo {
	s.SseKmsKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegionInfo) SetStatus(v string) *RegionInfo {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RegionInfo) SetStatusMessage(v string) *RegionInfo {
	s.StatusMessage = &v
	return s
}

// SetStatusUpdateDateTime sets the StatusUpdateDateTime field's value.
func (s *RegionInfo) SetStatusUpdateDateTime(v time.Time) *RegionInfo {
	s.StatusUpdateDateTime = &v
	return s
}

// The mapping between a Amazon Web Services Region and the key that's used
// to encrypt the data.
type RegionMapInputValue struct {
	_ struct{} `type:"structure"`

	// The KMS key used to encrypt the data in your replication set.
	SseKmsKeyId *string `locationName:"sseKmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionMapInputValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionMapInputValue) GoString() string {
	return s.String()
}

// SetSseKmsKeyId sets the SseKmsKeyId field's value.
func (s *RegionMapInputValue) SetSseKmsKeyId(v string) *RegionMapInputValue {
	s.SseKmsKeyId = &v
	return s
}

// Resources that responders use to triage and mitigate the incident.
type RelatedItem struct {
	_ struct{} `type:"structure"`

	// A unique ID for a RelatedItem.
	//
	// Don't specify this parameter when you add a RelatedItem by using the UpdateRelatedItems
	// API action.
	GeneratedId *string `locationName:"generatedId" type:"string"`

	// Details about the related item.
	//
	// Identifier is a required field
	Identifier *ItemIdentifier `locationName:"identifier" type:"structure" required:"true"`

	// The title of the related item.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedItem"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil {
		if err := s.Identifier.Validate(); err != nil {
			invalidParams.AddNested("Identifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeneratedId sets the GeneratedId field's value.
func (s *RelatedItem) SetGeneratedId(v string) *RelatedItem {
	s.GeneratedId = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *RelatedItem) SetIdentifier(v *ItemIdentifier) *RelatedItem {
	s.Identifier = v
	return s
}

// SetTitle sets the Title field's value.
func (s *RelatedItem) SetTitle(v string) *RelatedItem {
	s.Title = &v
	return s
}

// Details about the related item you're adding.
type RelatedItemsUpdate struct {
	_ struct{} `type:"structure"`

	// Details about the related item you're adding.
	ItemToAdd *RelatedItem `locationName:"itemToAdd" type:"structure"`

	// Details about the related item you're deleting.
	ItemToRemove *ItemIdentifier `locationName:"itemToRemove" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemsUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedItemsUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedItemsUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedItemsUpdate"}
	if s.ItemToAdd != nil {
		if err := s.ItemToAdd.Validate(); err != nil {
			invalidParams.AddNested("ItemToAdd", err.(request.ErrInvalidParams))
		}
	}
	if s.ItemToRemove != nil {
		if err := s.ItemToRemove.Validate(); err != nil {
			invalidParams.AddNested("ItemToRemove", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItemToAdd sets the ItemToAdd field's value.
func (s *RelatedItemsUpdate) SetItemToAdd(v *RelatedItem) *RelatedItemsUpdate {
	s.ItemToAdd = v
	return s
}

// SetItemToRemove sets the ItemToRemove field's value.
func (s *RelatedItemsUpdate) SetItemToRemove(v *ItemIdentifier) *RelatedItemsUpdate {
	s.ItemToRemove = v
	return s
}

// The set of Amazon Web Services Region that your Incident Manager data will
// be replicated to and the KMS key used to encrypt the data.
type ReplicationSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication set.
	Arn *string `locationName:"arn" type:"string"`

	// Details about who created the replication set.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// When the replication set was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// Determines if the replication set deletion protection is enabled or not.
	// If deletion protection is enabled, you can't delete the last Amazon Web Services
	// Region in the replication set.
	//
	// DeletionProtected is a required field
	DeletionProtected *bool `locationName:"deletionProtected" type:"boolean" required:"true"`

	// Who last modified the replication set.
	//
	// LastModifiedBy is a required field
	LastModifiedBy *string `locationName:"lastModifiedBy" type:"string" required:"true"`

	// When the replication set was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" required:"true"`

	// The map between each Amazon Web Services Region in your replication set and
	// the KMS key that's used to encrypt the data in that Region.
	//
	// RegionMap is a required field
	RegionMap map[string]*RegionInfo `locationName:"regionMap" type:"map" required:"true"`

	// The status of the replication set. If the replication set is still pending,
	// you can't use Incident Manager functionality.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ReplicationSetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationSet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReplicationSet) SetArn(v string) *ReplicationSet {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ReplicationSet) SetCreatedBy(v string) *ReplicationSet {
	s.CreatedBy = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ReplicationSet) SetCreatedTime(v time.Time) *ReplicationSet {
	s.CreatedTime = &v
	return s
}

// SetDeletionProtected sets the DeletionProtected field's value.
func (s *ReplicationSet) SetDeletionProtected(v bool) *ReplicationSet {
	s.DeletionProtected = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ReplicationSet) SetLastModifiedBy(v string) *ReplicationSet {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ReplicationSet) SetLastModifiedTime(v time.Time) *ReplicationSet {
	s.LastModifiedTime = &v
	return s
}

// SetRegionMap sets the RegionMap field's value.
func (s *ReplicationSet) SetRegionMap(v map[string]*RegionInfo) *ReplicationSet {
	s.RegionMap = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationSet) SetStatus(v string) *ReplicationSet {
	s.Status = &v
	return s
}

// Request references a resource which doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the requested resource
	ResourceIdentifier *string `locationName:"resourceIdentifier" type:"string"`

	// The resource type
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource policy that allows Incident Manager to perform actions on resources
// on your behalf.
type ResourcePolicy struct {
	_ struct{} `type:"structure"`

	// The JSON blob that describes the policy.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The ID of the resource policy.
	//
	// PolicyId is a required field
	PolicyId *string `locationName:"policyId" type:"string" required:"true"`

	// The Amazon Web Services Region that policy allows resources to be used in.
	//
	// RamResourceShareRegion is a required field
	RamResourceShareRegion *string `locationName:"ramResourceShareRegion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) GoString() string {
	return s.String()
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *ResourcePolicy) SetPolicyDocument(v string) *ResourcePolicy {
	s.PolicyDocument = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ResourcePolicy) SetPolicyId(v string) *ResourcePolicy {
	s.PolicyId = &v
	return s
}

// SetRamResourceShareRegion sets the RamResourceShareRegion field's value.
func (s *ResourcePolicy) SetRamResourceShareRegion(v string) *ResourcePolicy {
	s.RamResourceShareRegion = &v
	return s
}

// Details of the response plan that are used when creating an incident.
type ResponsePlanSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the response plan.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The human readable name of the response plan. This can include spaces.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The name of the response plan. This can't include spaces.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePlanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePlanSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResponsePlanSummary) SetArn(v string) *ResponsePlanSummary {
	s.Arn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ResponsePlanSummary) SetDisplayName(v string) *ResponsePlanSummary {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResponsePlanSummary) SetName(v string) *ResponsePlanSummary {
	s.Name = &v
	return s
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Originating quota code
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The identifier for the requested resource
	ResourceIdentifier *string `locationName:"resourceIdentifier" type:"string"`

	// The resource type
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Originating service code
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true" enum:"ServiceCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the Systems Manager automation document that will be used as
// a runbook during an incident.
type SsmAutomation struct {
	_ struct{} `type:"structure"`

	// The automation document's name.
	//
	// DocumentName is a required field
	DocumentName *string `locationName:"documentName" type:"string" required:"true"`

	// The automation document's version to use when running.
	DocumentVersion *string `locationName:"documentVersion" type:"string"`

	// The key-value pair to resolve dynamic parameter values when processing a
	// Systems Manager Automation runbook.
	DynamicParameters map[string]*DynamicSsmParameterValue `locationName:"dynamicParameters" min:"1" type:"map"`

	// The key-value pair parameters to use when running the automation document.
	Parameters map[string][]*string `locationName:"parameters" min:"1" type:"map"`

	// The Amazon Resource Name (ARN) of the role that the automation document will
	// assume when running commands.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The account that the automation document will be run in. This can be in either
	// the management account or an application account.
	TargetAccount *string `locationName:"targetAccount" type:"string" enum:"SsmTargetAccount"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SsmAutomation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SsmAutomation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SsmAutomation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SsmAutomation"}
	if s.DocumentName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentName"))
	}
	if s.DynamicParameters != nil && len(s.DynamicParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DynamicParameters", 1))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentName sets the DocumentName field's value.
func (s *SsmAutomation) SetDocumentName(v string) *SsmAutomation {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *SsmAutomation) SetDocumentVersion(v string) *SsmAutomation {
	s.DocumentVersion = &v
	return s
}

// SetDynamicParameters sets the DynamicParameters field's value.
func (s *SsmAutomation) SetDynamicParameters(v map[string]*DynamicSsmParameterValue) *SsmAutomation {
	s.DynamicParameters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *SsmAutomation) SetParameters(v map[string][]*string) *SsmAutomation {
	s.Parameters = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SsmAutomation) SetRoleArn(v string) *SsmAutomation {
	s.RoleArn = &v
	return s
}

// SetTargetAccount sets the TargetAccount field's value.
func (s *SsmAutomation) SetTargetAccount(v string) *SsmAutomation {
	s.TargetAccount = &v
	return s
}

type StartIncidentInput struct {
	_ struct{} `type:"structure"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Defines the impact to the customers. Providing an impact overwrites the impact
	// provided by a response plan.
	//
	// Supported impact codes
	//
	//    * 1 - Critical
	//
	//    * 2 - High
	//
	//    * 3 - Medium
	//
	//    * 4 - Low
	//
	//    * 5 - No Impact
	Impact *int64 `locationName:"impact" min:"1" type:"integer"`

	// Add related items to the incident for other responders to use. Related items
	// are Amazon Web Services resources, external links, or files uploaded to an
	// Amazon S3 bucket.
	RelatedItems []*RelatedItem `locationName:"relatedItems" type:"list"`

	// The Amazon Resource Name (ARN) of the response plan that pre-defines summary,
	// chat channels, Amazon SNS topics, runbooks, title, and impact of the incident.
	//
	// ResponsePlanArn is a required field
	ResponsePlanArn *string `locationName:"responsePlanArn" type:"string" required:"true"`

	// Provide a title for the incident. Providing a title overwrites the title
	// provided by the response plan.
	Title *string `locationName:"title" type:"string"`

	// Details of what created the incident record in Incident Manager.
	TriggerDetails *TriggerDetails `locationName:"triggerDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIncidentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIncidentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartIncidentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartIncidentInput"}
	if s.Impact != nil && *s.Impact < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Impact", 1))
	}
	if s.ResponsePlanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponsePlanArn"))
	}
	if s.RelatedItems != nil {
		for i, v := range s.RelatedItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedItems", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerDetails != nil {
		if err := s.TriggerDetails.Validate(); err != nil {
			invalidParams.AddNested("TriggerDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartIncidentInput) SetClientToken(v string) *StartIncidentInput {
	s.ClientToken = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *StartIncidentInput) SetImpact(v int64) *StartIncidentInput {
	s.Impact = &v
	return s
}

// SetRelatedItems sets the RelatedItems field's value.
func (s *StartIncidentInput) SetRelatedItems(v []*RelatedItem) *StartIncidentInput {
	s.RelatedItems = v
	return s
}

// SetResponsePlanArn sets the ResponsePlanArn field's value.
func (s *StartIncidentInput) SetResponsePlanArn(v string) *StartIncidentInput {
	s.ResponsePlanArn = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *StartIncidentInput) SetTitle(v string) *StartIncidentInput {
	s.Title = &v
	return s
}

// SetTriggerDetails sets the TriggerDetails field's value.
func (s *StartIncidentInput) SetTriggerDetails(v *TriggerDetails) *StartIncidentInput {
	s.TriggerDetails = v
	return s
}

type StartIncidentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created incident record.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIncidentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIncidentOutput) GoString() string {
	return s.String()
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *StartIncidentOutput) SetIncidentRecordArn(v string) *StartIncidentOutput {
	s.IncidentRecordArn = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the response plan you're adding the tags
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of tags to add to the response plan.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Originating quota code
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// Originating service code
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true" enum:"ServiceCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A significant event that happened during the incident.
type TimelineEvent struct {
	_ struct{} `type:"structure"`

	// A short description of the event.
	//
	// EventData is a required field
	EventData *string `locationName:"eventData" type:"string" required:"true"`

	// The ID of the timeline event.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// A list of references in a TimelineEvent.
	EventReferences []*EventReference `locationName:"eventReferences" type:"list"`

	// The timestamp for when the event occurred.
	//
	// EventTime is a required field
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" required:"true"`

	// The type of event that occurred. Currently Incident Manager supports only
	// the Custom Event and Note types.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true"`

	// The timestamp for when the timeline event was last updated.
	//
	// EventUpdatedTime is a required field
	EventUpdatedTime *time.Time `locationName:"eventUpdatedTime" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the incident that the event occurred during.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimelineEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimelineEvent) GoString() string {
	return s.String()
}

// SetEventData sets the EventData field's value.
func (s *TimelineEvent) SetEventData(v string) *TimelineEvent {
	s.EventData = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *TimelineEvent) SetEventId(v string) *TimelineEvent {
	s.EventId = &v
	return s
}

// SetEventReferences sets the EventReferences field's value.
func (s *TimelineEvent) SetEventReferences(v []*EventReference) *TimelineEvent {
	s.EventReferences = v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *TimelineEvent) SetEventTime(v time.Time) *TimelineEvent {
	s.EventTime = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *TimelineEvent) SetEventType(v string) *TimelineEvent {
	s.EventType = &v
	return s
}

// SetEventUpdatedTime sets the EventUpdatedTime field's value.
func (s *TimelineEvent) SetEventUpdatedTime(v time.Time) *TimelineEvent {
	s.EventUpdatedTime = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *TimelineEvent) SetIncidentRecordArn(v string) *TimelineEvent {
	s.IncidentRecordArn = &v
	return s
}

// Details about what caused the incident to be created in Incident Manager.
type TriggerDetails struct {
	_ struct{} `type:"structure"`

	// Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident
	// Manager when an incident is created.
	RawData *string `locationName:"rawData" type:"string"`

	// Identifies the service that sourced the event. All events sourced from within
	// Amazon Web Services begin with "aws." Customer-generated events can have
	// any value here, as long as it doesn't begin with "aws." We recommend the
	// use of Java package-name style reverse domain-name strings.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The timestamp for when the incident was detected.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the source that detected the incident.
	TriggerArn *string `locationName:"triggerArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TriggerDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerDetails"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRawData sets the RawData field's value.
func (s *TriggerDetails) SetRawData(v string) *TriggerDetails {
	s.RawData = &v
	return s
}

// SetSource sets the Source field's value.
func (s *TriggerDetails) SetSource(v string) *TriggerDetails {
	s.Source = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TriggerDetails) SetTimestamp(v time.Time) *TriggerDetails {
	s.Timestamp = &v
	return s
}

// SetTriggerArn sets the TriggerArn field's value.
func (s *TriggerDetails) SetTriggerArn(v string) *TriggerDetails {
	s.TriggerArn = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the response plan you're removing a tag
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The name of the tag to remove from the response plan.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDeletionProtectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication set to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A token that ensures that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies if deletion protection is turned on or off in your account.
	//
	// DeletionProtected is a required field
	DeletionProtected *bool `locationName:"deletionProtected" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeletionProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeletionProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeletionProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeletionProtectionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DeletionProtected == nil {
		invalidParams.Add(request.NewErrParamRequired("DeletionProtected"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateDeletionProtectionInput) SetArn(v string) *UpdateDeletionProtectionInput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDeletionProtectionInput) SetClientToken(v string) *UpdateDeletionProtectionInput {
	s.ClientToken = &v
	return s
}

// SetDeletionProtected sets the DeletionProtected field's value.
func (s *UpdateDeletionProtectionInput) SetDeletionProtected(v bool) *UpdateDeletionProtectionInput {
	s.DeletionProtected = &v
	return s
}

type UpdateDeletionProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeletionProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeletionProtectionOutput) GoString() string {
	return s.String()
}

type UpdateIncidentRecordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident record you are updating.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Chatbot chat channel where responders can collaborate.
	ChatChannel *ChatChannel `locationName:"chatChannel" type:"structure"`

	// A token that ensures that a client calls the operation only once with the
	// specified details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Defines the impact of the incident to customers and applications. If you
	// provide an impact for an incident, it overwrites the impact provided by the
	// response plan.
	//
	// Supported impact codes
	//
	//    * 1 - Critical
	//
	//    * 2 - High
	//
	//    * 3 - Medium
	//
	//    * 4 - Low
	//
	//    * 5 - No Impact
	Impact *int64 `locationName:"impact" min:"1" type:"integer"`

	// The Amazon SNS targets that Incident Manager notifies when a client updates
	// an incident.
	//
	// Using multiple SNS topics creates redundancy in the event that a Region is
	// down during the incident.
	NotificationTargets []*NotificationTargetItem `locationName:"notificationTargets" type:"list"`

	// The status of the incident. Possible statuses are Open or Resolved.
	Status *string `locationName:"status" type:"string" enum:"IncidentRecordStatus"`

	// A longer description of what occurred during the incident.
	Summary *string `locationName:"summary" type:"string"`

	// A brief description of the incident.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIncidentRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIncidentRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIncidentRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIncidentRecordInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Impact != nil && *s.Impact < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Impact", 1))
	}
	if s.ChatChannel != nil {
		if err := s.ChatChannel.Validate(); err != nil {
			invalidParams.AddNested("ChatChannel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateIncidentRecordInput) SetArn(v string) *UpdateIncidentRecordInput {
	s.Arn = &v
	return s
}

// SetChatChannel sets the ChatChannel field's value.
func (s *UpdateIncidentRecordInput) SetChatChannel(v *ChatChannel) *UpdateIncidentRecordInput {
	s.ChatChannel = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateIncidentRecordInput) SetClientToken(v string) *UpdateIncidentRecordInput {
	s.ClientToken = &v
	return s
}

// SetImpact sets the Impact field's value.
func (s *UpdateIncidentRecordInput) SetImpact(v int64) *UpdateIncidentRecordInput {
	s.Impact = &v
	return s
}

// SetNotificationTargets sets the NotificationTargets field's value.
func (s *UpdateIncidentRecordInput) SetNotificationTargets(v []*NotificationTargetItem) *UpdateIncidentRecordInput {
	s.NotificationTargets = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateIncidentRecordInput) SetStatus(v string) *UpdateIncidentRecordInput {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *UpdateIncidentRecordInput) SetSummary(v string) *UpdateIncidentRecordInput {
	s.Summary = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateIncidentRecordInput) SetTitle(v string) *UpdateIncidentRecordInput {
	s.Title = &v
	return s
}

type UpdateIncidentRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIncidentRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIncidentRecordOutput) GoString() string {
	return s.String()
}

type UpdateRelatedItemsInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures that a client calls the operation only once with the
	// specified details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the incident record that contains the related
	// items that you update.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`

	// Details about the item that you are add to, or delete from, an incident.
	//
	// RelatedItemsUpdate is a required field
	RelatedItemsUpdate *RelatedItemsUpdate `locationName:"relatedItemsUpdate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelatedItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelatedItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRelatedItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRelatedItemsInput"}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}
	if s.RelatedItemsUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("RelatedItemsUpdate"))
	}
	if s.RelatedItemsUpdate != nil {
		if err := s.RelatedItemsUpdate.Validate(); err != nil {
			invalidParams.AddNested("RelatedItemsUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateRelatedItemsInput) SetClientToken(v string) *UpdateRelatedItemsInput {
	s.ClientToken = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *UpdateRelatedItemsInput) SetIncidentRecordArn(v string) *UpdateRelatedItemsInput {
	s.IncidentRecordArn = &v
	return s
}

// SetRelatedItemsUpdate sets the RelatedItemsUpdate field's value.
func (s *UpdateRelatedItemsInput) SetRelatedItemsUpdate(v *RelatedItemsUpdate) *UpdateRelatedItemsInput {
	s.RelatedItemsUpdate = v
	return s
}

type UpdateRelatedItemsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelatedItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelatedItemsOutput) GoString() string {
	return s.String()
}

// Details used when updating the replication set.
type UpdateReplicationSetAction struct {
	_ struct{} `type:"structure"`

	// Details about the Amazon Web Services Region that you're adding to the replication
	// set.
	AddRegionAction *AddRegionAction `locationName:"addRegionAction" type:"structure"`

	// Details about the Amazon Web Services Region that you're deleting to the
	// replication set.
	DeleteRegionAction *DeleteRegionAction `locationName:"deleteRegionAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationSetAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationSetAction"}
	if s.AddRegionAction != nil {
		if err := s.AddRegionAction.Validate(); err != nil {
			invalidParams.AddNested("AddRegionAction", err.(request.ErrInvalidParams))
		}
	}
	if s.DeleteRegionAction != nil {
		if err := s.DeleteRegionAction.Validate(); err != nil {
			invalidParams.AddNested("DeleteRegionAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddRegionAction sets the AddRegionAction field's value.
func (s *UpdateReplicationSetAction) SetAddRegionAction(v *AddRegionAction) *UpdateReplicationSetAction {
	s.AddRegionAction = v
	return s
}

// SetDeleteRegionAction sets the DeleteRegionAction field's value.
func (s *UpdateReplicationSetAction) SetDeleteRegionAction(v *DeleteRegionAction) *UpdateReplicationSetAction {
	s.DeleteRegionAction = v
	return s
}

type UpdateReplicationSetInput struct {
	_ struct{} `type:"structure"`

	// An action to add or delete a Region.
	//
	// Actions is a required field
	Actions []*UpdateReplicationSetAction `locationName:"actions" min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the replication set you're updating.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A token that ensures that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationSetInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateReplicationSetInput) SetActions(v []*UpdateReplicationSetAction) *UpdateReplicationSetInput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateReplicationSetInput) SetArn(v string) *UpdateReplicationSetInput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateReplicationSetInput) SetClientToken(v string) *UpdateReplicationSetInput {
	s.ClientToken = &v
	return s
}

type UpdateReplicationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationSetOutput) GoString() string {
	return s.String()
}

type UpdateResponsePlanInput struct {
	_ struct{} `type:"structure"`

	// The actions that this response plan takes at the beginning of an incident.
	Actions []*Action `locationName:"actions" type:"list"`

	// The Amazon Resource Name (ARN) of the response plan.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Chatbot chat channel used for collaboration during an incident.
	//
	// Use the empty structure to remove the chat channel from the response plan.
	ChatChannel *ChatChannel `locationName:"chatChannel" type:"structure"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The long format name of the response plan. The display name can't contain
	// spaces.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The Amazon Resource Name (ARN) for the contacts and escalation plans that
	// the response plan engages during an incident.
	Engagements []*string `locationName:"engagements" type:"list"`

	// The string Incident Manager uses to prevent duplicate incidents from being
	// created by the same incident in the same account.
	IncidentTemplateDedupeString *string `locationName:"incidentTemplateDedupeString" type:"string"`

	// Defines the impact to the customers. Providing an impact overwrites the impact
	// provided by a response plan.
	//
	// Supported impact codes
	//
	//    * 1 - Critical
	//
	//    * 2 - High
	//
	//    * 3 - Medium
	//
	//    * 4 - Low
	//
	//    * 5 - No Impact
	IncidentTemplateImpact *int64 `locationName:"incidentTemplateImpact" min:"1" type:"integer"`

	// The Amazon SNS targets that are notified when updates are made to an incident.
	IncidentTemplateNotificationTargets []*NotificationTargetItem `locationName:"incidentTemplateNotificationTargets" type:"list"`

	// A brief summary of the incident. This typically contains what has happened,
	// what's currently happening, and next steps.
	IncidentTemplateSummary *string `locationName:"incidentTemplateSummary" type:"string"`

	// Tags to assign to the template. When the StartIncident API action is called,
	// Incident Manager assigns the tags specified in the template to the incident.
	// To call this action, you must also have permission to call the TagResource
	// API action for the incident record resource.
	IncidentTemplateTags map[string]*string `locationName:"incidentTemplateTags" type:"map"`

	// The short format name of the incident. The title can't contain spaces.
	IncidentTemplateTitle *string `locationName:"incidentTemplateTitle" type:"string"`

	// Information about third-party services integrated into the response plan.
	Integrations []*Integration `locationName:"integrations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResponsePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResponsePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResponsePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResponsePlanInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.IncidentTemplateImpact != nil && *s.IncidentTemplateImpact < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IncidentTemplateImpact", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChatChannel != nil {
		if err := s.ChatChannel.Validate(); err != nil {
			invalidParams.AddNested("ChatChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Integrations != nil {
		for i, v := range s.Integrations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Integrations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateResponsePlanInput) SetActions(v []*Action) *UpdateResponsePlanInput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateResponsePlanInput) SetArn(v string) *UpdateResponsePlanInput {
	s.Arn = &v
	return s
}

// SetChatChannel sets the ChatChannel field's value.
func (s *UpdateResponsePlanInput) SetChatChannel(v *ChatChannel) *UpdateResponsePlanInput {
	s.ChatChannel = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResponsePlanInput) SetClientToken(v string) *UpdateResponsePlanInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateResponsePlanInput) SetDisplayName(v string) *UpdateResponsePlanInput {
	s.DisplayName = &v
	return s
}

// SetEngagements sets the Engagements field's value.
func (s *UpdateResponsePlanInput) SetEngagements(v []*string) *UpdateResponsePlanInput {
	s.Engagements = v
	return s
}

// SetIncidentTemplateDedupeString sets the IncidentTemplateDedupeString field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateDedupeString(v string) *UpdateResponsePlanInput {
	s.IncidentTemplateDedupeString = &v
	return s
}

// SetIncidentTemplateImpact sets the IncidentTemplateImpact field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateImpact(v int64) *UpdateResponsePlanInput {
	s.IncidentTemplateImpact = &v
	return s
}

// SetIncidentTemplateNotificationTargets sets the IncidentTemplateNotificationTargets field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateNotificationTargets(v []*NotificationTargetItem) *UpdateResponsePlanInput {
	s.IncidentTemplateNotificationTargets = v
	return s
}

// SetIncidentTemplateSummary sets the IncidentTemplateSummary field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateSummary(v string) *UpdateResponsePlanInput {
	s.IncidentTemplateSummary = &v
	return s
}

// SetIncidentTemplateTags sets the IncidentTemplateTags field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateTags(v map[string]*string) *UpdateResponsePlanInput {
	s.IncidentTemplateTags = v
	return s
}

// SetIncidentTemplateTitle sets the IncidentTemplateTitle field's value.
func (s *UpdateResponsePlanInput) SetIncidentTemplateTitle(v string) *UpdateResponsePlanInput {
	s.IncidentTemplateTitle = &v
	return s
}

// SetIntegrations sets the Integrations field's value.
func (s *UpdateResponsePlanInput) SetIntegrations(v []*Integration) *UpdateResponsePlanInput {
	s.Integrations = v
	return s
}

type UpdateResponsePlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResponsePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResponsePlanOutput) GoString() string {
	return s.String()
}

type UpdateTimelineEventInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures that a client calls the operation only once with the
	// specified details.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A short description of the event.
	EventData *string `locationName:"eventData" type:"string"`

	// The ID of the event to update. You can use ListTimelineEvents to find an
	// event's ID.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// Updates all existing references in a TimelineEvent. A reference is an Amazon
	// Web Services resource involved or associated with the incident. To specify
	// a reference, enter its Amazon Resource Name (ARN). You can also specify a
	// related item associated with that resource. For example, to specify an Amazon
	// DynamoDB (DynamoDB) table as a resource, use its ARN. You can also specify
	// an Amazon CloudWatch metric associated with the DynamoDB table as a related
	// item.
	//
	// This update action overrides all existing references. If you want to keep
	// existing references, you must specify them in the call. If you don't, this
	// action removes any existing references and enters only new references.
	EventReferences []*EventReference `locationName:"eventReferences" type:"list"`

	// The timestamp for when the event occurred.
	EventTime *time.Time `locationName:"eventTime" type:"timestamp"`

	// The type of event. You can update events of type Custom Event and Note.
	EventType *string `locationName:"eventType" type:"string"`

	// The Amazon Resource Name (ARN) of the incident that includes the timeline
	// event.
	//
	// IncidentRecordArn is a required field
	IncidentRecordArn *string `locationName:"incidentRecordArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTimelineEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTimelineEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTimelineEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTimelineEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.IncidentRecordArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IncidentRecordArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateTimelineEventInput) SetClientToken(v string) *UpdateTimelineEventInput {
	s.ClientToken = &v
	return s
}

// SetEventData sets the EventData field's value.
func (s *UpdateTimelineEventInput) SetEventData(v string) *UpdateTimelineEventInput {
	s.EventData = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *UpdateTimelineEventInput) SetEventId(v string) *UpdateTimelineEventInput {
	s.EventId = &v
	return s
}

// SetEventReferences sets the EventReferences field's value.
func (s *UpdateTimelineEventInput) SetEventReferences(v []*EventReference) *UpdateTimelineEventInput {
	s.EventReferences = v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *UpdateTimelineEventInput) SetEventTime(v time.Time) *UpdateTimelineEventInput {
	s.EventTime = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *UpdateTimelineEventInput) SetEventType(v string) *UpdateTimelineEventInput {
	s.EventType = &v
	return s
}

// SetIncidentRecordArn sets the IncidentRecordArn field's value.
func (s *UpdateTimelineEventInput) SetIncidentRecordArn(v string) *UpdateTimelineEventInput {
	s.IncidentRecordArn = &v
	return s
}

type UpdateTimelineEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTimelineEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTimelineEventOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// IncidentRecordStatusOpen is a IncidentRecordStatus enum value
	IncidentRecordStatusOpen = "OPEN"

	// IncidentRecordStatusResolved is a IncidentRecordStatus enum value
	IncidentRecordStatusResolved = "RESOLVED"
)

// IncidentRecordStatus_Values returns all elements of the IncidentRecordStatus enum
func IncidentRecordStatus_Values() []string {
	return []string{
		IncidentRecordStatusOpen,
		IncidentRecordStatusResolved,
	}
}

const (
	// ItemTypeAnalysis is a ItemType enum value
	ItemTypeAnalysis = "ANALYSIS"

	// ItemTypeIncident is a ItemType enum value
	ItemTypeIncident = "INCIDENT"

	// ItemTypeMetric is a ItemType enum value
	ItemTypeMetric = "METRIC"

	// ItemTypeParent is a ItemType enum value
	ItemTypeParent = "PARENT"

	// ItemTypeAttachment is a ItemType enum value
	ItemTypeAttachment = "ATTACHMENT"

	// ItemTypeOther is a ItemType enum value
	ItemTypeOther = "OTHER"

	// ItemTypeAutomation is a ItemType enum value
	ItemTypeAutomation = "AUTOMATION"

	// ItemTypeInvolvedResource is a ItemType enum value
	ItemTypeInvolvedResource = "INVOLVED_RESOURCE"

	// ItemTypeTask is a ItemType enum value
	ItemTypeTask = "TASK"
)

// ItemType_Values returns all elements of the ItemType enum
func ItemType_Values() []string {
	return []string{
		ItemTypeAnalysis,
		ItemTypeIncident,
		ItemTypeMetric,
		ItemTypeParent,
		ItemTypeAttachment,
		ItemTypeOther,
		ItemTypeAutomation,
		ItemTypeInvolvedResource,
		ItemTypeTask,
	}
}

const (
	// RegionStatusActive is a RegionStatus enum value
	RegionStatusActive = "ACTIVE"

	// RegionStatusCreating is a RegionStatus enum value
	RegionStatusCreating = "CREATING"

	// RegionStatusDeleting is a RegionStatus enum value
	RegionStatusDeleting = "DELETING"

	// RegionStatusFailed is a RegionStatus enum value
	RegionStatusFailed = "FAILED"
)

// RegionStatus_Values returns all elements of the RegionStatus enum
func RegionStatus_Values() []string {
	return []string{
		RegionStatusActive,
		RegionStatusCreating,
		RegionStatusDeleting,
		RegionStatusFailed,
	}
}

const (
	// ReplicationSetStatusActive is a ReplicationSetStatus enum value
	ReplicationSetStatusActive = "ACTIVE"

	// ReplicationSetStatusCreating is a ReplicationSetStatus enum value
	ReplicationSetStatusCreating = "CREATING"

	// ReplicationSetStatusUpdating is a ReplicationSetStatus enum value
	ReplicationSetStatusUpdating = "UPDATING"

	// ReplicationSetStatusDeleting is a ReplicationSetStatus enum value
	ReplicationSetStatusDeleting = "DELETING"

	// ReplicationSetStatusFailed is a ReplicationSetStatus enum value
	ReplicationSetStatusFailed = "FAILED"
)

// ReplicationSetStatus_Values returns all elements of the ReplicationSetStatus enum
func ReplicationSetStatus_Values() []string {
	return []string{
		ReplicationSetStatusActive,
		ReplicationSetStatusCreating,
		ReplicationSetStatusUpdating,
		ReplicationSetStatusDeleting,
		ReplicationSetStatusFailed,
	}
}

const (
	// ResourceTypeResponsePlan is a ResourceType enum value
	ResourceTypeResponsePlan = "RESPONSE_PLAN"

	// ResourceTypeIncidentRecord is a ResourceType enum value
	ResourceTypeIncidentRecord = "INCIDENT_RECORD"

	// ResourceTypeTimelineEvent is a ResourceType enum value
	ResourceTypeTimelineEvent = "TIMELINE_EVENT"

	// ResourceTypeReplicationSet is a ResourceType enum value
	ResourceTypeReplicationSet = "REPLICATION_SET"

	// ResourceTypeResourcePolicy is a ResourceType enum value
	ResourceTypeResourcePolicy = "RESOURCE_POLICY"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeResponsePlan,
		ResourceTypeIncidentRecord,
		ResourceTypeTimelineEvent,
		ResourceTypeReplicationSet,
		ResourceTypeResourcePolicy,
	}
}

const (
	// ServiceCodeSsmIncidents is a ServiceCode enum value
	ServiceCodeSsmIncidents = "ssm-incidents"
)

// ServiceCode_Values returns all elements of the ServiceCode enum
func ServiceCode_Values() []string {
	return []string{
		ServiceCodeSsmIncidents,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// SsmTargetAccountResponsePlanOwnerAccount is a SsmTargetAccount enum value
	SsmTargetAccountResponsePlanOwnerAccount = "RESPONSE_PLAN_OWNER_ACCOUNT"

	// SsmTargetAccountImpactedAccount is a SsmTargetAccount enum value
	SsmTargetAccountImpactedAccount = "IMPACTED_ACCOUNT"
)

// SsmTargetAccount_Values returns all elements of the SsmTargetAccount enum
func SsmTargetAccount_Values() []string {
	return []string{
		SsmTargetAccountResponsePlanOwnerAccount,
		SsmTargetAccountImpactedAccount,
	}
}

const (
	// TimelineEventSortEventTime is a TimelineEventSort enum value
	TimelineEventSortEventTime = "EVENT_TIME"
)

// TimelineEventSort_Values returns all elements of the TimelineEventSort enum
func TimelineEventSort_Values() []string {
	return []string{
		TimelineEventSortEventTime,
	}
}

const (
	// VariableTypeIncidentRecordArn is a VariableType enum value
	VariableTypeIncidentRecordArn = "INCIDENT_RECORD_ARN"

	// VariableTypeInvolvedResources is a VariableType enum value
	VariableTypeInvolvedResources = "INVOLVED_RESOURCES"
)

// VariableType_Values returns all elements of the VariableType enum
func VariableType_Values() []string {
	return []string{
		VariableTypeIncidentRecordArn,
		VariableTypeInvolvedResources,
	}
}
