//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// ********************** Attributes ***********************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfontattributename?language=objc)
    pub static NSFontAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsparagraphstyleattributename?language=objc)
    pub static NSParagraphStyleAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsforegroundcolorattributename?language=objc)
    pub static NSForegroundColorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundcolorattributename?language=objc)
    pub static NSBackgroundColorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsligatureattributename?language=objc)
    pub static NSLigatureAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskernattributename?language=objc)
    pub static NSKernAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstrackingattributename?language=objc)
    pub static NSTrackingAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstrikethroughstyleattributename?language=objc)
    pub static NSStrikethroughStyleAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinestyleattributename?language=objc)
    pub static NSUnderlineStyleAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstrokecolorattributename?language=objc)
    pub static NSStrokeColorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstrokewidthattributename?language=objc)
    pub static NSStrokeWidthAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsshadowattributename?language=objc)
    pub static NSShadowAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexteffectattributename?language=objc)
    pub static NSTextEffectAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsattachmentattributename?language=objc)
    pub static NSAttachmentAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nslinkattributename?language=objc)
    pub static NSLinkAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbaselineoffsetattributename?language=objc)
    pub static NSBaselineOffsetAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinecolorattributename?language=objc)
    pub static NSUnderlineColorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstrikethroughcolorattributename?language=objc)
    pub static NSStrikethroughColorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswritingdirectionattributename?language=objc)
    pub static NSWritingDirectionAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightstyleattributename?language=objc)
    pub static NSTextHighlightStyleAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemeattributename?language=objc)
    pub static NSTextHighlightColorSchemeAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsadaptiveimageglyphattributename?language=objc)
    pub static NSAdaptiveImageGlyphAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswritingtoolsexclusionattributename?language=objc)
    pub static NSWritingToolsExclusionAttributeName: &'static NSAttributedStringKey;
}

/// ********************** Attribute values ***********************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinestyle?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSUnderlineStyle(pub NSInteger);
bitflags::bitflags! {
    impl NSUnderlineStyle: NSInteger {
        #[doc(alias = "NSUnderlineStyleNone")]
        const None = 0x00;
        #[doc(alias = "NSUnderlineStyleSingle")]
        const Single = 0x01;
        #[doc(alias = "NSUnderlineStyleThick")]
        const Thick = 0x02;
        #[doc(alias = "NSUnderlineStyleDouble")]
        const Double = 0x09;
        #[doc(alias = "NSUnderlineStylePatternSolid")]
        const PatternSolid = 0x0000;
        #[doc(alias = "NSUnderlineStylePatternDot")]
        const PatternDot = 0x0100;
        #[doc(alias = "NSUnderlineStylePatternDash")]
        const PatternDash = 0x0200;
        #[doc(alias = "NSUnderlineStylePatternDashDot")]
        const PatternDashDot = 0x0300;
        #[doc(alias = "NSUnderlineStylePatternDashDotDot")]
        const PatternDashDotDot = 0x0400;
        #[doc(alias = "NSUnderlineStyleByWord")]
        const ByWord = 0x8000;
    }
}

unsafe impl Encode for NSUnderlineStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSUnderlineStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswritingdirectionformattype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWritingDirectionFormatType(pub NSInteger);
impl NSWritingDirectionFormatType {
    #[doc(alias = "NSWritingDirectionEmbedding")]
    pub const Embedding: Self = Self(0 << 1);
    #[doc(alias = "NSWritingDirectionOverride")]
    pub const Override: Self = Self(1 << 1);
}

unsafe impl Encode for NSWritingDirectionFormatType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWritingDirectionFormatType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexteffectstyle?language=objc)
// NS_TYPED_ENUM
pub type NSTextEffectStyle = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexteffectletterpressstyle?language=objc)
    pub static NSTextEffectLetterpressStyle: &'static NSTextEffectStyle;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightstyle?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSTextHighlightStyle = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightstyledefault?language=objc)
    pub static NSTextHighlightStyleDefault: &'static NSTextHighlightStyle;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorscheme?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSTextHighlightColorScheme = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemedefault?language=objc)
    pub static NSTextHighlightColorSchemeDefault: &'static NSTextHighlightColorScheme;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemepurple?language=objc)
    pub static NSTextHighlightColorSchemePurple: &'static NSTextHighlightColorScheme;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemepink?language=objc)
    pub static NSTextHighlightColorSchemePink: &'static NSTextHighlightColorScheme;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemeorange?language=objc)
    pub static NSTextHighlightColorSchemeOrange: &'static NSTextHighlightColorScheme;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschememint?language=objc)
    pub static NSTextHighlightColorSchemeMint: &'static NSTextHighlightColorScheme;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexthighlightcolorschemeblue?language=objc)
    pub static NSTextHighlightColorSchemeBlue: &'static NSTextHighlightColorScheme;
}

mod private_NSAttributedStringAttributeFixing {
    pub trait Sealed {}
}

/// Category on [`NSMutableAttributedString`].
///
/// ********************** Attribute fixing ***********************
pub unsafe trait NSAttributedStringAttributeFixing:
    ClassType + Sized + private_NSAttributedStringAttributeFixing::Sealed
{
    extern_methods!(
        #[unsafe(method(fixAttributesInRange:))]
        #[unsafe(method_family = none)]
        fn fixAttributesInRange(&self, range: NSRange);
    );
}

impl private_NSAttributedStringAttributeFixing::Sealed for NSMutableAttributedString {}
unsafe impl NSAttributedStringAttributeFixing for NSMutableAttributedString {}

/// ********************** Document formats ***********************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsattributedstringdocumenttype?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSAttributedStringDocumentType = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsplaintextdocumenttype?language=objc)
    pub static NSPlainTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrtftextdocumenttype?language=objc)
    pub static NSRTFTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrtfdtextdocumenttype?language=objc)
    pub static NSRTFDTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshtmltextdocumenttype?language=objc)
    pub static NSHTMLTextDocumentType: &'static NSAttributedStringDocumentType;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextlayoutsectionkey?language=objc)
// NS_TYPED_ENUM
pub type NSTextLayoutSectionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextlayoutsectionorientation?language=objc)
    pub static NSTextLayoutSectionOrientation: &'static NSTextLayoutSectionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextlayoutsectionrange?language=objc)
    pub static NSTextLayoutSectionRange: &'static NSTextLayoutSectionKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextscalingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTextScalingType(pub NSInteger);
impl NSTextScalingType {
    #[doc(alias = "NSTextScalingStandard")]
    pub const ScalingStandard: Self = Self(0);
    #[doc(alias = "NSTextScalingiOS")]
    pub const ScalingiOS: Self = Self(1);
}

unsafe impl Encode for NSTextScalingType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTextScalingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsattributedstringdocumentattributekey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSAttributedStringDocumentAttributeKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocumenttypedocumentattribute?language=objc)
    pub static NSDocumentTypeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscharacterencodingdocumentattribute?language=objc)
    pub static NSCharacterEncodingDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefaultattributesdocumentattribute?language=objc)
    pub static NSDefaultAttributesDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspapersizedocumentattribute?language=objc)
    pub static NSPaperSizeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewsizedocumentattribute?language=objc)
    pub static NSViewSizeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewzoomdocumentattribute?language=objc)
    pub static NSViewZoomDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewmodedocumentattribute?language=objc)
    pub static NSViewModeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefaultfontexcludeddocumentattribute?language=objc)
    pub static NSDefaultFontExcludedDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsreadonlydocumentattribute?language=objc)
    pub static NSReadOnlyDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundcolordocumentattribute?language=objc)
    pub static NSBackgroundColorDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshyphenationfactordocumentattribute?language=objc)
    pub static NSHyphenationFactorDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefaulttabintervaldocumentattribute?language=objc)
    pub static NSDefaultTabIntervalDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextlayoutsectionsattribute?language=objc)
    pub static NSTextLayoutSectionsAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextscalingdocumentattribute?language=objc)
    pub static NSTextScalingDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssourcetextscalingdocumentattribute?language=objc)
    pub static NSSourceTextScalingDocumentAttribute:
        &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscocoaversiondocumentattribute?language=objc)
    pub static NSCocoaVersionDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsattributedstringdocumentreadingoptionkey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSAttributedStringDocumentReadingOptionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocumenttypedocumentoption?language=objc)
    pub static NSDocumentTypeDocumentOption: &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefaultattributesdocumentoption?language=objc)
    pub static NSDefaultAttributesDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscharacterencodingdocumentoption?language=objc)
    pub static NSCharacterEncodingDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstargettextscalingdocumentoption?language=objc)
    pub static NSTargetTextScalingDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssourcetextscalingdocumentoption?language=objc)
    pub static NSSourceTextScalingDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextkit1listmarkerformatdocumentoption?language=objc)
    pub static NSTextKit1ListMarkerFormatDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

mod private_NSAttributedStringDocumentFormats {
    pub trait Sealed {}
}

/// Category on [`NSAttributedString`].
pub unsafe trait NSAttributedStringDocumentFormats:
    ClassType + Sized + private_NSAttributedStringDocumentFormats::Sealed
{
    extern_methods!(
        /// # Safety
        ///
        /// - `options` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(initWithURL:options:documentAttributes:error:_))]
        #[unsafe(method_family = init)]
        unsafe fn initWithURL_options_documentAttributes_error(
            this: Allocated<Self>,
            url: &NSURL,
            options: &NSDictionary<NSAttributedStringDocumentReadingOptionKey, AnyObject>,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        /// # Safety
        ///
        /// - `options` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(initWithData:options:documentAttributes:error:_))]
        #[unsafe(method_family = init)]
        unsafe fn initWithData_options_documentAttributes_error(
            this: Allocated<Self>,
            data: &NSData,
            options: &NSDictionary<NSAttributedStringDocumentReadingOptionKey, AnyObject>,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(dataFromRange:documentAttributes:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn dataFromRange_documentAttributes_error(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(fileWrapperFromRange:documentAttributes:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn fileWrapperFromRange_documentAttributes_error(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Result<Retained<NSFileWrapper>, Retained<NSError>>;
    );
}

impl private_NSAttributedStringDocumentFormats::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringDocumentFormats for NSAttributedString {}

mod private_NSMutableAttributedStringDocumentFormats {
    pub trait Sealed {}
}

/// Category on [`NSMutableAttributedString`].
pub unsafe trait NSMutableAttributedStringDocumentFormats:
    ClassType + Sized + private_NSMutableAttributedStringDocumentFormats::Sealed
{
    extern_methods!(
        /// # Safety
        ///
        /// - `opts` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(readFromURL:options:documentAttributes:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn readFromURL_options_documentAttributes_error(
            &self,
            url: &NSURL,
            opts: &NSDictionary<NSAttributedStringDocumentReadingOptionKey, AnyObject>,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Result<(), Retained<NSError>>;

        /// # Safety
        ///
        /// - `opts` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(readFromData:options:documentAttributes:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn readFromData_options_documentAttributes_error(
            &self,
            data: &NSData,
            opts: &NSDictionary<NSAttributedStringDocumentReadingOptionKey, AnyObject>,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Result<(), Retained<NSError>>;
    );
}

impl private_NSMutableAttributedStringDocumentFormats::Sealed for NSMutableAttributedString {}
unsafe impl NSMutableAttributedStringDocumentFormats for NSMutableAttributedString {}

mod private_NSAttributedStringKitAdditions {
    pub trait Sealed {}
}

/// Category on [`NSAttributedString`].
///
/// ********************** Misc methods ***********************
pub unsafe trait NSAttributedStringKitAdditions:
    ClassType + Sized + private_NSAttributedStringKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(containsAttachmentsInRange:))]
        #[unsafe(method_family = none)]
        fn containsAttachmentsInRange(&self, range: NSRange) -> bool;

        #[unsafe(method(prefersRTFDInRange:))]
        #[unsafe(method_family = none)]
        fn prefersRTFDInRange(&self, range: NSRange) -> bool;
    );
}

impl private_NSAttributedStringKitAdditions::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringKitAdditions for NSAttributedString {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorattributename?language=objc)
    pub static NSCursorAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstooltipattributename?language=objc)
    pub static NSToolTipAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmarkedclausesegmentattributename?language=objc)
    pub static NSMarkedClauseSegmentAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextalternativesattributename?language=objc)
    pub static NSTextAlternativesAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsspellingstateattributename?language=objc)
    pub static NSSpellingStateAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssuperscriptattributename?language=objc)
    pub static NSSuperscriptAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsglyphinfoattributename?language=objc)
    pub static NSGlyphInfoAttributeName: &'static NSAttributedStringKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsspellingstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSpellingState(pub NSInteger);
impl NSSpellingState {
    #[doc(alias = "NSSpellingStateSpellingFlag")]
    pub const SpellingFlag: Self = Self(1 << 0);
    #[doc(alias = "NSSpellingStateGrammarFlag")]
    pub const GrammarFlag: Self = Self(1 << 1);
}

unsafe impl Encode for NSSpellingState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSSpellingState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

mod private_NSAttributedStringAppKitAttributeFixing {
    pub trait Sealed {}
}

/// Category on [`NSMutableAttributedString`].
///
/// ********************** Attribute fixing ***********************
pub unsafe trait NSAttributedStringAppKitAttributeFixing:
    ClassType + Sized + private_NSAttributedStringAppKitAttributeFixing::Sealed
{
    extern_methods!(
        #[unsafe(method(fixFontAttributeInRange:))]
        #[unsafe(method_family = none)]
        fn fixFontAttributeInRange(&self, range: NSRange);

        #[unsafe(method(fixParagraphStyleAttributeInRange:))]
        #[unsafe(method_family = none)]
        fn fixParagraphStyleAttributeInRange(&self, range: NSRange);

        #[unsafe(method(fixAttachmentAttributeInRange:))]
        #[unsafe(method_family = none)]
        fn fixAttachmentAttributeInRange(&self, range: NSRange);
    );
}

impl private_NSAttributedStringAppKitAttributeFixing::Sealed for NSMutableAttributedString {}
unsafe impl NSAttributedStringAppKitAttributeFixing for NSMutableAttributedString {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmacsimpletextdocumenttype?language=objc)
    pub static NSMacSimpleTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdocformattextdocumenttype?language=objc)
    pub static NSDocFormatTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswordmltextdocumenttype?language=objc)
    pub static NSWordMLTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswebarchivetextdocumenttype?language=objc)
    pub static NSWebArchiveTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsofficeopenxmltextdocumenttype?language=objc)
    pub static NSOfficeOpenXMLTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsopendocumenttextdocumenttype?language=objc)
    pub static NSOpenDocumentTextDocumentType: &'static NSAttributedStringDocumentType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsconverteddocumentattribute?language=objc)
    pub static NSConvertedDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfiletypedocumentattribute?language=objc)
    pub static NSFileTypeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstitledocumentattribute?language=objc)
    pub static NSTitleDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscompanydocumentattribute?language=objc)
    pub static NSCompanyDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscopyrightdocumentattribute?language=objc)
    pub static NSCopyrightDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssubjectdocumentattribute?language=objc)
    pub static NSSubjectDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsauthordocumentattribute?language=objc)
    pub static NSAuthorDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nskeywordsdocumentattribute?language=objc)
    pub static NSKeywordsDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscommentdocumentattribute?language=objc)
    pub static NSCommentDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nseditordocumentattribute?language=objc)
    pub static NSEditorDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscreationtimedocumentattribute?language=objc)
    pub static NSCreationTimeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmodificationtimedocumentattribute?language=objc)
    pub static NSModificationTimeDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmanagerdocumentattribute?language=objc)
    pub static NSManagerDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscategorydocumentattribute?language=objc)
    pub static NSCategoryDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappearancedocumentattribute?language=objc)
    pub static NSAppearanceDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsexcludedelementsdocumentattribute?language=objc)
    pub static NSExcludedElementsDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextencodingnamedocumentattribute?language=objc)
    pub static NSTextEncodingNameDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsprefixspacesdocumentattribute?language=objc)
    pub static NSPrefixSpacesDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsleftmargindocumentattribute?language=objc)
    pub static NSLeftMarginDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrightmargindocumentattribute?language=objc)
    pub static NSRightMarginDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstopmargindocumentattribute?language=objc)
    pub static NSTopMarginDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbottommargindocumentattribute?language=objc)
    pub static NSBottomMarginDocumentAttribute: &'static NSAttributedStringDocumentAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextencodingnamedocumentoption?language=objc)
    pub static NSTextEncodingNameDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbaseurldocumentoption?language=objc)
    pub static NSBaseURLDocumentOption: &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstimeoutdocumentoption?language=objc)
    pub static NSTimeoutDocumentOption: &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswebpreferencesdocumentoption?language=objc)
    pub static NSWebPreferencesDocumentOption: &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswebresourceloaddelegatedocumentoption?language=objc)
    pub static NSWebResourceLoadDelegateDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstextsizemultiplierdocumentoption?language=objc)
    pub static NSTextSizeMultiplierDocumentOption:
        &'static NSAttributedStringDocumentReadingOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfiletypedocumentoption?language=objc)
    pub static NSFileTypeDocumentOption: &'static NSAttributedStringDocumentReadingOptionKey;
}

mod private_NSAttributedStringAppKitDocumentFormats {
    pub trait Sealed {}
}

/// Category on [`NSAttributedString`].
pub unsafe trait NSAttributedStringAppKitDocumentFormats:
    ClassType + Sized + private_NSAttributedStringAppKitDocumentFormats::Sealed
{
    extern_methods!(
        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithRTF:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithRTF_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithRTFD:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithRTFD_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithHTML:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithHTML_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithHTML:baseURL:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithHTML_baseURL_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            base: &NSURL,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithDocFormat:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithDocFormat_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// - `options` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(initWithHTML:options:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithHTML_options_documentAttributes(
            this: Allocated<Self>,
            data: &NSData,
            options: &NSDictionary<NSAttributedStringDocumentReadingOptionKey, AnyObject>,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(initWithRTFDFileWrapper:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithRTFDFileWrapper_documentAttributes(
            this: Allocated<Self>,
            wrapper: &NSFileWrapper,
            dict: Option<
                &mut Option<
                    Retained<NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>>,
                >,
            >,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(RTFFromRange:documentAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn RTFFromRange_documentAttributes(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Option<Retained<NSData>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(RTFDFromRange:documentAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn RTFDFromRange_documentAttributes(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Option<Retained<NSData>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(RTFDFileWrapperFromRange:documentAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn RTFDFileWrapperFromRange_documentAttributes(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Option<Retained<NSFileWrapper>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[unsafe(method(docFormatFromRange:documentAttributes:))]
        #[unsafe(method_family = none)]
        unsafe fn docFormatFromRange_documentAttributes(
            &self,
            range: NSRange,
            dict: &NSDictionary<NSAttributedStringDocumentAttributeKey, AnyObject>,
        ) -> Option<Retained<NSData>>;
    );
}

impl private_NSAttributedStringAppKitDocumentFormats::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringAppKitDocumentFormats for NSAttributedString {}

mod private_NSAttributedStringAppKitAdditions {
    pub trait Sealed {}
}

/// Category on [`NSAttributedString`].
///
/// ********************** Misc methods ***********************
pub unsafe trait NSAttributedStringAppKitAdditions:
    ClassType + Sized + private_NSAttributedStringAppKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(fontAttributesInRange:))]
        #[unsafe(method_family = none)]
        fn fontAttributesInRange(
            &self,
            range: NSRange,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[unsafe(method(rulerAttributesInRange:))]
        #[unsafe(method_family = none)]
        fn rulerAttributesInRange(
            &self,
            range: NSRange,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[unsafe(method(lineBreakBeforeIndex:withinRange:))]
        #[unsafe(method_family = none)]
        fn lineBreakBeforeIndex_withinRange(
            &self,
            location: NSUInteger,
            a_range: NSRange,
        ) -> NSUInteger;

        #[unsafe(method(lineBreakByHyphenatingBeforeIndex:withinRange:))]
        #[unsafe(method_family = none)]
        fn lineBreakByHyphenatingBeforeIndex_withinRange(
            &self,
            location: NSUInteger,
            a_range: NSRange,
        ) -> NSUInteger;

        #[unsafe(method(doubleClickAtIndex:))]
        #[unsafe(method_family = none)]
        fn doubleClickAtIndex(&self, location: NSUInteger) -> NSRange;

        #[unsafe(method(nextWordFromIndex:forward:))]
        #[unsafe(method_family = none)]
        fn nextWordFromIndex_forward(&self, location: NSUInteger, is_forward: bool) -> NSUInteger;

        #[cfg(feature = "NSTextTable")]
        #[unsafe(method(rangeOfTextBlock:atIndex:))]
        #[unsafe(method_family = none)]
        fn rangeOfTextBlock_atIndex(&self, block: &NSTextBlock, location: NSUInteger) -> NSRange;

        #[cfg(feature = "NSTextTable")]
        #[unsafe(method(rangeOfTextTable:atIndex:))]
        #[unsafe(method_family = none)]
        fn rangeOfTextTable_atIndex(&self, table: &NSTextTable, location: NSUInteger) -> NSRange;

        #[cfg(feature = "NSTextList")]
        #[unsafe(method(rangeOfTextList:atIndex:))]
        #[unsafe(method_family = none)]
        fn rangeOfTextList_atIndex(&self, list: &NSTextList, location: NSUInteger) -> NSRange;

        #[cfg(feature = "NSTextList")]
        #[unsafe(method(itemNumberInTextList:atIndex:))]
        #[unsafe(method_family = none)]
        fn itemNumberInTextList_atIndex(
            &self,
            list: &NSTextList,
            location: NSUInteger,
        ) -> NSInteger;
    );
}

impl private_NSAttributedStringAppKitAdditions::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringAppKitAdditions for NSAttributedString {}

mod private_NSAttributedStringPasteboardAdditions {
    pub trait Sealed {}
}

/// Category on [`NSAttributedString`].
pub unsafe trait NSAttributedStringPasteboardAdditions:
    ClassType + Sized + private_NSAttributedStringPasteboardAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(textTypes))]
        #[unsafe(method_family = none)]
        fn textTypes() -> Retained<NSArray<NSString>>;

        #[unsafe(method(textUnfilteredTypes))]
        #[unsafe(method_family = none)]
        fn textUnfilteredTypes() -> Retained<NSArray<NSString>>;
    );
}

impl private_NSAttributedStringPasteboardAdditions::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringPasteboardAdditions for NSAttributedString {}

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardReading for NSAttributedString {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardWriting for NSAttributedString {}
);

mod private_NSMutableAttributedStringAppKitAdditions {
    pub trait Sealed {}
}

/// Category on [`NSMutableAttributedString`].
pub unsafe trait NSMutableAttributedStringAppKitAdditions:
    ClassType + Sized + private_NSMutableAttributedStringAppKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(superscriptRange:))]
        #[unsafe(method_family = none)]
        fn superscriptRange(&self, range: NSRange);

        #[unsafe(method(subscriptRange:))]
        #[unsafe(method_family = none)]
        fn subscriptRange(&self, range: NSRange);

        #[unsafe(method(unscriptRange:))]
        #[unsafe(method_family = none)]
        fn unscriptRange(&self, range: NSRange);

        #[cfg(feature = "NSFontManager")]
        #[unsafe(method(applyFontTraits:range:))]
        #[unsafe(method_family = none)]
        fn applyFontTraits_range(&self, trait_mask: NSFontTraitMask, range: NSRange);

        #[cfg(feature = "NSText")]
        #[unsafe(method(setAlignment:range:))]
        #[unsafe(method_family = none)]
        fn setAlignment_range(&self, alignment: NSTextAlignment, range: NSRange);

        #[cfg(feature = "NSText")]
        #[unsafe(method(setBaseWritingDirection:range:))]
        #[unsafe(method_family = none)]
        fn setBaseWritingDirection_range(
            &self,
            writing_direction: NSWritingDirection,
            range: NSRange,
        );
    );
}

impl private_NSMutableAttributedStringAppKitAdditions::Sealed for NSMutableAttributedString {}
unsafe impl NSMutableAttributedStringAppKitAdditions for NSMutableAttributedString {}

/// ********************** Deprecated ***********************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinepatternsolid?language=objc)
pub static NSUnderlinePatternSolid: NSUnderlineStyle =
    NSUnderlineStyle(NSUnderlineStyle::PatternSolid.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinepatterndot?language=objc)
pub static NSUnderlinePatternDot: NSUnderlineStyle =
    NSUnderlineStyle(NSUnderlineStyle::PatternDot.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinepatterndash?language=objc)
pub static NSUnderlinePatternDash: NSUnderlineStyle =
    NSUnderlineStyle(NSUnderlineStyle::PatternDash.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinepatterndashdot?language=objc)
pub static NSUnderlinePatternDashDot: NSUnderlineStyle =
    NSUnderlineStyle(NSUnderlineStyle::PatternDashDot.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinepatterndashdotdot?language=objc)
pub static NSUnderlinePatternDashDotDot: NSUnderlineStyle =
    NSUnderlineStyle(NSUnderlineStyle::PatternDashDotDot.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinebyword?language=objc)
pub static NSUnderlineByWord: NSUnderlineStyle = NSUnderlineStyle(NSUnderlineStyle::ByWord.0);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscharactershapeattributename?language=objc)
    #[deprecated = "This attribute is bound to a specific implementation of ATS feature and not generically supported by wide range of fonts. The majority of characters accessed through this API are now encoded in the Unicode standard. Use the CTFont feature API for fine control over character shape choices."]
    pub static NSCharacterShapeAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsusesscreenfontsdocumentattribute?language=objc)
    #[deprecated]
    pub static NSUsesScreenFontsDocumentAttribute: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsobliquenessattributename?language=objc)
    #[deprecated = "This attribute is not supported with TextKit 2"]
    pub static NSObliquenessAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsexpansionattributename?language=objc)
    #[deprecated = "This attribute is not supported with TextKit 2"]
    pub static NSExpansionAttributeName: &'static NSAttributedStringKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsverticalglyphformattributename?language=objc)
    #[deprecated = "This attribute is not supported with TextKit 2"]
    pub static NSVerticalGlyphFormAttributeName: &'static NSAttributedStringKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsnounderlinestyle?language=objc)
#[deprecated = "Use NSUnderlineStyleNone instead"]
pub const NSNoUnderlineStyle: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssingleunderlinestyle?language=objc)
#[deprecated = "Use NSUnderlineStyleSingle instead"]
pub const NSSingleUnderlineStyle: c_uint = 1;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinestrikethroughmask?language=objc)
    #[deprecated = "Use NSStrikethroughStyleAttributeName instead"]
    pub static NSUnderlineStrikethroughMask: NSUInteger;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsunderlinebywordmask?language=objc)
    #[deprecated = "Use NSUnderlineByWord instead"]
    pub static NSUnderlineByWordMask: NSUInteger;
}

mod private_NSAttributedStringNSDeprecatedKitAdditions {
    pub trait Sealed {}
}

/// Category "NSDeprecatedKitAdditions" on [`NSAttributedString`].
#[doc(alias = "NSDeprecatedKitAdditions")]
pub unsafe trait NSAttributedStringNSDeprecatedKitAdditions:
    ClassType + Sized + private_NSAttributedStringNSDeprecatedKitAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(containsAttachments))]
        #[unsafe(method_family = none)]
        fn containsAttachments(&self) -> bool;

        #[deprecated]
        #[unsafe(method(textFileTypes))]
        #[unsafe(method_family = none)]
        fn textFileTypes() -> Retained<NSArray>;

        #[deprecated]
        #[unsafe(method(textPasteboardTypes))]
        #[unsafe(method_family = none)]
        fn textPasteboardTypes() -> Retained<NSArray>;

        #[deprecated]
        #[unsafe(method(textUnfilteredFileTypes))]
        #[unsafe(method_family = none)]
        fn textUnfilteredFileTypes() -> Retained<NSArray>;

        #[deprecated]
        #[unsafe(method(textUnfilteredPasteboardTypes))]
        #[unsafe(method_family = none)]
        fn textUnfilteredPasteboardTypes() -> Retained<NSArray>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[deprecated = "Use -initWithURL:options:documentAttributes:error: instead"]
        #[unsafe(method(initWithURL:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithURL_documentAttributes(
            this: Allocated<Self>,
            url: &NSURL,
            dict: Option<&mut Option<Retained<NSDictionary>>>,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `dict` generic should be of the correct type.
        #[deprecated = "Use -initWithURL:options:documentAttributes:error: instead"]
        #[unsafe(method(initWithPath:documentAttributes:))]
        #[unsafe(method_family = init)]
        unsafe fn initWithPath_documentAttributes(
            this: Allocated<Self>,
            path: &NSString,
            dict: Option<&mut Option<Retained<NSDictionary>>>,
        ) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `effective_range` must be a valid pointer.
        #[deprecated = "Use NSDataDetector instead"]
        #[unsafe(method(URLAtIndex:effectiveRange:))]
        #[unsafe(method_family = none)]
        unsafe fn URLAtIndex_effectiveRange(
            &self,
            location: NSUInteger,
            effective_range: NSRangePointer,
        ) -> Option<Retained<NSURL>>;
    );
}

impl private_NSAttributedStringNSDeprecatedKitAdditions::Sealed for NSAttributedString {}
unsafe impl NSAttributedStringNSDeprecatedKitAdditions for NSAttributedString {}
