/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/event.h>
        #include <wx/event.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    void _wxKeyEvent_SetKeyCode(wxKeyEvent* self, int keyCode)
    {
        self->m_keyCode = keyCode;
    }
    void _wxKeyEvent_SetRawKeyCode(wxKeyEvent* self, int rawKeyCode)
    {
        self->m_rawCode = rawKeyCode;
    }
    void _wxKeyEvent_SetRawKeyFlags(wxKeyEvent* self, int rawFlags)
    {
        self->m_rawFlags = rawFlags;
    }
    void _wxKeyEvent_SetUnicodeKey(wxKeyEvent* self, int uniChar)
    {
        self->m_uniChar = uniChar;
    }


class sipwxKeyEvent : public ::wxKeyEvent
{
public:
    sipwxKeyEvent(::wxEventType);
    sipwxKeyEvent(const ::wxKeyEvent&);
    virtual ~sipwxKeyEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxEvent* Clone() const SIP_OVERRIDE;
    ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxKeyEvent(const sipwxKeyEvent &);
    sipwxKeyEvent &operator = (const sipwxKeyEvent &);

    char sipPyMethods[2];
};

sipwxKeyEvent::sipwxKeyEvent(::wxEventType keyEventType): ::wxKeyEvent(keyEventType), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxKeyEvent::sipwxKeyEvent(const ::wxKeyEvent& a0): ::wxKeyEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxKeyEvent::~sipwxKeyEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxEvent* sipwxKeyEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return ::wxKeyEvent::Clone();

    extern ::wxEvent* sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}

::wxEventCategory sipwxKeyEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return ::wxKeyEvent::GetEventCategory();

    extern ::wxEventCategory sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxKeyEvent_GetPosition, "GetPosition() -> Point\n"
"\n"
"Obtains the position (in client coordinates) at which the key was\n"
"pressed.");

extern "C" {static PyObject *meth_wxKeyEvent_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetKeyCode, "GetKeyCode() -> int\n"
"\n"
"Returns the key code of the key that generated this event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetKeyCode(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetKeyCode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetKeyCode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetKeyCode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_IsKeyInCategory, "IsKeyInCategory(category) -> bool\n"
"\n"
"Returns true if the key is in the given key category.");

extern "C" {static PyObject *meth_wxKeyEvent_IsKeyInCategory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_IsKeyInCategory(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int category;
        const ::wxKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_category,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxKeyEvent, &sipCpp, &category))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsKeyInCategory(category);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_IsKeyInCategory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_IsAutoRepeat, "IsAutoRepeat() -> bool\n"
"\n"
"Returns true if this event is an auto-repeat of the key, false if this\n"
"is the initial key press.");

extern "C" {static PyObject *meth_wxKeyEvent_IsAutoRepeat(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_IsAutoRepeat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsAutoRepeat();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_IsAutoRepeat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetRawKeyCode, "GetRawKeyCode() -> Uint32\n"
"\n"
"Returns the raw key code for this event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetRawKeyCode(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetRawKeyCode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxUint32 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRawKeyCode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetRawKeyCode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetRawKeyFlags, "GetRawKeyFlags() -> Uint32\n"
"\n"
"Returns the low level key flags for this event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetRawKeyFlags(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetRawKeyFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxUint32 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRawKeyFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetRawKeyFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetUnicodeKey, "GetUnicodeKey() -> int\n"
"\n"
"Returns the Unicode character corresponding to this key event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetUnicodeKey(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetUnicodeKey(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUnicodeKey();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetUnicodeKey, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetX, "GetX() -> int\n"
"\n"
"Returns the X position (in client coordinates) of the event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetX(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_GetY, "GetY() -> int\n"
"\n"
"Returns the Y position (in client coordinates) of the event.");

extern "C" {static PyObject *meth_wxKeyEvent_GetY(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_GetY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_GetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_DoAllowNextEvent, "DoAllowNextEvent() -> None\n"
"\n"
"Allow normal key events generation.");

extern "C" {static PyObject *meth_wxKeyEvent_DoAllowNextEvent(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_DoAllowNextEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DoAllowNextEvent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_DoAllowNextEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_IsNextEventAllowed, "IsNextEventAllowed() -> bool\n"
"\n"
"Returns true if DoAllowNextEvent() had been called, false by default.");

extern "C" {static PyObject *meth_wxKeyEvent_IsNextEventAllowed(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_IsNextEventAllowed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNextEventAllowed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_IsNextEventAllowed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_SetKeyCode, "SetKeyCode(keyCode) -> None");

extern "C" {static PyObject *meth_wxKeyEvent_SetKeyCode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_SetKeyCode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int keyCode;
        ::wxKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keyCode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxKeyEvent, &sipCpp, &keyCode))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxKeyEvent_SetKeyCode(sipCpp, keyCode);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_SetKeyCode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_SetRawKeyCode, "SetRawKeyCode(rawKeyCode) -> None");

extern "C" {static PyObject *meth_wxKeyEvent_SetRawKeyCode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_SetRawKeyCode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int rawKeyCode;
        ::wxKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rawKeyCode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxKeyEvent, &sipCpp, &rawKeyCode))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxKeyEvent_SetRawKeyCode(sipCpp, rawKeyCode);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_SetRawKeyCode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_SetRawKeyFlags, "SetRawKeyFlags(rawFlags) -> None");

extern "C" {static PyObject *meth_wxKeyEvent_SetRawKeyFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_SetRawKeyFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int rawFlags;
        ::wxKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rawFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxKeyEvent, &sipCpp, &rawFlags))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxKeyEvent_SetRawKeyFlags(sipCpp, rawFlags);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_SetRawKeyFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_SetUnicodeKey, "SetUnicodeKey(uniChar) -> None");

extern "C" {static PyObject *meth_wxKeyEvent_SetUnicodeKey(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_SetUnicodeKey(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int uniChar;
        ::wxKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_uniChar,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxKeyEvent, &sipCpp, &uniChar))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxKeyEvent_SetUnicodeKey(sipCpp, uniChar);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_SetUnicodeKey, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyEvent_Clone, "Clone(self) -> Event|None");

extern "C" {static PyObject *meth_wxKeyEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxKeyEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyEvent, &sipCpp))
        {
            ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxKeyEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxEvent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyEvent, sipName_Clone, doc_wxKeyEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxKeyEvent(void *, const sipTypeDef *);}
static void *cast_wxKeyEvent(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxKeyEvent *sipCpp = reinterpret_cast< ::wxKeyEvent *>(sipCppV);

    if (targetType == sipType_wxKeyEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxEvent)->ctd_cast(static_cast< ::wxEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    if (targetType == sipType_wxKeyboardState)
        return static_cast< ::wxKeyboardState *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxKeyEvent(void *, int);}
static void release_wxKeyEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxKeyEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxKeyEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxKeyEvent(sipSimpleWrapper *);}
static void dealloc_wxKeyEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxKeyEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxKeyEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxKeyEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxKeyEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxKeyEvent *sipCpp = SIP_NULLPTR;

    {
        ::wxEventType keyEventType = wxEVT_NULL;

        static const char *sipKwdList[] = {
            sipName_keyEventType,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &keyEventType))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxKeyEvent(keyEventType);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxKeyEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxKeyEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxKeyEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxKeyEvent[] = {{151, 255, 0}, {308, 255, 1}};


static PyMethodDef methods_wxKeyEvent[] = {
    {sipName_Clone, meth_wxKeyEvent_Clone, METH_VARARGS, doc_wxKeyEvent_Clone},
    {sipName_DoAllowNextEvent, meth_wxKeyEvent_DoAllowNextEvent, METH_VARARGS, doc_wxKeyEvent_DoAllowNextEvent},
    {sipName_GetKeyCode, meth_wxKeyEvent_GetKeyCode, METH_VARARGS, doc_wxKeyEvent_GetKeyCode},
    {sipName_GetPosition, meth_wxKeyEvent_GetPosition, METH_VARARGS, doc_wxKeyEvent_GetPosition},
    {sipName_GetRawKeyCode, meth_wxKeyEvent_GetRawKeyCode, METH_VARARGS, doc_wxKeyEvent_GetRawKeyCode},
    {sipName_GetRawKeyFlags, meth_wxKeyEvent_GetRawKeyFlags, METH_VARARGS, doc_wxKeyEvent_GetRawKeyFlags},
    {sipName_GetUnicodeKey, meth_wxKeyEvent_GetUnicodeKey, METH_VARARGS, doc_wxKeyEvent_GetUnicodeKey},
    {sipName_GetX, meth_wxKeyEvent_GetX, METH_VARARGS, doc_wxKeyEvent_GetX},
    {sipName_GetY, meth_wxKeyEvent_GetY, METH_VARARGS, doc_wxKeyEvent_GetY},
    {sipName_IsAutoRepeat, meth_wxKeyEvent_IsAutoRepeat, METH_VARARGS, doc_wxKeyEvent_IsAutoRepeat},
    {sipName_IsKeyInCategory, SIP_MLMETH_CAST(meth_wxKeyEvent_IsKeyInCategory), METH_VARARGS|METH_KEYWORDS, doc_wxKeyEvent_IsKeyInCategory},
    {sipName_IsNextEventAllowed, meth_wxKeyEvent_IsNextEventAllowed, METH_VARARGS, doc_wxKeyEvent_IsNextEventAllowed},
    {sipName_SetKeyCode, SIP_MLMETH_CAST(meth_wxKeyEvent_SetKeyCode), METH_VARARGS|METH_KEYWORDS, doc_wxKeyEvent_SetKeyCode},
    {sipName_SetRawKeyCode, SIP_MLMETH_CAST(meth_wxKeyEvent_SetRawKeyCode), METH_VARARGS|METH_KEYWORDS, doc_wxKeyEvent_SetRawKeyCode},
    {sipName_SetRawKeyFlags, SIP_MLMETH_CAST(meth_wxKeyEvent_SetRawKeyFlags), METH_VARARGS|METH_KEYWORDS, doc_wxKeyEvent_SetRawKeyFlags},
    {sipName_SetUnicodeKey, SIP_MLMETH_CAST(meth_wxKeyEvent_SetUnicodeKey), METH_VARARGS|METH_KEYWORDS, doc_wxKeyEvent_SetUnicodeKey}
};

sipVariableDef variables_wxKeyEvent[] = {
    {PropertyVariable, sipName_UnicodeKey, &methods_wxKeyEvent[6], &methods_wxKeyEvent[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RawKeyFlags, &methods_wxKeyEvent[5], &methods_wxKeyEvent[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RawKeyCode, &methods_wxKeyEvent[4], &methods_wxKeyEvent[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxKeyEvent[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_KeyCode, &methods_wxKeyEvent[2], &methods_wxKeyEvent[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Y, &methods_wxKeyEvent[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_X, &methods_wxKeyEvent[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxKeyEvent, "KeyEvent(keyEventType=wxEVT_NULL) -> None\n"
"\n"
"This event class contains information about key press and release\n"
"events.");


sipClassTypeDef sipTypeDef__core_wxKeyEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxKeyEvent,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_KeyEvent,
        {0, 0, 1},
        16, methods_wxKeyEvent,
        0, SIP_NULLPTR,
        7, variables_wxKeyEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxKeyEvent,
    -1,
    -1,
    supers_wxKeyEvent,
    SIP_NULLPTR,
    init_type_wxKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxKeyEvent,
    cast_wxKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxKeyEvent),
};
